/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.comparison.iterables;

import com.intellij.diff.comparison.iterables.ChangeDiffIterableBase;
import com.intellij.diff.fragments.DiffFragment;
import java.util.Collection;
import java.util.Iterator;
import org.jetbrains.annotations.NotNull;

class DiffFragmentsDiffIterable
extends ChangeDiffIterableBase {
    @NotNull
    private final Collection<? extends DiffFragment> myFragments;

    DiffFragmentsDiffIterable(@NotNull Collection<? extends DiffFragment> ranges, int length1, int length2) {
        super(length1, length2);
        this.myFragments = ranges;
    }

    @Override
    @NotNull
    protected ChangeDiffIterableBase.ChangeIterable createChangeIterable() {
        return new FragmentsChangeIterable(this.myFragments);
    }

    private static class FragmentsChangeIterable
    implements ChangeDiffIterableBase.ChangeIterable {
        private final Iterator<? extends DiffFragment> myIterator;
        private DiffFragment myLast;

        private FragmentsChangeIterable(@NotNull Collection<? extends DiffFragment> fragments) {
            this.myIterator = fragments.iterator();
            this.next();
        }

        @Override
        public boolean valid() {
            return this.myLast != null;
        }

        @Override
        public void next() {
            this.myLast = this.myIterator.hasNext() ? this.myIterator.next() : null;
        }

        @Override
        public int getStart1() {
            return this.myLast.getStartOffset1();
        }

        @Override
        public int getStart2() {
            return this.myLast.getStartOffset2();
        }

        @Override
        public int getEnd1() {
            return this.myLast.getEndOffset1();
        }

        @Override
        public int getEnd2() {
            return this.myLast.getEndOffset2();
        }
    }
}

