/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.applications;

import com.intellij.diff.DiffDialogHints;
import com.intellij.diff.DiffManagerEx;
import com.intellij.diff.DiffRequestFactory;
import com.intellij.diff.applications.DiffApplicationBase;
import com.intellij.diff.chains.DiffRequestProducerException;
import com.intellij.diff.merge.MergeRequest;
import com.intellij.diff.merge.MergeRequestProducer;
import com.intellij.diff.merge.MergeResult;
import com.intellij.ide.CliResult;
import com.intellij.idea.SplashManager;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.diff.DiffBundle;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.WindowWrapper;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.Window;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class MergeApplication
extends DiffApplicationBase {
    MergeApplication() {
        super("merge", 3, 4);
    }

    @Override
    @NotNull
    public String getUsageMessage() {
        String scriptName = ApplicationNamesInfo.getInstance().getScriptName();
        return DiffBundle.message((String)"merge.application.usage.parameters.and.description", (Object[])new Object[]{scriptName});
    }

    public int getRequiredModality() {
        return 3;
    }

    @Override
    @NotNull
    public Future<CliResult> processCommand(@NotNull List<String> args, @Nullable String currentDirectory) throws Exception {
        List<String> filePaths = args.subList(1, args.size());
        List<VirtualFile> files2 = MergeApplication.findFiles(filePaths, currentDirectory);
        Project project = MergeApplication.guessProject(files2);
        List<VirtualFile> contents = Arrays.asList(files2.get(0), files2.get(2), files2.get(1));
        VirtualFile outputFile = files2.get(files2.size() - 1);
        if (outputFile == null) {
            throw new Exception("Can't find output file: " + (String)ContainerUtil.getLastItem(filePaths));
        }
        CompletableFuture<CliResult> future2 = new CompletableFuture<CliResult>();
        AtomicReference<CliResult> resultRef = new AtomicReference<CliResult>(new CliResult(127, null));
        ApplicationManager.getApplication().invokeLater(() -> {
            MyMergeRequestProducer requestProducer = new MyMergeRequestProducer(project, outputFile, contents, resultRef);
            WindowWrapper.Mode mode = project != null ? WindowWrapper.Mode.FRAME : WindowWrapper.Mode.MODAL;
            DiffDialogHints dialogHints = new DiffDialogHints(mode, null, wrapper2 -> {
                Window window = wrapper2.getWindow();
                SplashManager.hideBeforeShow(window);
                UIUtil.runWhenWindowClosed((Window)window, () -> future2.complete((CliResult)resultRef.get()));
            });
            DiffManagerEx.getInstance().showMergeBuiltin(project, (MergeRequestProducer)requestProducer, dialogHints);
        });
        return future2;
    }

    private static class MyMergeRequestProducer
    implements MergeRequestProducer {
        private final Project myProject;
        private final VirtualFile myOutputFile;
        private final List<VirtualFile> myContents;
        private final AtomicReference<CliResult> myResultRef;

        private MyMergeRequestProducer(@Nullable Project project, @NotNull VirtualFile outputFile, @NotNull List<VirtualFile> contents, @NotNull AtomicReference<CliResult> resultRef) {
            this.myProject = project;
            this.myOutputFile = outputFile;
            this.myContents = contents;
            this.myResultRef = resultRef;
        }

        @NotNull
        public String getName() {
            return DiffBundle.message((String)"merge.window.title.file", (Object[])new Object[]{this.myOutputFile.getPresentableUrl()});
        }

        @NotNull
        public MergeRequest process(@NotNull UserDataHolder context, @NotNull ProgressIndicator indicator) throws DiffRequestProducerException, ProcessCanceledException {
            try {
                List<VirtualFile> contents = DiffApplicationBase.replaceNullsWithEmptyFile(this.myContents);
                return DiffRequestFactory.getInstance().createMergeRequestFromFiles(this.myProject, this.myOutputFile, contents, result2 -> {
                    int exitCode;
                    try {
                        MergeApplication.saveIfNeeded(this.myOutputFile);
                        exitCode = result2 != MergeResult.CANCEL ? 0 : 1;
                    }
                    catch (Throwable throwable) {
                        int exitCode2 = result2 != MergeResult.CANCEL ? 0 : 1;
                        this.myResultRef.set(new CliResult(exitCode2, null));
                        throw throwable;
                    }
                    this.myResultRef.set(new CliResult(exitCode, null));
                });
            }
            catch (Throwable e) {
                this.myResultRef.set(new CliResult(127, e.getMessage()));
                throw new DiffRequestProducerException(e);
            }
        }
    }
}

