/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.applications;

import com.intellij.diff.DiffDialogHints;
import com.intellij.diff.DiffManagerEx;
import com.intellij.diff.DiffRequestFactory;
import com.intellij.diff.applications.DiffApplicationBase;
import com.intellij.diff.chains.DiffRequestChain;
import com.intellij.diff.chains.DiffRequestProducer;
import com.intellij.diff.chains.DiffRequestProducerException;
import com.intellij.diff.chains.SimpleDiffRequestChain;
import com.intellij.diff.requests.DiffRequest;
import com.intellij.diff.util.DiffUserDataKeys;
import com.intellij.ide.CliResult;
import com.intellij.idea.SplashManager;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.diff.DiffBundle;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.WindowWrapper;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ui.UIUtil;
import java.awt.Window;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class DiffApplication
extends DiffApplicationBase {
    DiffApplication() {
        super("diff", 2, 3);
    }

    @Override
    @NotNull
    public String getUsageMessage() {
        String scriptName = ApplicationNamesInfo.getInstance().getScriptName();
        return DiffBundle.message((String)"diff.application.usage.parameters.and.description", (Object[])new Object[]{scriptName});
    }

    public int getRequiredModality() {
        return 3;
    }

    @Override
    @NotNull
    public Future<CliResult> processCommand(@NotNull List<String> args, @Nullable String currentDirectory) throws Exception {
        List<String> filePaths = args.subList(1, args.size());
        List<VirtualFile> files2 = DiffApplication.findFiles(filePaths, currentDirectory);
        Project project = DiffApplication.guessProject(files2);
        CompletableFuture<CliResult> future2 = new CompletableFuture<CliResult>();
        ApplicationManager.getApplication().invokeLater(() -> {
            SimpleDiffRequestChain chain = SimpleDiffRequestChain.fromProducer((DiffRequestProducer)new MyDiffRequestProducer(project, files2));
            chain.putUserData(DiffUserDataKeys.PLACE, (Object)"External");
            WindowWrapper.Mode mode = project != null ? WindowWrapper.Mode.FRAME : WindowWrapper.Mode.MODAL;
            DiffDialogHints dialogHints = new DiffDialogHints(mode, null, wrapper2 -> {
                Window window = wrapper2.getWindow();
                SplashManager.hideBeforeShow(window);
                UIUtil.runWhenWindowClosed((Window)window, () -> {
                    try {
                        for (VirtualFile file2 : files2) {
                            DiffApplication.saveIfNeeded(file2);
                        }
                    }
                    finally {
                        future2.complete(CliResult.OK);
                    }
                });
            });
            DiffManagerEx.getInstance().showDiffBuiltin(project, (DiffRequestChain)chain, dialogHints);
        });
        return future2;
    }

    private static class MyDiffRequestProducer
    implements DiffRequestProducer {
        private final Project myProject;
        private final List<VirtualFile> myFiles;

        private MyDiffRequestProducer(@Nullable Project project, @NotNull List<VirtualFile> files2) {
            this.myProject = project;
            this.myFiles = files2;
        }

        @NotNull
        public String getName() {
            if (this.myFiles.size() == 3) {
                VirtualFile base = this.myFiles.get(2);
                if (base == null) {
                    return DiffBundle.message((String)"diff.files.dialog.title", (Object[])new Object[0]);
                }
                return DiffRequestFactory.getInstance().getTitle(base);
            }
            return DiffRequestFactory.getInstance().getTitle(this.myFiles.get(0), this.myFiles.get(1));
        }

        @NotNull
        public DiffRequest process(@NotNull UserDataHolder context, @NotNull ProgressIndicator indicator) throws DiffRequestProducerException, ProcessCanceledException {
            if (this.myFiles.size() == 3) {
                List<VirtualFile> nonNullFiles = DiffApplicationBase.replaceNullsWithEmptyFile(this.myFiles);
                return DiffRequestFactory.getInstance().createFromFiles(this.myProject, nonNullFiles.get(0), nonNullFiles.get(2), nonNullFiles.get(1));
            }
            return DiffRequestFactory.getInstance().createFromFiles(this.myProject, this.myFiles.get(0), this.myFiles.get(1));
        }
    }
}

