/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.actions;

import com.intellij.diff.actions.BaseShowDiffAction;
import com.intellij.diff.actions.impl.MutableDiffRequestChain;
import com.intellij.diff.chains.DiffRequestChain;
import com.intellij.diff.contents.DiffContent;
import com.intellij.diff.contents.DocumentContent;
import com.intellij.diff.util.DiffUserDataKeys;
import com.intellij.diff.util.Side;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.fileEditor.ex.FileEditorManagerEx;
import com.intellij.openapi.fileEditor.impl.EditorWindow;
import com.intellij.openapi.fileEditor.impl.EditorWithProviderComposite;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CompareFileWithEditorAction
extends BaseShowDiffAction {
    @Override
    protected boolean isAvailable(@NotNull AnActionEvent e) {
        VirtualFile selectedFile = CompareFileWithEditorAction.getSelectedFile(e);
        if (selectedFile == null) {
            return false;
        }
        VirtualFile currentFile = CompareFileWithEditorAction.getEditingFile(e);
        if (currentFile == null) {
            return false;
        }
        return CompareFileWithEditorAction.canCompare(selectedFile, currentFile);
    }

    @Nullable
    private static VirtualFile getSelectedFile(@NotNull AnActionEvent e) {
        VirtualFile[] array2 = (VirtualFile[])e.getData(CommonDataKeys.VIRTUAL_FILE_ARRAY);
        if (array2 == null || array2.length != 1 || array2[0].isDirectory()) {
            return null;
        }
        return array2[0];
    }

    @Nullable
    private static VirtualFile getEditingFile(@NotNull AnActionEvent e) {
        Project project = e.getProject();
        if (project == null) {
            return null;
        }
        EditorWindow window = FileEditorManagerEx.getInstanceEx(project).getCurrentWindow();
        if (window == null) {
            return null;
        }
        EditorWithProviderComposite editor = window.getSelectedEditor(true);
        return editor == null ? null : editor.getFile();
    }

    private static boolean canCompare(@NotNull VirtualFile file1, @NotNull VirtualFile file2) {
        return !file1.equals(file2) && CompareFileWithEditorAction.hasContent(file1) && CompareFileWithEditorAction.hasContent(file2);
    }

    @Override
    @NotNull
    protected DiffRequestChain getDiffRequestChain(@NotNull AnActionEvent e) {
        Editor editor;
        Project project = e.getProject();
        VirtualFile selectedFile = CompareFileWithEditorAction.getSelectedFile(e);
        VirtualFile currentFile = CompareFileWithEditorAction.getEditingFile(e);
        assert (selectedFile != null && currentFile != null);
        MutableDiffRequestChain chain = CompareFileWithEditorAction.createMutableChainFromFiles(project, selectedFile, currentFile);
        DiffContent editorContent = chain.getContent2();
        if (editorContent instanceof DocumentContent && (editor = (Editor)EditorFactory.getInstance().editors(((DocumentContent)editorContent).getDocument()).findFirst().orElse(null)) != null) {
            int currentLine = editor.getCaretModel().getLogicalPosition().line;
            chain.putRequestUserData(DiffUserDataKeys.SCROLL_TO_LINE, Pair.create((Object)Side.RIGHT, (Object)currentLine));
        }
        return chain;
    }
}

