/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff;

import com.intellij.diff.DiffContentFactoryEx;
import com.intellij.diff.DiffRequestFactory;
import com.intellij.diff.InvalidDiffRequestException;
import com.intellij.diff.contents.DiffContent;
import com.intellij.diff.contents.DocumentContent;
import com.intellij.diff.contents.EmptyContent;
import com.intellij.diff.contents.FileContent;
import com.intellij.diff.merge.MergeCallback;
import com.intellij.diff.merge.MergeRequest;
import com.intellij.diff.merge.MergeResult;
import com.intellij.diff.merge.TextMergeRequest;
import com.intellij.diff.requests.BinaryMergeRequestImpl;
import com.intellij.diff.requests.ContentDiffRequest;
import com.intellij.diff.requests.SimpleDiffRequest;
import com.intellij.diff.requests.TextMergeRequestImpl;
import com.intellij.diff.util.DiffUtil;
import com.intellij.diff.vcs.DiffVcsFacade;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diff.DiffBundle;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.Consumer;
import com.intellij.util.ObjectUtils;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DiffRequestFactoryImpl
extends DiffRequestFactory {
    public static final String DIFF_TITLE_RENAME_SEPARATOR = " -> ";
    private final DiffContentFactoryEx myContentFactory = DiffContentFactoryEx.getInstanceEx();

    @NotNull
    public ContentDiffRequest createFromFiles(@Nullable Project project, @Nullable VirtualFile file1, @Nullable VirtualFile file2) {
        assert (file1 != null || file2 != null);
        EmptyContent content1 = file1 != null ? this.myContentFactory.create(project, file1) : this.myContentFactory.createEmpty();
        EmptyContent content2 = file2 != null ? this.myContentFactory.create(project, file2) : this.myContentFactory.createEmpty();
        String title1 = this.getContentTitle(file1);
        String title2 = this.getContentTitle(file2);
        String title = this.getTitle(file1, file2);
        return new SimpleDiffRequest(title, (DiffContent)content1, (DiffContent)content2, title1, title2);
    }

    @NotNull
    public ContentDiffRequest createFromFiles(@Nullable Project project, @NotNull VirtualFile leftFile, @NotNull VirtualFile baseFile, @NotNull VirtualFile rightFile) {
        DiffContent content1 = this.myContentFactory.create(project, leftFile);
        DiffContent content2 = this.myContentFactory.create(project, baseFile);
        DiffContent content3 = this.myContentFactory.create(project, rightFile);
        String title1 = this.getContentTitle(leftFile);
        String title2 = this.getContentTitle(baseFile);
        String title3 = this.getContentTitle(rightFile);
        return new SimpleDiffRequest(null, content1, content2, content3, title1, title2, title3);
    }

    @NotNull
    public ContentDiffRequest createClipboardVsValue(@NotNull String value2) {
        DiffContent content1 = this.myContentFactory.createClipboardContent();
        DocumentContent content2 = this.myContentFactory.create(value2);
        String title1 = DiffBundle.message((String)"diff.content.clipboard.content.title", (Object[])new Object[0]);
        String title2 = DiffBundle.message((String)"diff.content.selected.value", (Object[])new Object[0]);
        String title = DiffBundle.message((String)"diff.clipboard.vs.value.dialog.title", (Object[])new Object[0]);
        return new SimpleDiffRequest(title, content1, (DiffContent)content2, title1, title2);
    }

    @Nullable
    public String getContentTitle(@Nullable VirtualFile file2) {
        if (file2 == null) {
            return null;
        }
        return DiffRequestFactoryImpl.getContentTitle(DiffVcsFacade.getInstance().getFilePath(file2));
    }

    @NotNull
    public String getTitle(@Nullable VirtualFile file1, @Nullable VirtualFile file2) {
        FilePath path1 = file1 != null ? DiffVcsFacade.getInstance().getFilePath(file1) : null;
        FilePath path2 = file2 != null ? DiffVcsFacade.getInstance().getFilePath(file2) : null;
        return DiffRequestFactoryImpl.getTitle(path1, path2, " vs ");
    }

    @NotNull
    public String getTitle(@NotNull VirtualFile file2) {
        return this.getTitle(file2, null);
    }

    @NotNull
    public static String getContentTitle(@NotNull FilePath path) {
        if (path.isDirectory()) {
            return path.getPresentableUrl();
        }
        FilePath parent = path.getParentPath();
        return DiffRequestFactoryImpl.getContentTitle(path.getName(), path.getPresentableUrl(), parent != null ? parent.getPresentableUrl() : null);
    }

    @NotNull
    public static String getTitle(@Nullable FilePath path1, @Nullable FilePath path2, @NotNull String separator) {
        assert (path1 != null || path2 != null);
        if (path1 == null || path2 == null) {
            return DiffRequestFactoryImpl.getContentTitle((FilePath)ObjectUtils.chooseNotNull((Object)path1, (Object)path2));
        }
        if ((path1.isDirectory() || path2.isDirectory()) && path1.getPath().equals(path2.getPath())) {
            return path1.getPresentableUrl();
        }
        String name1 = path1.getName();
        String name2 = path2.getName();
        if (path1.isDirectory() ^ path2.isDirectory()) {
            if (path1.isDirectory()) {
                name1 = name1 + File.separatorChar;
            }
            if (path2.isDirectory()) {
                name2 = name2 + File.separatorChar;
            }
        }
        FilePath parent1 = path1.getParentPath();
        FilePath parent2 = path2.getParentPath();
        return DiffRequestFactoryImpl.getRequestTitle(name1, path1.getPresentableUrl(), parent1 != null ? parent1.getPresentableUrl() : null, name2, path2.getPresentableUrl(), parent2 != null ? parent2.getPresentableUrl() : null, separator);
    }

    @NotNull
    private static String getContentTitle(@NotNull String name, @NotNull String path, @Nullable String parentPath) {
        if (parentPath != null) {
            return name + " (" + parentPath + ")";
        }
        return path;
    }

    @NotNull
    private static String getRequestTitle(@NotNull String name1, @NotNull String path1, @Nullable String parentPath1, @NotNull String name2, @NotNull String path2, @Nullable String parentPath2, @NotNull String sep) {
        if (path1.equals(path2)) {
            return DiffRequestFactoryImpl.getContentTitle(name1, path1, parentPath1);
        }
        if (Objects.equals(parentPath1, parentPath2)) {
            if (parentPath1 != null) {
                return name1 + sep + name2 + " (" + parentPath1 + ")";
            }
            return path1 + sep + path2;
        }
        if (name1.equals(name2)) {
            if (parentPath1 != null && parentPath2 != null) {
                return name1 + " (" + parentPath1 + sep + parentPath2 + ")";
            }
            return path1 + sep + path2;
        }
        if (parentPath1 != null && parentPath2 != null) {
            return name1 + sep + name2 + " (" + parentPath1 + sep + parentPath2 + ")";
        }
        return path1 + sep + path2;
    }

    @NotNull
    public MergeRequest createMergeRequest(@Nullable Project project, @Nullable FileType fileType, @NotNull Document outputDocument, @NotNull List<String> textContents, @Nullable String title, @NotNull List<String> titles, @Nullable Consumer<? super MergeResult> applyCallback) throws InvalidDiffRequestException {
        if (textContents.size() != 3) {
            throw new IllegalArgumentException();
        }
        if (titles.size() != 3) {
            throw new IllegalArgumentException();
        }
        if (!DiffUtil.canMakeWritable(outputDocument)) {
            throw new InvalidDiffRequestException("Output is read only");
        }
        DocumentContent outputContent = this.myContentFactory.create(project, outputDocument, fileType);
        CharSequence originalContent = outputDocument.getImmutableCharSequence();
        ArrayList<DocumentContent> contents = new ArrayList<DocumentContent>(3);
        for (String text : textContents) {
            contents.add(this.myContentFactory.create(project, text, fileType));
        }
        TextMergeRequestImpl request2 = new TextMergeRequestImpl(project, outputContent, originalContent, contents, title, titles);
        return MergeCallback.register((MergeRequest)request2, applyCallback);
    }

    @NotNull
    public MergeRequest createMergeRequest(@Nullable Project project, @NotNull VirtualFile output, @NotNull List<byte[]> byteContents, @Nullable String title, @NotNull List<String> contentTitles, @Nullable Consumer<? super MergeResult> applyCallback) throws InvalidDiffRequestException {
        MergeRequest request2 = this.createMergeRequest(project, output, byteContents, title, contentTitles);
        return MergeCallback.register((MergeRequest)request2, applyCallback);
    }

    @NotNull
    public MergeRequest createMergeRequest(@Nullable Project project, @NotNull VirtualFile output, @NotNull List<byte[]> byteContents, @Nullable String title, @NotNull List<String> contentTitles) throws InvalidDiffRequestException {
        try {
            return this.createTextMergeRequest(project, output, byteContents, title, contentTitles);
        }
        catch (InvalidDiffRequestException e) {
            return this.createBinaryMergeRequest(project, output, byteContents, title, contentTitles);
        }
    }

    @NotNull
    public TextMergeRequest createTextMergeRequest(@Nullable Project project, @NotNull VirtualFile output, @NotNull List<byte[]> byteContents, @Nullable String title, @NotNull List<String> contentTitles, @Nullable Consumer<? super MergeResult> applyCallback) throws InvalidDiffRequestException {
        TextMergeRequest request2 = this.createTextMergeRequest(project, output, byteContents, title, contentTitles);
        return (TextMergeRequest)MergeCallback.register((MergeRequest)request2, applyCallback);
    }

    @NotNull
    private TextMergeRequest createTextMergeRequest(@Nullable Project project, @NotNull VirtualFile output, @NotNull List<byte[]> byteContents, @Nullable String title, @NotNull List<String> contentTitles) throws InvalidDiffRequestException {
        if (byteContents.size() != 3) {
            throw new IllegalArgumentException();
        }
        if (contentTitles.size() != 3) {
            throw new IllegalArgumentException();
        }
        Document outputDocument = (Document)ReadAction.compute(() -> FileDocumentManager.getInstance().getDocument(output));
        if (outputDocument == null) {
            throw new InvalidDiffRequestException("Can't get output document: " + output.getPresentableUrl());
        }
        if (!DiffUtil.canMakeWritable(outputDocument)) {
            throw new InvalidDiffRequestException("Output is read only: " + output.getPresentableUrl());
        }
        DocumentContent outputContent = this.myContentFactory.create(project, outputDocument);
        CharSequence originalContent = outputDocument.getImmutableCharSequence();
        ArrayList<DocumentContent> contents = new ArrayList<DocumentContent>(3);
        for (byte[] bytes : byteContents) {
            contents.add(this.myContentFactory.createDocumentFromBytes(project, (byte[])ObjectUtils.notNull((Object)bytes, (Object)ArrayUtilRt.EMPTY_BYTE_ARRAY), output));
        }
        return new TextMergeRequestImpl(project, outputContent, originalContent, contents, title, contentTitles);
    }

    @NotNull
    public MergeRequest createBinaryMergeRequest(@Nullable Project project, @NotNull VirtualFile output, @NotNull List<byte[]> byteContents, @Nullable String title, @NotNull List<String> contentTitles, @Nullable Consumer<? super MergeResult> applyCallback) throws InvalidDiffRequestException {
        MergeRequest request2 = this.createBinaryMergeRequest(project, output, byteContents, title, contentTitles);
        return MergeCallback.register((MergeRequest)request2, applyCallback);
    }

    @NotNull
    private MergeRequest createBinaryMergeRequest(@Nullable Project project, @NotNull VirtualFile output, @NotNull List<byte[]> byteContents, @Nullable String title, @NotNull List<String> contentTitles) throws InvalidDiffRequestException {
        if (byteContents.size() != 3) {
            throw new IllegalArgumentException();
        }
        if (contentTitles.size() != 3) {
            throw new IllegalArgumentException();
        }
        try {
            FileContent outputContent = this.myContentFactory.createFile(project, output);
            if (outputContent == null) {
                throw new InvalidDiffRequestException("Can't process file: " + output);
            }
            byte[] originalContent = (byte[])ReadAction.compute(() -> output.contentsToByteArray());
            ArrayList<DiffContent> contents = new ArrayList<DiffContent>(3);
            for (byte[] bytes : byteContents) {
                contents.add(this.myContentFactory.createFromBytes(project, (byte[])ObjectUtils.notNull((Object)bytes, (Object)ArrayUtilRt.EMPTY_BYTE_ARRAY), output));
            }
            return new BinaryMergeRequestImpl(project, outputContent, originalContent, contents, byteContents, title, contentTitles);
        }
        catch (IOException e) {
            throw new InvalidDiffRequestException("Can't read from file", (Throwable)e);
        }
    }

    @NotNull
    public MergeRequest createMergeRequestFromFiles(@Nullable Project project, @NotNull VirtualFile output, @NotNull List<? extends VirtualFile> fileContents, @Nullable Consumer<? super MergeResult> applyCallback) throws InvalidDiffRequestException {
        String title = DiffBundle.message((String)"merge.window.title.file", (Object[])new Object[]{output.getPresentableUrl()});
        List<String> titles = Arrays.asList(DiffBundle.message((String)"merge.version.title.our", (Object[])new Object[0]), DiffBundle.message((String)"merge.version.title.base", (Object[])new Object[0]), DiffBundle.message((String)"merge.version.title.their", (Object[])new Object[0]));
        return this.createMergeRequestFromFiles(project, output, fileContents, title, titles, applyCallback);
    }

    @NotNull
    public MergeRequest createMergeRequestFromFiles(@Nullable Project project, @NotNull VirtualFile output, @NotNull List<? extends VirtualFile> fileContents, @Nullable String title, @NotNull List<String> contentTitles, @Nullable Consumer<? super MergeResult> applyCallback) throws InvalidDiffRequestException {
        if (fileContents.size() != 3) {
            throw new IllegalArgumentException();
        }
        if (contentTitles.size() != 3) {
            throw new IllegalArgumentException();
        }
        try {
            return this.createTextMergeRequestFromFiles(project, output, fileContents, title, contentTitles, applyCallback);
        }
        catch (InvalidDiffRequestException e) {
            return this.createBinaryMergeRequestFromFiles(project, output, fileContents, title, contentTitles, applyCallback);
        }
    }

    @NotNull
    public TextMergeRequest createTextMergeRequestFromFiles(@Nullable Project project, @NotNull VirtualFile output, @NotNull List<? extends VirtualFile> fileContents, @Nullable String title, @NotNull List<String> contentTitles, @Nullable Consumer<? super MergeResult> applyCallback) throws InvalidDiffRequestException {
        ArrayList<byte[]> byteContents = new ArrayList<byte[]>(3);
        for (VirtualFile virtualFile : fileContents) {
            try {
                byteContents.add((byte[])ReadAction.compute(() -> file2.contentsToByteArray()));
            }
            catch (IOException e) {
                throw new InvalidDiffRequestException("Can't read from file: " + virtualFile.getPresentableUrl(), (Throwable)e);
            }
        }
        return this.createTextMergeRequest(project, output, byteContents, title, contentTitles, applyCallback);
    }

    @NotNull
    public MergeRequest createBinaryMergeRequestFromFiles(@Nullable Project project, @NotNull VirtualFile output, @NotNull List<? extends VirtualFile> fileContents, @Nullable String title, @NotNull List<String> contentTitles, @Nullable Consumer<? super MergeResult> applyCallback) throws InvalidDiffRequestException {
        if (fileContents.size() != 3) {
            throw new IllegalArgumentException();
        }
        if (contentTitles.size() != 3) {
            throw new IllegalArgumentException();
        }
        try {
            FileContent outputContent = this.myContentFactory.createFile(project, output);
            if (outputContent == null) {
                throw new InvalidDiffRequestException("Can't process file: " + output.getPresentableUrl());
            }
            byte[] originalContent = (byte[])ReadAction.compute(() -> output.contentsToByteArray());
            ArrayList<DiffContent> contents = new ArrayList<DiffContent>(3);
            ArrayList<byte[]> byteContents = new ArrayList<byte[]>(3);
            for (VirtualFile virtualFile : fileContents) {
                FileContent content2 = this.myContentFactory.createFile(project, virtualFile);
                if (content2 == null) {
                    throw new InvalidDiffRequestException("Can't process file: " + virtualFile.getPresentableUrl());
                }
                contents.add((DiffContent)content2);
                byteContents.add((byte[])ReadAction.compute(() -> file2.contentsToByteArray()));
            }
            BinaryMergeRequestImpl request2 = new BinaryMergeRequestImpl(project, outputContent, originalContent, contents, byteContents, title, contentTitles);
            return MergeCallback.register((MergeRequest)request2, applyCallback);
        }
        catch (IOException e) {
            throw new InvalidDiffRequestException("Can't read from file", (Throwable)e);
        }
    }
}

