/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff;

import com.intellij.codeInsight.daemon.OutsidersPsiFileSupport;
import com.intellij.diff.DiffContentFactoryEx;
import com.intellij.diff.actions.DocumentFragmentContent;
import com.intellij.diff.contents.DiffContent;
import com.intellij.diff.contents.DirectoryContentImpl;
import com.intellij.diff.contents.DocumentContent;
import com.intellij.diff.contents.DocumentContentBase;
import com.intellij.diff.contents.DocumentContentImpl;
import com.intellij.diff.contents.EmptyContent;
import com.intellij.diff.contents.FileContent;
import com.intellij.diff.contents.FileContentImpl;
import com.intellij.diff.contents.FileDocumentContentImpl;
import com.intellij.diff.tools.util.DiffNotifications;
import com.intellij.diff.util.DiffUserDataKeysEx;
import com.intellij.diff.util.DiffUtil;
import com.intellij.diff.vcs.DiffVcsFacade;
import com.intellij.ide.highlighter.ArchiveFileType;
import com.intellij.lang.properties.charset.Native2AsciiCharset;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diff.DiffBundle;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileTypes.BinaryFileTypeDecompilers;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.fileTypes.UIBasedFileType;
import com.intellij.openapi.fileTypes.UnknownFileType;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.encoding.EncodingManager;
import com.intellij.openapi.vfs.encoding.EncodingProjectManager;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.testFramework.BinaryLightVirtualFile;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.ui.LightColors;
import com.intellij.util.LineSeparator;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PathUtil;
import java.awt.datatransfer.DataFlavor;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import javax.swing.JComponent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DiffContentFactoryImpl
extends DiffContentFactoryEx {
    private static final Logger LOG = Logger.getInstance(DiffContentFactoryImpl.class);

    @NotNull
    public EmptyContent createEmpty() {
        return new EmptyContent();
    }

    @NotNull
    public DocumentContent create(@NotNull String text) {
        return this.create(null, text);
    }

    @NotNull
    public DocumentContent create(@NotNull String text, @Nullable FileType type) {
        return this.create(null, text, type);
    }

    @NotNull
    public DocumentContent create(@NotNull String text, @Nullable FileType type, boolean respectLineSeparators) {
        return this.create(null, text, type, respectLineSeparators);
    }

    @NotNull
    public DocumentContent create(@NotNull String text, @Nullable VirtualFile highlightFile) {
        return this.create(null, text, highlightFile);
    }

    @NotNull
    public DocumentContent create(@NotNull String text, @Nullable DocumentContent referent) {
        return this.create(null, text, referent);
    }

    @NotNull
    public DocumentContent create(@Nullable Project project, @NotNull String text) {
        return this.create(project, text, (FileType)null);
    }

    @NotNull
    public DocumentContent create(@Nullable Project project, @NotNull String text, @Nullable FileType type) {
        return this.create(project, text, type, true);
    }

    @NotNull
    public DocumentContent create(@Nullable Project project, @NotNull String text, @Nullable FileType type, boolean respectLineSeparators) {
        return this.readOnlyDocumentContent(project).contextByFileType(type).buildFromText(text, respectLineSeparators);
    }

    @Override
    @NotNull
    public DocumentContent create(@Nullable Project project, @NotNull String text, @NotNull FilePath filePath) {
        return this.readOnlyDocumentContent(project).contextByFilePath(filePath).buildFromText(text, true);
    }

    @NotNull
    public DocumentContent create(@Nullable Project project, @NotNull String text, @Nullable VirtualFile highlightFile) {
        return this.readOnlyDocumentContent(project).contextByHighlightFile(highlightFile).buildFromText(text, true);
    }

    @NotNull
    public DocumentContent create(@Nullable Project project, @NotNull String text, @Nullable DocumentContent referent) {
        if (referent == null) {
            return this.create(text);
        }
        return this.readOnlyDocumentContent(project).contextByReferent(referent).buildFromText(text, true);
    }

    @NotNull
    public DocumentContent createEditable(@Nullable Project project, @NotNull String text, @Nullable FileType fileType) {
        return this.documentContent(project, false).contextByFileType(fileType).buildFromText(text, true);
    }

    @NotNull
    public DocumentContent create(@NotNull Document document, @Nullable DocumentContent referent) {
        return this.create(null, document, referent);
    }

    @NotNull
    public DocumentContent create(@Nullable Project project, @NotNull Document document) {
        return this.create(project, document, (FileType)null);
    }

    @NotNull
    public DocumentContent create(@Nullable Project project, @NotNull Document document, @Nullable FileType fileType) {
        VirtualFile file2 = FileDocumentManager.getInstance().getFile(document);
        if (file2 != null) {
            return new FileDocumentContentImpl(project, document, file2);
        }
        return new DocumentContentImpl(project, document, fileType);
    }

    @NotNull
    public DocumentContent create(@Nullable Project project, @NotNull Document document, @Nullable VirtualFile highlightFile) {
        VirtualFile file2 = FileDocumentManager.getInstance().getFile(document);
        if (file2 != null && file2.equals(highlightFile)) {
            return new FileDocumentContentImpl(project, document, file2);
        }
        if (highlightFile == null) {
            return new DocumentContentImpl(document);
        }
        return new FileReferentDocumentContent(project, document, highlightFile);
    }

    @NotNull
    public DocumentContent create(@Nullable Project project, @NotNull Document document, @Nullable DocumentContent referent) {
        if (referent == null) {
            return new DocumentContentImpl(document);
        }
        return new ContentReferentDocumentContent(project, document, referent);
    }

    @NotNull
    public DiffContent create(@Nullable Project project, @NotNull VirtualFile file2) {
        return DiffContentFactoryImpl.createContentFromFile(project, file2);
    }

    @Nullable
    public DocumentContent createDocument(@Nullable Project project, @NotNull VirtualFile file2) {
        return (DocumentContent)ObjectUtils.tryCast((Object)DiffContentFactoryImpl.createContentFromFile(project, file2), DocumentContent.class);
    }

    @Nullable
    public FileContent createFile(@Nullable Project project, @NotNull VirtualFile file2) {
        if (file2.isDirectory()) {
            return null;
        }
        return (FileContent)this.create(project, file2);
    }

    @NotNull
    public DocumentContent createFragment(@Nullable Project project, @NotNull Document document, @NotNull TextRange range2) {
        DocumentContent content2 = this.create(project, document);
        return this.createFragment(project, content2, range2);
    }

    @NotNull
    public DocumentContent createFragment(@Nullable Project project, @NotNull DocumentContent content2, @NotNull TextRange range2) {
        return new DocumentFragmentContent(project, content2, range2);
    }

    @NotNull
    public DiffContent createClipboardContent() {
        return this.createClipboardContent(null, null);
    }

    @NotNull
    public DocumentContent createClipboardContent(@Nullable DocumentContent referent) {
        return this.createClipboardContent(null, referent);
    }

    @NotNull
    public DiffContent createClipboardContent(@Nullable Project project) {
        return this.createClipboardContent(project, null);
    }

    @NotNull
    public DocumentContent createClipboardContent(@Nullable Project project, @Nullable DocumentContent referent) {
        String text = StringUtil.notNullize((String)((String)CopyPasteManager.getInstance().getContents(DataFlavor.stringFlavor)));
        return this.documentContent(project, false).contextByReferent(referent).withFileName("Clipboard.txt").buildFromText(text, false);
    }

    @Override
    @NotNull
    public DiffContent createFromBytes(@Nullable Project project, byte @NotNull [] content2, @NotNull FilePath filePath) throws IOException {
        return this.createFromBytes(project, content2, filePath, null);
    }

    @Override
    @NotNull
    public DiffContent createFromBytes(@Nullable Project project, byte @NotNull [] content2, @NotNull FilePath filePath, @Nullable Charset defaultCharset) throws IOException {
        if (defaultCharset == null && DiffContentFactoryImpl.isBinaryContent(content2, filePath.getFileType())) {
            return DiffContentFactoryImpl.createBinaryImpl(project, content2, filePath.getFileType(), filePath, filePath.getVirtualFile());
        }
        return this.createDocumentFromBytes(project, content2, filePath, defaultCharset);
    }

    @NotNull
    public DiffContent createFromBytes(@Nullable Project project, byte @NotNull [] content2, @NotNull FileType fileType, @NotNull String fileName) throws IOException {
        if (DiffContentFactoryImpl.isBinaryContent(content2, fileType)) {
            return DiffContentFactoryImpl.createBinaryImpl(project, content2, fileType, DiffVcsFacade.getInstance().getFilePath(fileName), null);
        }
        return this.createDocumentFromBytes(project, content2, fileType, fileName);
    }

    @Override
    @NotNull
    public DiffContent createFromBytes(@Nullable Project project, byte @NotNull [] content2, @NotNull VirtualFile highlightFile) throws IOException {
        if (DiffContentFactoryImpl.isBinaryContent(content2, highlightFile.getFileType())) {
            return DiffContentFactoryImpl.createBinaryImpl(project, content2, highlightFile.getFileType(), DiffVcsFacade.getInstance().getFilePath(highlightFile), highlightFile);
        }
        return this.createDocumentFromBytes(project, content2, highlightFile);
    }

    @Override
    @NotNull
    public DocumentContent createDocumentFromBytes(@Nullable Project project, byte @NotNull [] content2, @NotNull FileType fileType, @NotNull String fileName) {
        Charset charset = DiffContentFactoryImpl.guessCharset(project, content2, fileType);
        return this.readOnlyDocumentContent(project).contextByFileType(fileType).withFileName(fileName).buildFromBytes(content2, charset);
    }

    @Override
    @NotNull
    public DocumentContent createDocumentFromBytes(@Nullable Project project, byte @NotNull [] content2, @NotNull FilePath filePath) {
        Charset charset = DiffContentFactoryImpl.guessCharset(project, content2, filePath);
        return this.readOnlyDocumentContent(project).contextByFilePath(filePath).buildFromBytes(content2, charset);
    }

    @NotNull
    private DocumentContent createDocumentFromBytes(@Nullable Project project, byte @NotNull [] content2, @NotNull FilePath filePath, @Nullable Charset defaultCharset) {
        Charset charset = DiffContentFactoryImpl.guessCharset(project, content2, filePath, defaultCharset);
        return this.readOnlyDocumentContent(project).contextByFilePath(filePath).buildFromBytes(content2, charset);
    }

    @Override
    @NotNull
    public DocumentContent createDocumentFromBytes(@Nullable Project project, byte @NotNull [] content2, @NotNull VirtualFile highlightFile) {
        Charset charset = DiffContentFactoryImpl.guessCharset(project, content2, highlightFile);
        return this.readOnlyDocumentContent(project).contextByHighlightFile(highlightFile).buildFromBytes(content2, charset);
    }

    @NotNull
    public DiffContent createBinary(@Nullable Project project, byte @NotNull [] content2, @NotNull FileType type, @NotNull String fileName) throws IOException {
        return DiffContentFactoryImpl.createBinaryImpl(project, content2, type, DiffVcsFacade.getInstance().getFilePath(fileName), null);
    }

    @NotNull
    private static DiffContent createContentFromFile(@Nullable Project project, @NotNull VirtualFile file2) {
        return DiffContentFactoryImpl.createContentFromFile(project, file2, file2);
    }

    @NotNull
    private static DiffContent createContentFromFile(@Nullable Project project, @NotNull VirtualFile file2, @Nullable VirtualFile highlightFile) {
        if (file2.isDirectory()) {
            return new DirectoryContentImpl(project, file2, highlightFile);
        }
        Document document = (Document)ReadAction.compute(() -> FileDocumentManager.getInstance().getDocument(file2));
        if (document != null) {
            return new FileDocumentContentImpl(project, document, file2, highlightFile);
        }
        return new FileContentImpl(project, file2, highlightFile);
    }

    @NotNull
    private static DiffContent createBinaryImpl(@Nullable Project project, byte @NotNull [] content2, @NotNull FileType type, @NotNull FilePath path, @Nullable VirtualFile highlightFile) throws IOException {
        Object file2;
        boolean useTemporalFile;
        boolean bl = useTemporalFile = type instanceof ArchiveFileType || BinaryFileTypeDecompilers.getInstance().forFileType(type) != null;
        if (useTemporalFile) {
            file2 = DiffContentFactoryImpl.createTemporalFile(path.getName(), content2);
        } else {
            file2 = new MyBinaryLightVirtualFile(path, type, content2);
            file2.setWritable(false);
        }
        file2.putUserData(DiffUtil.TEMP_FILE_KEY, (Object)Boolean.TRUE);
        return DiffContentFactoryImpl.createContentFromFile(project, file2, highlightFile);
    }

    @NotNull
    private static VirtualFile createTemporalFile(@NonNls @NotNull String suffix, byte @NotNull [] content2) throws IOException {
        VirtualFile file2;
        File tempFile = FileUtil.createTempFile((String)"tmp_", (String)PathUtil.suggestFileName((String)("_" + suffix), (boolean)true, (boolean)false), (boolean)true);
        if (content2.length != 0) {
            FileUtil.writeToFile((File)tempFile, (byte[])content2);
        }
        if (!tempFile.setWritable(false, false)) {
            LOG.warn("Can't set writable attribute of temporal file");
        }
        if ((file2 = VfsUtil.findFileByIoFile((File)tempFile, (boolean)true)) == null) {
            throw new IOException("Can't create temp file for revision content");
        }
        VfsUtil.markDirtyAndRefresh((boolean)true, (boolean)true, (boolean)true, (VirtualFile[])new VirtualFile[]{file2});
        return file2;
    }

    @NotNull
    private static Document createDocument(@Nullable Project project, @NotNull String content2, @Nullable FileType fileType, @NonNls @NotNull FilePath filePath, boolean readOnly) {
        Document document = DiffContentFactoryImpl.createPsiDocument(project, content2, fileType, filePath, readOnly);
        if (document == null) {
            document = EditorFactory.getInstance().createDocument((CharSequence)content2);
            document.setReadOnly(readOnly);
        }
        return document;
    }

    @Nullable
    private static Document createPsiDocument(@Nullable Project project, @NotNull String content2, @Nullable FileType fileType, @NonNls @NotNull FilePath filePath, boolean readOnly) {
        if (project == null || project.isDefault()) {
            return null;
        }
        if (fileType == null || fileType.isBinary()) {
            return null;
        }
        MyLightVirtualFile file2 = new MyLightVirtualFile(filePath, fileType, content2);
        file2.setWritable(!readOnly);
        Document document = (Document)ReadAction.compute(() -> FileDocumentManager.getInstance().getDocument((VirtualFile)file2));
        if (document == null) {
            return null;
        }
        ReadAction.run(() -> PsiDocumentManager.getInstance((Project)project).getPsiFile(document));
        return document;
    }

    private static boolean isBinaryContent(byte @NotNull [] content2, @NotNull FileType fileType) {
        if (UnknownFileType.INSTANCE.equals(fileType)) {
            return DiffContentFactoryImpl.guessCharsetFromContent(content2) == null;
        }
        if (fileType instanceof UIBasedFileType) {
            return true;
        }
        return fileType.isBinary();
    }

    @NotNull
    public static Charset guessCharset(@Nullable Project project, byte @NotNull [] content2, @NotNull FilePath filePath) {
        return DiffContentFactoryImpl.guessCharset(project, content2, filePath, null);
    }

    @NotNull
    private static Charset guessCharset(@Nullable Project project, byte @NotNull [] content2, @NotNull FilePath filePath, @Nullable Charset defaultCharset) {
        EncodingManager e;
        Charset propertiesCharset;
        FileType fileType = filePath.getFileType();
        Charset charset = DiffContentFactoryImpl.guessCharsetFromContent(content2, fileType);
        if (charset != null) {
            return charset;
        }
        if (defaultCharset != null) {
            return defaultCharset;
        }
        if (fileType == StdFileTypes.PROPERTIES && (propertiesCharset = (e = project != null ? EncodingProjectManager.getInstance((Project)project) : EncodingManager.getInstance()).getDefaultCharsetForPropertiesFiles(null)) != null) {
            if (e.isNative2AsciiForPropertiesFiles()) {
                return Native2AsciiCharset.wrap((Charset)propertiesCharset);
            }
            return propertiesCharset;
        }
        return filePath.getCharset(project);
    }

    @NotNull
    public static Charset guessCharset(@Nullable Project project, byte @NotNull [] content2, @NotNull VirtualFile highlightFile) {
        Charset charset = DiffContentFactoryImpl.guessCharsetFromContent(content2, highlightFile.getFileType());
        if (charset != null) {
            return charset;
        }
        return highlightFile.getCharset();
    }

    @NotNull
    public static Charset guessCharset(@Nullable Project project, byte @NotNull [] content2, @NotNull FileType fileType) {
        Charset charset = DiffContentFactoryImpl.guessCharsetFromContent(content2, fileType);
        if (charset != null) {
            return charset;
        }
        EncodingManager e = project != null ? EncodingProjectManager.getInstance((Project)project) : EncodingManager.getInstance();
        return e.getDefaultCharset();
    }

    @Nullable
    private static Charset guessCharsetFromContent(byte @NotNull [] content2, @NotNull FileType fileType) {
        Charset guessedCharset;
        Charset bomCharset = CharsetToolkit.guessFromBOM((byte[])content2);
        if (bomCharset != null) {
            return bomCharset;
        }
        if (fileType.isBinary() && (guessedCharset = DiffContentFactoryImpl.guessCharsetFromContent(content2)) != null) {
            return guessedCharset;
        }
        return null;
    }

    @Nullable
    private static Charset guessCharsetFromContent(byte @NotNull [] content2) {
        CharsetToolkit toolkit = new CharsetToolkit(content2);
        Charset fromBOM = toolkit.guessFromBOM();
        if (fromBOM != null) {
            return fromBOM;
        }
        CharsetToolkit.GuessedEncoding guessedEncoding = toolkit.guessFromContent(content2.length);
        switch (guessedEncoding) {
            case SEVEN_BIT: {
                return StandardCharsets.US_ASCII;
            }
            case VALID_UTF8: {
                return StandardCharsets.UTF_8;
            }
        }
        return null;
    }

    @NotNull
    private DiffContentFactoryEx.DocumentContentBuilder readOnlyDocumentContent(@Nullable Project project) {
        return this.documentContent(project, true);
    }

    @Override
    @NotNull
    public DiffContentFactoryEx.DocumentContentBuilder documentContent(@Nullable Project project, boolean readOnly) {
        return new DocumentContentBuilderImpl(project).withReadOnly(readOnly);
    }

    private static interface Context {
        @Nullable
        public VirtualFile getHighlightFile();

        @Nullable
        public FileType getContentType();

        public static class ByFileType
        implements Context {
            private final FileType myFileType;

            public ByFileType(@NotNull FileType fileType) {
                this.myFileType = fileType;
            }

            @Override
            @Nullable
            public VirtualFile getHighlightFile() {
                return null;
            }

            @Override
            @Nullable
            public FileType getContentType() {
                return this.myFileType;
            }
        }

        public static class ByFilePath
        implements Context {
            private final FilePath myFilePath;

            public ByFilePath(@NotNull FilePath filePath) {
                this.myFilePath = filePath;
            }

            @Override
            @Nullable
            public VirtualFile getHighlightFile() {
                return this.myFilePath.getVirtualFile();
            }

            @Override
            @Nullable
            public FileType getContentType() {
                return this.myFilePath.getFileType();
            }
        }

        public static class ByReferent
        implements Context {
            private final DocumentContent myReferent;

            public ByReferent(@NotNull DocumentContent referent) {
                this.myReferent = referent;
            }

            @Override
            @Nullable
            public VirtualFile getHighlightFile() {
                return this.myReferent.getHighlightFile();
            }

            @Override
            @Nullable
            public FileType getContentType() {
                return this.myReferent.getContentType();
            }
        }

        public static class ByHighlightFile
        implements Context {
            private final VirtualFile myHighlightFile;

            public ByHighlightFile(@NotNull VirtualFile highlightFile) {
                this.myHighlightFile = highlightFile;
            }

            @Override
            @Nullable
            public VirtualFile getHighlightFile() {
                return this.myHighlightFile;
            }

            @Override
            @Nullable
            public FileType getContentType() {
                return this.myHighlightFile.getFileType();
            }
        }
    }

    private static class TextContent {
        @NotNull
        public final String text;
        @Nullable
        public LineSeparator separators;
        @Nullable
        public Charset charset;
        @Nullable
        public Boolean isBom;
        @Nullable
        public JComponent notification;

        TextContent(@NotNull String text) {
            this.text = text;
        }

        @NotNull
        public static TextContent fromText(@NotNull String text, boolean respectLineSeparators) {
            String correctedContent = StringUtil.convertLineSeparators((String)text);
            TextContent textContent = new TextContent(correctedContent);
            if (respectLineSeparators) {
                textContent.separators = StringUtil.detectSeparators((CharSequence)text);
            }
            return textContent;
        }

        @NotNull
        public static TextContent fromBytes(byte @NotNull [] content2, @NotNull Charset charset) {
            boolean isBom = CharsetToolkit.guessFromBOM((byte[])content2) != null;
            boolean malformedContent = false;
            String text = CharsetToolkit.tryDecodeString((byte[])content2, (Charset)charset);
            if (text == null) {
                text = CharsetToolkit.decodeString((byte[])content2, (Charset)charset);
                malformedContent = true;
            }
            TextContent textContent = TextContent.fromText(text, true);
            textContent.charset = charset;
            textContent.isBom = isBom;
            if (malformedContent) {
                String notificationText = DiffBundle.message((String)"error.content.decoded.with.wrong.charset", (Object[])new Object[]{charset.name()});
                textContent.notification = DiffNotifications.createNotification(notificationText, LightColors.RED);
            }
            return textContent;
        }
    }

    private static class ContextReferentDocumentContent
    extends DocumentContentBase {
        @Nullable
        private final LineSeparator mySeparator;
        @Nullable
        private final Charset myCharset;
        @Nullable
        private final Boolean myBOM;
        @Nullable
        private final Context myReferent;

        private ContextReferentDocumentContent(@Nullable Project project, @NotNull Document document, @NotNull TextContent content2, @Nullable Context referent) {
            super(project, document);
            this.mySeparator = content2.separators;
            this.myCharset = content2.charset;
            this.myBOM = content2.isBom;
            this.myReferent = referent;
        }

        @Nullable
        public FileType getContentType() {
            return this.myReferent != null ? this.myReferent.getContentType() : null;
        }

        @Nullable
        public VirtualFile getHighlightFile() {
            return this.myReferent != null ? this.myReferent.getHighlightFile() : null;
        }

        @Nullable
        public LineSeparator getLineSeparator() {
            return this.mySeparator;
        }

        @Nullable
        public Charset getCharset() {
            return this.myCharset;
        }

        @Nullable
        public Boolean hasBom() {
            return this.myBOM;
        }
    }

    private static class ContentReferentDocumentContent
    extends DocumentContentBase {
        @NotNull
        private final DocumentContent myReferent;

        private ContentReferentDocumentContent(@Nullable Project project, @NotNull Document document, @NotNull DocumentContent referent) {
            super(project, document);
            this.myReferent = referent;
        }

        @Nullable
        public FileType getContentType() {
            return this.myReferent.getContentType();
        }

        @Nullable
        public VirtualFile getHighlightFile() {
            return this.myReferent.getHighlightFile();
        }
    }

    private static class FileReferentDocumentContent
    extends DocumentContentBase {
        @NotNull
        private final VirtualFile myHighlightFile;

        private FileReferentDocumentContent(@Nullable Project project, @NotNull Document document, @NotNull VirtualFile highlightFile) {
            super(project, document);
            this.myHighlightFile = highlightFile;
        }

        @NotNull
        public FileType getContentType() {
            return this.myHighlightFile.getFileType();
        }

        @NotNull
        public VirtualFile getHighlightFile() {
            return this.myHighlightFile;
        }
    }

    private static class MyBinaryLightVirtualFile
    extends BinaryLightVirtualFile {
        private final FilePath myPath;

        MyBinaryLightVirtualFile(@NotNull FilePath path, @Nullable FileType type, byte @NotNull [] content2) {
            super(path.getName(), type, content2);
            this.myPath = path;
        }

        @NotNull
        public String getPath() {
            return this.myPath.getPath();
        }
    }

    private static class MyLightVirtualFile
    extends LightVirtualFile {
        private final FilePath myPath;

        private MyLightVirtualFile(@NotNull FilePath path, @Nullable FileType fileType, @NotNull String content2) {
            super(path.getName(), fileType, (CharSequence)content2);
            this.myPath = path;
        }

        @NotNull
        public String getPath() {
            return this.myPath.getPath();
        }
    }

    private static class DocumentContentBuilderImpl
    implements DiffContentFactoryEx.DocumentContentBuilder {
        @Nullable
        private final Project project;
        private boolean readOnly;
        @Nullable
        private Context context;
        @Nullable
        private FilePath originalFilePath;
        @Nullable
        @NonNls
        private String fileName;

        DocumentContentBuilderImpl(@Nullable Project project) {
            this.project = project;
        }

        @NotNull
        public DiffContentFactoryEx.DocumentContentBuilder withReadOnly(boolean readOnly) {
            this.readOnly = readOnly;
            return this;
        }

        @Override
        @NotNull
        public DiffContentFactoryEx.DocumentContentBuilder withFileName(@Nullable String fileName) {
            this.fileName = fileName;
            return this;
        }

        @Override
        @NotNull
        public DiffContentFactoryEx.DocumentContentBuilder contextByFileType(@Nullable FileType fileType) {
            if (fileType != null) {
                this.context = new Context.ByFileType(fileType);
            }
            return this;
        }

        @Override
        @NotNull
        public DiffContentFactoryEx.DocumentContentBuilder contextByFilePath(@Nullable FilePath filePath) {
            if (filePath != null) {
                this.context = new Context.ByFilePath(filePath);
                this.originalFilePath = filePath;
                this.fileName = filePath.getName();
            }
            return this;
        }

        @Override
        @NotNull
        public DiffContentFactoryEx.DocumentContentBuilder contextByHighlightFile(@Nullable VirtualFile file2) {
            if (file2 != null) {
                this.context = new Context.ByHighlightFile(file2);
                this.originalFilePath = DiffVcsFacade.getInstance().getFilePath(file2);
                this.fileName = file2.getName();
            }
            return this;
        }

        @Override
        @NotNull
        public DiffContentFactoryEx.DocumentContentBuilder contextByReferent(@Nullable DocumentContent referent) {
            if (referent != null) {
                this.context = new Context.ByReferent(referent);
                VirtualFile file2 = referent.getHighlightFile();
                if (file2 != null) {
                    this.originalFilePath = DiffVcsFacade.getInstance().getFilePath(file2);
                    this.fileName = file2.getName();
                }
            }
            return this;
        }

        @Override
        @NotNull
        public DocumentContent buildFromText(@NotNull String text, boolean respectLineSeparators) {
            return this.build(TextContent.fromText(text, respectLineSeparators));
        }

        @Override
        @NotNull
        public DocumentContent buildFromBytes(byte @NotNull [] content2, @NotNull Charset charset) {
            return this.build(TextContent.fromBytes(content2, charset));
        }

        @NotNull
        private DocumentContent build(@NotNull TextContent textContent) {
            FileType fileType = this.context != null ? this.context.getContentType() : null;
            FilePath filePath = this.originalFilePath;
            if (filePath == null) {
                String name = this.fileName;
                if (name == null) {
                    name = "diff." + StringUtil.defaultIfEmpty((String)(fileType != null ? fileType.getDefaultExtension() : null), (String)"txt");
                }
                filePath = DiffVcsFacade.getInstance().getFilePath(name);
            }
            Document document = DiffContentFactoryImpl.createDocument(this.project, textContent.text, fileType, filePath, this.readOnly);
            ContextReferentDocumentContent documentContent = new ContextReferentDocumentContent(this.project, document, textContent, this.context);
            VirtualFile file2 = FileDocumentManager.getInstance().getFile(document);
            if (file2 instanceof LightVirtualFile) {
                OutsidersPsiFileSupport.markFile(file2, this.originalFilePath != null ? this.originalFilePath.getPath() : null);
            }
            if (this.fileName != null) {
                documentContent.putUserData(DiffUserDataKeysEx.FILE_NAME, this.fileName);
            }
            if (textContent.notification != null) {
                DiffUtil.addNotification(textContent.notification, (UserDataHolder)documentContent);
            }
            return documentContent;
        }
    }
}

