/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagnostic;

import com.intellij.diagnostic.errordialog.PluginConflictDialog;
import com.intellij.ide.plugins.PluginConflictReporter;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.ide.plugins.cl.PluginClassLoader;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.PluginId;
import java.awt.EventQueue;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import org.jetbrains.annotations.NotNull;

final class GuiPluginConflictReporter
implements PluginConflictReporter {
    GuiPluginConflictReporter() {
    }

    public void reportConflictByClasses(@NotNull Collection<Class<?>> conflictingClasses) {
        HashSet<PluginId> foundPlugins = new HashSet<PluginId>();
        boolean hasConflictWithPlatform = false;
        if (conflictingClasses.size() < 2) {
            Logger.getInstance(GuiPluginConflictReporter.class).warn("One should provide at least two conflicting classes to report");
            return;
        }
        for (Class<?> aClass : conflictingClasses) {
            ClassLoader classLoader = aClass.getClassLoader();
            if (classLoader instanceof PluginClassLoader) {
                foundPlugins.add(((PluginClassLoader)((Object)classLoader)).getPluginId());
                continue;
            }
            hasConflictWithPlatform = true;
        }
        if (foundPlugins.isEmpty()) {
            Logger.getInstance(GuiPluginConflictReporter.class).warn("The conflict has not come from PluginClassLoader");
            return;
        }
        boolean finalHasConflictWithPlatform = hasConflictWithPlatform;
        Runnable task2 = () -> new PluginConflictDialog(new ArrayList<PluginId>(foundPlugins), finalHasConflictWithPlatform).show();
        if (EventQueue.isDispatchThread()) {
            task2.run();
        } else {
            try {
                EventQueue.invokeAndWait(task2);
            }
            catch (InterruptedException | InvocationTargetException e) {
                PluginManagerCore.getLogger().error((Throwable)e);
            }
        }
    }
}

