/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagnostic;

import com.intellij.diagnostic.EventWatcher;
import com.intellij.diagnostic.LoadingState;
import com.intellij.diagnostic.LockKind;
import com.intellij.diagnostic.RunnablesListener;
import com.intellij.diagnostic.StartUpMeasurer;
import com.intellij.ide.plugins.cl.PluginClassLoader;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.messages.MessageBus;
import java.awt.AWTEvent;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Queue;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.regex.MatchResult;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Experimental
public final class EventWatcherImpl
implements EventWatcher,
Disposable {
    private static final int PUBLISHER_INITIAL_DELAY = 100;
    private static final int PUBLISHER_PERIOD = 1000;
    @NotNull
    private static final Logger LOG = Logger.getInstance(EventWatcherImpl.class);
    @NotNull
    private static final Pattern DESCRIPTION_BY_EVENT = Pattern.compile("(([\\p{L}_$][\\p{L}\\p{N}_$]*\\.)*[\\p{L}_$][\\p{L}\\p{N}_$]*)\\[(?<description>\\w+(,runnable=(?<runnable>[^,]+))?[^]]*)].*");
    @NotNull
    private final ConcurrentMap<String, RunnablesListener.WrapperDescription> myWrappers = new ConcurrentHashMap<String, RunnablesListener.WrapperDescription>();
    @NotNull
    private final ConcurrentMap<String, RunnablesListener.InvocationsInfo> myDurationsByFqn = new ConcurrentHashMap<String, RunnablesListener.InvocationsInfo>();
    @NotNull
    private final ConcurrentLinkedQueue<RunnablesListener.InvocationDescription> myRunnables = new ConcurrentLinkedQueue();
    @NotNull
    private final ConcurrentMap<Class<? extends AWTEvent>, ConcurrentLinkedQueue<RunnablesListener.InvocationDescription>> myEventsByClass = new ConcurrentHashMap<Class<? extends AWTEvent>, ConcurrentLinkedQueue<RunnablesListener.InvocationDescription>>();
    @NotNull
    private final ConcurrentMap<Long, Class<?>> myRunnablesOrCallablesInProgress = new ConcurrentHashMap();
    @NotNull
    private final ConcurrentMap<String, RunnablesListener.LockAcquirementDescription> myAcquirements = new ConcurrentHashMap<String, RunnablesListener.LockAcquirementDescription>();
    @NotNull
    private final ScheduledExecutorService myExecutor = AppExecutorUtil.createBoundedScheduledExecutorService((String)"EDT Events Logger", (int)1);
    @NotNull
    private final ScheduledFuture<?> myThread = this.myExecutor.scheduleWithFixedDelay(this::dumpDescriptions, 100L, 1000L, TimeUnit.MILLISECONDS);
    @NotNull
    private final LogFileWriter myWriter = new LogFileWriter();
    @NotNull
    private final MessageBus myMessageBus;
    @Nullable
    private MatchResult myCurrentResult = null;

    public EventWatcherImpl(@NotNull MessageBus messageBus) {
        this.myMessageBus = messageBus;
        this.myMessageBus.connect((Disposable)this).subscribe(RunnablesListener.TOPIC, (Object)this.myWriter);
    }

    @Override
    public void logTimeMillis(@NotNull String processId, long startedAt, @NotNull Class<? extends Runnable> runnableClass) {
        RunnablesListener.InvocationDescription description = new RunnablesListener.InvocationDescription(processId, startedAt);
        EventWatcherImpl.logTimeMillis(description, runnableClass);
    }

    @Override
    public void runnableStarted(@NotNull Runnable runnable2, long startedAt) {
        Class<?> rootClass;
        Field field;
        Object current2 = runnable2;
        while (current2 != null && (field = EventWatcherImpl.findCallableOrRunnableField(rootClass = current2.getClass())) != null) {
            this.myWrappers.compute(rootClass.getName(), RunnablesListener.WrapperDescription::computeNext);
            current2 = ReflectionUtil.getFieldValue((Field)field, (Object)current2);
        }
        this.myRunnablesOrCallablesInProgress.put(startedAt, (current2 != null ? current2 : runnable2).getClass());
    }

    @Override
    public void runnableFinished(@NotNull Runnable runnable2, long startedAt) {
        Class runnableOrCallableClass = (Class)Objects.requireNonNull(this.myRunnablesOrCallablesInProgress.remove(startedAt));
        String fqn = runnableOrCallableClass.getName();
        RunnablesListener.InvocationDescription description = new RunnablesListener.InvocationDescription(fqn, startedAt);
        this.myRunnables.offer(description);
        this.myDurationsByFqn.compute(fqn, (ignored, info) -> RunnablesListener.InvocationsInfo.computeNext(fqn, description.getDuration(), info));
        EventWatcherImpl.logTimeMillis(description, runnableOrCallableClass);
    }

    @Override
    public void edtEventStarted(@NotNull AWTEvent event) {
        Matcher matcher = DESCRIPTION_BY_EVENT.matcher(event.toString());
        this.myCurrentResult = matcher.find() ? matcher.toMatchResult() : null;
    }

    @Override
    public void edtEventFinished(@NotNull AWTEvent event, long startedAt) {
        String representation = this.myCurrentResult instanceof Matcher ? ((Matcher)this.myCurrentResult).group("description") : event.toString();
        this.myCurrentResult = null;
        Class<?> eventClass = event.getClass();
        this.myEventsByClass.putIfAbsent(eventClass, new ConcurrentLinkedQueue());
        ((ConcurrentLinkedQueue)this.myEventsByClass.get(eventClass)).offer(new RunnablesListener.InvocationDescription(representation, startedAt));
    }

    @Override
    public void lockAcquired(@NotNull String invokedClassFqn, @NotNull LockKind lockKind) {
        this.myAcquirements.compute(invokedClassFqn, (fqn, description) -> RunnablesListener.LockAcquirementDescription.computeNext(fqn, description, lockKind));
    }

    public void dispose() {
        Disposer.dispose((Disposable)this.myWriter);
        this.myThread.cancel(true);
        this.myExecutor.shutdownNow();
    }

    private void dumpDescriptions() {
        if (this.myMessageBus.isDisposed()) {
            return;
        }
        RunnablesListener publisher = (RunnablesListener)this.myMessageBus.syncPublisher(RunnablesListener.TOPIC);
        this.myEventsByClass.forEach((eventClass, events) -> publisher.eventsProcessed((Class<? extends AWTEvent>)eventClass, (Collection<RunnablesListener.InvocationDescription>)EventWatcherImpl.joinPolling(events)));
        publisher.runnablesProcessed(EventWatcherImpl.joinPolling(this.myRunnables), this.myDurationsByFqn.values(), this.myWrappers.values());
        publisher.locksAcquired(this.myAcquirements.values());
    }

    @Nullable
    private static Field findCallableOrRunnableField(@NotNull Class<?> rootClass) {
        return ReflectionUtil.findFieldInHierarchy(rootClass, field -> ReflectionUtil.isInstanceField((Field)field) && EventWatcherImpl.isCallableOrRunnable(field));
    }

    private static boolean isCallableOrRunnable(@NotNull Field field) {
        Class<?> fieldType = field.getType();
        return ReflectionUtil.isAssignable(Runnable.class, fieldType) || ReflectionUtil.isAssignable(Callable.class, fieldType);
    }

    @NotNull
    private static <T> List<T> joinPolling(@NotNull Queue<T> queue) {
        ArrayList<T> builder2 = new ArrayList<T>();
        while (!queue.isEmpty()) {
            builder2.add(queue.poll());
        }
        return Collections.unmodifiableList(builder2);
    }

    private static void logTimeMillis(@NotNull RunnablesListener.InvocationDescription description, @NotNull Class<?> runnableClass) {
        LoadingState.CONFIGURATION_STORE_INITIALIZED.checkOccurred();
        int threshold = Registry.intValue((String)"ide.event.queue.dispatch.threshold", (int)-1);
        if (threshold < 0 || (long)threshold > description.getDuration()) {
            return;
        }
        LOG.warn(description.toString());
        if (runnableClass != Runnable.class) {
            EventWatcherImpl.addPluginCost(runnableClass, description.getDuration());
        }
    }

    private static void addPluginCost(@NotNull Class<?> runnableClass, long duration) {
        ClassLoader loader = runnableClass.getClassLoader();
        String pluginId = loader instanceof PluginClassLoader ? ((PluginClassLoader)((Object)loader)).getPluginId().getIdString() : "com.intellij";
        StartUpMeasurer.addPluginCost((String)pluginId, (String)"invokeLater", (long)TimeUnit.MILLISECONDS.toNanos(duration));
    }

    private static final class LogFileWriter
    implements RunnablesListener,
    Disposable {
        @NotNull
        private final File myLogDir = new File(new File(PathManager.getLogPath(), "edt-log"), String.format("%tY%<tm%<td-%<tH%<tM%<tS", System.currentTimeMillis()));
        @NotNull
        private final Map<String, RunnablesListener.InvocationsInfo> myInfos = new HashMap<String, RunnablesListener.InvocationsInfo>();
        @NotNull
        private final Map<String, RunnablesListener.WrapperDescription> myWrappers = new HashMap<String, RunnablesListener.WrapperDescription>();

        private LogFileWriter() {
        }

        @Override
        public void eventsProcessed(@NotNull Class<? extends AWTEvent> eventClass, @NotNull Collection<RunnablesListener.InvocationDescription> descriptions) {
            this.appendToFile(eventClass.getSimpleName(), descriptions.stream());
        }

        @Override
        public void runnablesProcessed(@NotNull Collection<RunnablesListener.InvocationDescription> invocations, @NotNull Collection<RunnablesListener.InvocationsInfo> infos, @NotNull Collection<RunnablesListener.WrapperDescription> wrappers) {
            this.appendToFile("Runnables", invocations.stream());
            LogFileWriter.putAllTo(infos, RunnablesListener.InvocationsInfo::getFQN, this.myInfos);
            LogFileWriter.putAllTo(wrappers, RunnablesListener.WrapperDescription::getFQN, this.myWrappers);
        }

        public void dispose() {
            this.writeToFile("Timings", this.myInfos);
            this.writeToFile("Wrappers", this.myWrappers);
        }

        private <T> void appendToFile(@NotNull String kind, @NotNull Stream<T> lines) {
            if (!this.myLogDir.isDirectory() && !this.myLogDir.mkdirs()) {
                LOG.debug(this.myLogDir.getAbsolutePath() + " cannot be created");
                return;
            }
            try {
                FileUtil.writeToFile((File)new File(this.myLogDir, kind + ".log"), (String)lines.map(Objects::toString).collect(Collectors.joining("\n")), (boolean)true);
            }
            catch (IOException e) {
                LOG.debug((Throwable)e);
            }
        }

        private <K, V> void writeToFile(@NotNull String kind, @NotNull Map<K, V> entities2) {
            this.appendToFile(kind, entities2.values().stream().sorted());
        }

        private static <E> void putAllTo(@NotNull Collection<E> entities2, @NotNull Function<? super E, String> mapper, @NotNull Map<String, E> map2) {
            Map entitiesMap2 = entities2.stream().collect(Collectors.toMap(mapper, Function.identity()));
            map2.putAll(entitiesMap2);
        }
    }
}

