/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.designer;

import com.intellij.designer.DesignerEditorPanelFacade;
import com.intellij.designer.LightToolWindow;
import com.intellij.designer.LightToolWindowContent;
import com.intellij.designer.ToggleEditorModeAction;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.FileEditorManagerEvent;
import com.intellij.openapi.fileEditor.FileEditorManagerListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowAnchor;
import com.intellij.openapi.wm.ex.ToolWindowEx;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class LightToolWindowManager
implements Disposable {
    public static final String EDITOR_MODE = "UI_DESIGNER_EDITOR_MODE.";
    private final MergingUpdateQueue myWindowQueue = new MergingUpdateQueue(this.getComponentName(), 200, true, null, (Disposable)this);
    protected final Project myProject;
    protected volatile ToolWindow myToolWindow;
    public final String myEditorModeKey;
    private MessageBusConnection myConnection;
    private final Consumer<DesignerEditorPanelFacade> myCreateAction = designer -> designer.putClientProperty(this.getComponentName(), this.createContent((DesignerEditorPanelFacade)designer));
    private final Consumer<DesignerEditorPanelFacade> myUpdateAnchorAction = designer -> {
        LightToolWindow toolWindow = (LightToolWindow)designer.getClientProperty(this.getComponentName());
        toolWindow.updateAnchor(this.getEditorMode());
    };
    private final Consumer<DesignerEditorPanelFacade> myDisposeAction = designer -> this.disposeContent((DesignerEditorPanelFacade)designer);

    protected LightToolWindowManager(@NotNull Project project) {
        this.myProject = project;
        this.myEditorModeKey = EDITOR_MODE + this.getComponentName() + ".STATE";
        StartupManager.getInstance((Project)this.myProject).runAfterOpened(() -> {
            if (this.getEditorMode() == null) {
                this.initListeners();
                this.bindToDesigner(this.getActiveDesigner());
            }
        });
    }

    private void initListeners() {
        this.myConnection = this.myProject.getMessageBus().connect();
        this.myConnection.subscribe(FileEditorManagerListener.FILE_EDITOR_MANAGER, (Object)new FileEditorManagerListener(){

            public void fileOpened(@NotNull FileEditorManager source, @NotNull VirtualFile file2) {
                LightToolWindowManager.this.bindToDesigner(LightToolWindowManager.this.getActiveDesigner());
            }

            public void fileClosed(@NotNull FileEditorManager source, @NotNull VirtualFile file2) {
                ApplicationManager.getApplication().invokeLater(() -> LightToolWindowManager.this.bindToDesigner(LightToolWindowManager.this.getActiveDesigner()));
            }

            public void selectionChanged(@NotNull FileEditorManagerEvent event) {
                LightToolWindowManager.this.bindToDesigner(LightToolWindowManager.this.getDesigner(event.getNewEditor()));
            }
        });
    }

    private void removeListeners() {
        this.myConnection.disconnect();
        this.myConnection = null;
    }

    @Nullable
    protected abstract DesignerEditorPanelFacade getDesigner(FileEditor var1);

    @Nullable
    public DesignerEditorPanelFacade getActiveDesigner() {
        if (this.myProject.isDisposed()) {
            return null;
        }
        for (FileEditor editor : FileEditorManager.getInstance((Project)this.myProject).getSelectedEditors()) {
            DesignerEditorPanelFacade designer = this.getDesigner(editor);
            if (designer == null) continue;
            return designer;
        }
        return null;
    }

    private void bindToDesigner(final DesignerEditorPanelFacade designer) {
        this.myWindowQueue.cancelAllUpdates();
        this.myWindowQueue.queue(new Update("update"){

            public void run() {
                if (LightToolWindowManager.this.myToolWindow == null) {
                    if (designer == null) {
                        return;
                    }
                    LightToolWindowManager.this.initToolWindow();
                }
                LightToolWindowManager.this.updateToolWindow(designer);
            }
        });
    }

    protected abstract void initToolWindow();

    protected abstract void updateToolWindow(@Nullable DesignerEditorPanelFacade var1);

    protected final void initGearActions() {
        ToolWindowEx toolWindow = (ToolWindowEx)this.myToolWindow;
        toolWindow.setAdditionalGearActions((ActionGroup)new DefaultActionGroup(new AnAction[]{this.createGearActions()}));
    }

    protected abstract ToolWindowAnchor getAnchor();

    public AnAction createGearActions() {
        DefaultActionGroup group = DefaultActionGroup.createPopupGroup((Supplier)IdeBundle.messagePointer((String)"popup.title.in.editor.mode", (Object[])new Object[0]));
        group.add((AnAction)this.createToggleAction(ToolWindowAnchor.LEFT));
        group.add((AnAction)this.createToggleAction(ToolWindowAnchor.RIGHT));
        group.add((AnAction)this.createToggleAction(null));
        return group;
    }

    protected abstract ToggleEditorModeAction createToggleAction(ToolWindowAnchor var1);

    public final void bind(@NotNull DesignerEditorPanelFacade designer) {
        if (this.isEditorMode()) {
            this.myCreateAction.accept(designer);
        }
    }

    public final void dispose(@NotNull DesignerEditorPanelFacade designer) {
        if (this.isEditorMode()) {
            this.disposeContent(designer);
        }
    }

    protected final Object getContent(@NotNull DesignerEditorPanelFacade designer) {
        LightToolWindow toolWindow = (LightToolWindow)designer.getClientProperty(this.getComponentName());
        return toolWindow == null ? null : toolWindow.getContent();
    }

    protected abstract LightToolWindow createContent(@NotNull DesignerEditorPanelFacade var1);

    protected final LightToolWindow createContent(@NotNull DesignerEditorPanelFacade designer, @NotNull LightToolWindowContent content2, @NotNull String title, @NotNull Icon icon2, @NotNull JComponent component2, @NotNull JComponent focusedComponent, int defaultWidth, @Nullable List<AnAction> actions) {
        return new LightToolWindow(content2, title, icon2, component2, focusedComponent, designer.getContentSplitter(), this.getEditorMode(), this, this.myProject, this.getComponentName(), defaultWidth, actions);
    }

    protected final void disposeContent(DesignerEditorPanelFacade designer) {
        String key = this.getComponentName();
        LightToolWindow toolWindow = (LightToolWindow)designer.getClientProperty(key);
        designer.putClientProperty(key, null);
        toolWindow.dispose();
    }

    private void runUpdateContent(Consumer<? super DesignerEditorPanelFacade> action2) {
        for (FileEditor editor : FileEditorManager.getInstance((Project)this.myProject).getAllEditors()) {
            DesignerEditorPanelFacade designer = this.getDesigner(editor);
            if (designer == null) continue;
            action2.accept(designer);
        }
    }

    protected final boolean isEditorMode() {
        return this.getEditorMode() != null;
    }

    @Nullable
    public final ToolWindowAnchor getEditorMode() {
        String value2 = PropertiesComponent.getInstance((Project)this.myProject).getValue(this.myEditorModeKey);
        if (value2 == null) {
            return this.getAnchor();
        }
        return value2.equals("ToolWindow") ? null : ToolWindowAnchor.fromText((String)value2);
    }

    protected final void setEditorMode(@Nullable ToolWindowAnchor newState2) {
        ToolWindowAnchor oldState = this.getEditorMode();
        PropertiesComponent.getInstance((Project)this.myProject).setValue(this.myEditorModeKey, newState2 == null ? "ToolWindow" : newState2.toString());
        if (oldState != null && newState2 != null) {
            this.runUpdateContent(this.myUpdateAnchorAction);
        } else if (newState2 != null) {
            this.removeListeners();
            this.updateToolWindow(null);
            this.runUpdateContent(this.myCreateAction);
        } else {
            this.runUpdateContent(this.myDisposeAction);
            this.initListeners();
            this.bindToDesigner(this.getActiveDesigner());
        }
    }

    final ToolWindow getToolWindow() {
        return this.myToolWindow;
    }

    public void dispose() {
        this.myToolWindow = null;
    }

    @NotNull
    protected String getComponentName() {
        return this.getClass().getName();
    }
}

