/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.core;

import com.intellij.configurationStore.DefaultStateSerializerKt;
import com.intellij.core.CoreModuleManager;
import com.intellij.mock.MockProject;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.PathMacroManager;
import com.intellij.openapi.components.impl.stores.DirectoryStorageUtil;
import com.intellij.openapi.components.impl.stores.FileStorageCoreUtil;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.impl.ProjectRootManagerImpl;
import com.intellij.openapi.roots.impl.libraries.LibraryStateSplitter;
import com.intellij.openapi.roots.impl.libraries.LibraryTableBase;
import com.intellij.openapi.roots.libraries.LibraryTablesRegistrar;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.project.ProjectKt;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jetbrains.annotations.NotNull;

public final class CoreProjectLoader {
    public static boolean loadProject(MockProject project, @NotNull VirtualFile virtualFile) throws IOException, JDOMException {
        VirtualFile ideaDir = ProjectKt.getProjectStoreDirectory(virtualFile);
        if (ideaDir != null) {
            project.setBaseDir(virtualFile);
            CoreProjectLoader.loadDirectoryProject(project, ideaDir);
            return true;
        }
        return false;
    }

    private static void loadDirectoryProject(MockProject project, @NotNull VirtualFile dotIdea) throws IOException, JDOMException {
        VirtualFile libraries;
        VirtualFile modulesXml = dotIdea.findChild("modules.xml");
        if (modulesXml == null) {
            throw new FileNotFoundException("Missing 'modules.xml' in " + dotIdea.getPath());
        }
        Map<String, Element> storageData = CoreProjectLoader.loadStorageFile(project, modulesXml);
        Element moduleManagerState = storageData.get("ProjectModuleManager");
        if (moduleManagerState == null) {
            throw new JDOMException("cannot find ProjectModuleManager state in modules.xml");
        }
        CoreModuleManager moduleManager = (CoreModuleManager)ModuleManager.getInstance((Project)project);
        moduleManager.loadState(moduleManagerState);
        VirtualFile miscXml = dotIdea.findChild("misc.xml");
        if (miscXml != null) {
            storageData = CoreProjectLoader.loadStorageFile(project, miscXml);
            Element projectRootManagerState = storageData.get("ProjectRootManager");
            if (projectRootManagerState == null) {
                throw new JDOMException("cannot find ProjectRootManager state in misc.xml");
            }
            ((ProjectRootManagerImpl)ProjectRootManager.getInstance((Project)project)).loadState(projectRootManagerState);
        }
        if ((libraries = dotIdea.findChild("libraries")) != null) {
            Map<String, Element> data2 = DirectoryStorageUtil.loadFrom(libraries, PathMacroManager.getInstance(project));
            Element libraryTable = DefaultStateSerializerKt.deserializeState(DirectoryStorageUtil.getCompositeState(data2, new LibraryStateSplitter()), Element.class, null);
            ((LibraryTableBase)LibraryTablesRegistrar.getInstance().getLibraryTable((Project)project)).loadState(libraryTable);
        }
        moduleManager.loadModules();
        project.projectOpened();
    }

    @NotNull
    static Map<String, Element> loadStorageFile(@NotNull ComponentManager componentManager, @NotNull VirtualFile modulesXml) throws JDOMException, IOException {
        return FileStorageCoreUtil.load(JDOMUtil.load((InputStream)modulesXml.getInputStream()), PathMacroManager.getInstance(componentManager));
    }
}

