/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.conversion.impl;

import com.intellij.conversion.CannotConvertException;
import com.intellij.conversion.RunManagerSettings;
import com.intellij.conversion.impl.ConversionContextImpl;
import com.intellij.conversion.impl.SettingsXmlFile;
import com.intellij.openapi.util.JDOMUtil;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RunManagerSettingsImpl
implements RunManagerSettings {
    @NonNls
    public static final String RUN_MANAGER_COMPONENT_NAME = "RunManager";
    @NonNls
    public static final String CONFIGURATION_ELEMENT = "configuration";
    private SettingsXmlFile myWorkspaceFile;
    private SettingsXmlFile myProjectFile;
    private final List<SettingsXmlFile> mySharedConfigurationFiles;

    public RunManagerSettingsImpl(@NotNull Path workspaceFile, @Nullable Path projectFile, File @Nullable [] sharedConfigurationFiles, ConversionContextImpl context) throws CannotConvertException {
        if (Files.exists(workspaceFile, new LinkOption[0])) {
            this.myWorkspaceFile = context.getOrCreateFile(workspaceFile);
        }
        if (projectFile != null && Files.exists(projectFile, new LinkOption[0])) {
            this.myProjectFile = context.getOrCreateFile(projectFile);
        }
        this.mySharedConfigurationFiles = new ArrayList<SettingsXmlFile>();
        if (sharedConfigurationFiles != null) {
            for (File file2 : sharedConfigurationFiles) {
                this.mySharedConfigurationFiles.add(context.getOrCreateFile(file2.toPath()));
            }
        }
    }

    @Override
    @NotNull
    public Collection<? extends Element> getRunConfigurations() {
        ArrayList result2 = new ArrayList();
        if (this.myWorkspaceFile != null) {
            result2.addAll(JDOMUtil.getChildren((Element)this.myWorkspaceFile.findComponent(RUN_MANAGER_COMPONENT_NAME), (String)CONFIGURATION_ELEMENT));
        }
        if (this.myProjectFile != null) {
            result2.addAll(JDOMUtil.getChildren((Element)this.myProjectFile.findComponent("ProjectRunConfigurationManager"), (String)CONFIGURATION_ELEMENT));
        }
        for (SettingsXmlFile file2 : this.mySharedConfigurationFiles) {
            result2.addAll(JDOMUtil.getChildren((Element)file2.getRootElement(), (String)CONFIGURATION_ELEMENT));
        }
        return result2;
    }

    public Collection<Path> getAffectedFiles() {
        ArrayList<Path> files2 = new ArrayList<Path>();
        if (this.myWorkspaceFile != null) {
            files2.add(this.myWorkspaceFile.getFile());
        }
        if (this.myProjectFile != null) {
            files2.add(this.myProjectFile.getFile());
        }
        for (SettingsXmlFile file2 : this.mySharedConfigurationFiles) {
            files2.add(file2.getFile());
        }
        return files2;
    }
}

