/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.configurationStore;

import com.intellij.configurationStore.StorageManagerFileWriteRequestor;
import com.intellij.configurationStore.StoreReloadManager;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.notification.NotificationsManager;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.PathMacros;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.PathMacroSubstitutor;
import com.intellij.openapi.components.ServiceKt;
import com.intellij.openapi.components.TrackingPathMacroSubstitutor;
import com.intellij.openapi.components.impl.stores.IComponentStore;
import com.intellij.openapi.components.impl.stores.UnknownMacroNotification;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.project.impl.ProjectMacrosUtil;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.io.PathKt;
import gnu.trove.THashSet;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.event.HyperlinkEvent;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=2, d1={"\u0000\\\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010#\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010%\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0007\u001a:\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\f2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00010\u000f2\u0012\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00130\u0011H\u0002\u001a2\u0010\u0014\u001a\u00020\b2\u0006\u0010\u0015\u001a\u00020\u00162\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00010\u000f2\u0012\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00130\u0017H\u0002\u001a2\u0010\u0018\u001a\u00020\b2\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00010\u000f2\u0006\u0010\t\u001a\u00020\n2\u0012\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00130\u0011H\u0007\u001a\u0018\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0007\u001a$\u0010 \u001a\u0002H!\"\u0004\b\u0000\u0010!2\u000e\b\u0004\u0010\"\u001a\b\u0012\u0004\u0012\u0002H!0#H\u0087\b\u00a2\u0006\u0002\u0010$\"\u001c\u0010\u0000\u001a\u0004\u0018\u00010\u0001X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0002\u0010\u0003\"\u0004\b\u0004\u0010\u0005\"\u000e\u0010\u0006\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"DEBUG_LOG", "", "getDEBUG_LOG", "()Ljava/lang/String;", "setDEBUG_LOG", "(Ljava/lang/String;)V", "NOTIFICATION_GROUP_ID", "checkUnknownMacros", "", "project", "Lcom/intellij/openapi/project/Project;", "notify", "", "showDialog", "unknownMacros", "", "substitutorToStore", "", "Lcom/intellij/openapi/components/TrackingPathMacroSubstitutor;", "Lcom/intellij/openapi/components/impl/stores/IComponentStore;", "collect", "componentManager", "Lcom/intellij/openapi/components/ComponentManager;", "", "doNotify", "macros", "getOrCreateVirtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "file", "Ljava/nio/file/Path;", "requestor", "Lcom/intellij/configurationStore/StorageManagerFileWriteRequestor;", "runAsWriteActionIfNeeded", "T", "runnable", "Lkotlin/Function0;", "(Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "intellij.platform.ide.impl"})
public final class StorageUtilKt {
    @NotNull
    public static final String NOTIFICATION_GROUP_ID = "Load Error";
    @Nullable
    private static String DEBUG_LOG;

    @Nullable
    public static final String getDEBUG_LOG() {
        return DEBUG_LOG;
    }

    public static final void setDEBUG_LOG(@Nullable String string) {
        DEBUG_LOG = string;
    }

    @ApiStatus.Internal
    public static final void doNotify(@NotNull Set<String> macros, @NotNull Project project, @NotNull Map<TrackingPathMacroSubstitutor, ? extends IComponentStore> substitutorToStore) {
        String productName = ApplicationNamesInfo.getInstance().getProductName();
        String content2 = "<p><i>" + CollectionsKt.joinToString$default((Iterable)macros, (CharSequence)", ", null, null, (int)0, null, null, (int)62, null) + "</i> " + (macros.size() == 1 ? "is" : "are") + " undefined. <a href=\"define\">Fix it</a></p>" + "<br>Path variables are used to substitute absolute paths in " + productName + " project files " + "and allow project file sharing in version control systems.<br>" + "Some of the files describing the current project settings contain unknown path variables " + "and " + productName + " cannot restore those paths.";
        new UnknownMacroNotification(NOTIFICATION_GROUP_ID, "Load error: undefined path variables", content2, NotificationType.ERROR, new NotificationListener(project, macros, substitutorToStore){
            final /* synthetic */ Project $project;
            final /* synthetic */ Set $macros;
            final /* synthetic */ Map $substitutorToStore;

            public final void hyperlinkUpdate(@NotNull Notification $noName_0, @NotNull HyperlinkEvent $noName_1) {
                StorageUtilKt.access$checkUnknownMacros(this.$project, true, this.$macros, this.$substitutorToStore);
            }
            {
                this.$project = project;
                this.$macros = set;
                this.$substitutorToStore = map2;
            }
        }, (Collection<String>)macros).notify(project);
    }

    @ApiStatus.Internal
    public static final void checkUnknownMacros(@NotNull Project project, boolean notify) {
        LinkedHashSet unknownMacros = new LinkedHashSet();
        LinkedHashMap substitutorToStore = new LinkedHashMap();
        StorageUtilKt.collect((ComponentManager)project, unknownMacros, substitutorToStore);
        for (Module module : ModuleManager.getInstance((Project)project).getModules()) {
            StorageUtilKt.collect((ComponentManager)module, unknownMacros, substitutorToStore);
        }
        if (unknownMacros.isEmpty()) {
            return;
        }
        if (notify) {
            StorageUtilKt.doNotify(unknownMacros, project, substitutorToStore);
            return;
        }
        StorageUtilKt.checkUnknownMacros(project, false, unknownMacros, substitutorToStore);
    }

    /*
     * WARNING - void declaration
     */
    private static final void checkUnknownMacros(Project project, boolean showDialog, Set<String> unknownMacros, Map<TrackingPathMacroSubstitutor, ? extends IComponentStore> substitutorToStore) {
        if (unknownMacros.isEmpty() || showDialog && !ProjectMacrosUtil.checkMacros(project, (Set)new THashSet((Collection)unknownMacros))) {
            return;
        }
        PathMacros pathMacros = PathMacros.getInstance();
        CollectionsKt.removeAll((Iterable)unknownMacros, (Function1)((Function1)new Function1<String, Boolean>(pathMacros){
            final /* synthetic */ PathMacros $pathMacros;

            public final boolean invoke(@NotNull String it) {
                CharSequence charSequence = this.$pathMacros.getValue(it);
                boolean bl = false;
                boolean bl2 = false;
                return (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) && !this.$pathMacros.isIgnoredMacroName(it);
            }
            {
                this.$pathMacros = pathMacros;
                super(1);
            }
        }));
        if (unknownMacros.isEmpty()) {
            return;
        }
        NotificationsManager notificationManager2 = NotificationsManager.getNotificationsManager();
        Object object = substitutorToStore;
        boolean bl = false;
        Iterator<Map.Entry<TrackingPathMacroSubstitutor, ? extends IComponentStore>> iterator2 = object.entrySet().iterator();
        while (iterator2.hasNext()) {
            void substitutor;
            Set<String> components;
            Map.Entry<TrackingPathMacroSubstitutor, ? extends IComponentStore> entry;
            Map.Entry<TrackingPathMacroSubstitutor, ? extends IComponentStore> entry2 = entry = iterator2.next();
            boolean bl2 = false;
            object = entry2.getKey();
            entry2 = entry;
            bl2 = false;
            IComponentStore store = entry2.getValue();
            if (store.isReloadPossible(components = substitutor.getComponents((Collection<String>)unknownMacros))) {
                substitutor.invalidateUnknownMacros(unknownMacros);
                for (UnknownMacroNotification notification : (UnknownMacroNotification[])notificationManager2.getNotificationsOfType(UnknownMacroNotification.class, project)) {
                    if (!unknownMacros.containsAll(notification.getMacros())) continue;
                    notification.expire();
                }
                store.reloadStates(components, project.getMessageBus());
                continue;
            }
            if (Messages.showYesNoDialog((Project)project, (String)"Component could not be reloaded. Reload project?", (String)"Configuration Changed", (Icon)Messages.getQuestionIcon()) != 0) continue;
            StoreReloadManager.Companion.getInstance().reloadProject(project);
        }
    }

    private static final void collect(ComponentManager componentManager, Set<String> unknownMacros, Map<TrackingPathMacroSubstitutor, IComponentStore> substitutorToStore) {
        IComponentStore store = ServiceKt.getStateStore(componentManager);
        PathMacroSubstitutor pathMacroSubstitutor = store.getStorageManager().getMacroSubstitutor();
        if (!(pathMacroSubstitutor instanceof TrackingPathMacroSubstitutor)) {
            pathMacroSubstitutor = null;
        }
        TrackingPathMacroSubstitutor trackingPathMacroSubstitutor = (TrackingPathMacroSubstitutor)pathMacroSubstitutor;
        if (trackingPathMacroSubstitutor == null) {
            return;
        }
        TrackingPathMacroSubstitutor substitutor = trackingPathMacroSubstitutor;
        Set<String> macros = substitutor.getUnknownMacros(null);
        if (macros.isEmpty()) {
            return;
        }
        unknownMacros.addAll((Collection<String>)macros);
        substitutorToStore.put(substitutor, store);
    }

    @ApiStatus.Internal
    @NotNull
    public static final VirtualFile getOrCreateVirtualFile(@NotNull Path file2, @NotNull StorageManagerFileWriteRequestor requestor) {
        VirtualFile virtualFile = LocalFileSystem.getInstance().refreshAndFindFileByPath(PathKt.getSystemIndependentPath((Path)file2));
        if (virtualFile == null) {
            Object object;
            Path parentFile = file2.getParent();
            PathKt.createDirectories((Path)parentFile);
            VirtualFile virtualFile2 = LocalFileSystem.getInstance().refreshAndFindFileByPath(PathKt.getSystemIndependentPath((Path)parentFile));
            if (virtualFile2 == null) {
                throw (Throwable)new IOException(ProjectBundle.message((String)"project.configuration.save.file.not.found", (Object[])new Object[]{parentFile}));
            }
            VirtualFile parentVirtualFile = virtualFile2;
            boolean $i$f$runAsWriteActionIfNeeded = false;
            if (ApplicationManager.getApplication().isWriteAccessAllowed()) {
                boolean bl = false;
                object = parentVirtualFile.createChildData((Object)requestor, ((Object)file2.getFileName()).toString());
            } else {
                boolean $i$f$runWriteAction = false;
                object = ApplicationManager.getApplication().runWriteAction(new Computable<T>(parentVirtualFile, requestor, file2){
                    final /* synthetic */ VirtualFile $parentVirtualFile$inlined;
                    final /* synthetic */ StorageManagerFileWriteRequestor $requestor$inlined;
                    final /* synthetic */ Path $file$inlined;
                    {
                        this.$parentVirtualFile$inlined = virtualFile;
                        this.$requestor$inlined = storageManagerFileWriteRequestor;
                        this.$file$inlined = path;
                    }

                    public final T compute() {
                        boolean bl = false;
                        return (T)this.$parentVirtualFile$inlined.createChildData((Object)this.$requestor$inlined, ((Object)this.$file$inlined.getFileName()).toString());
                    }
                });
            }
            virtualFile = object;
        }
        if (virtualFile.getBOM() != null) {
            virtualFile.setBOM((byte[])null);
        }
        return virtualFile;
    }

    @ApiStatus.Internal
    public static final <T> T runAsWriteActionIfNeeded(@NotNull Function0<? extends T> runnable2) {
        Object object;
        int $i$f$runAsWriteActionIfNeeded = 0;
        if (ApplicationManager.getApplication().isWriteAccessAllowed()) {
            object = runnable2.invoke();
        } else {
            boolean $i$f$runWriteAction = false;
            object = ApplicationManager.getApplication().runWriteAction(new Computable<T>(runnable2){
                final /* synthetic */ Function0 $runnable;
                {
                    this.$runnable = function0;
                }

                public final T compute() {
                    return (T)this.$runnable.invoke();
                }
            });
        }
        return (T)object;
    }

    public static final /* synthetic */ void access$checkUnknownMacros(Project project, boolean showDialog, Set unknownMacros, Map substitutorToStore) {
        StorageUtilKt.checkUnknownMacros(project, showDialog, unknownMacros, substitutorToStore);
    }
}

