/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeStyle;

import com.intellij.ide.lightEdit.LightEditCompatible;
import com.intellij.injected.editor.VirtualFileWindow;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.PlatformEditorBundle;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.impl.LoadTextUtil;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.fileTypes.InternalFileType;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.StandardFileSystems;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileVisitor;
import com.intellij.project.ProjectKt;
import com.intellij.util.LineSeparator;
import java.io.IOException;
import java.nio.file.Path;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractConvertLineSeparatorsAction
extends AnAction
implements DumbAware,
LightEditCompatible {
    private static final Logger LOG = Logger.getInstance(AbstractConvertLineSeparatorsAction.class);
    @NotNull
    private final String mySeparator;

    protected AbstractConvertLineSeparatorsAction(@NotNull Supplier<String> text, @NotNull LineSeparator separator) {
        this(separator + " - " + text.get(), separator.getSeparatorString());
    }

    protected AbstractConvertLineSeparatorsAction(@Nullable String text, @NotNull String separator) {
        super(text);
        this.mySeparator = separator;
    }

    public void update(@NotNull AnActionEvent e) {
        DataContext dataContext = e.getDataContext();
        Project project = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        if (project != null) {
            VirtualFile[] virtualFiles = (VirtualFile[])CommonDataKeys.VIRTUAL_FILE_ARRAY.getData(dataContext);
            Presentation presentation2 = e.getPresentation();
            if (virtualFiles != null) {
                if (virtualFiles.length == 1) {
                    presentation2.setEnabled(!this.mySeparator.equals(LoadTextUtil.detectLineSeparator(virtualFiles[0], false)));
                } else {
                    presentation2.setEnabled(true);
                }
            } else {
                presentation2.setEnabled(false);
            }
        }
    }

    public void actionPerformed(@NotNull AnActionEvent event) {
        DataContext dataContext = event.getDataContext();
        final Project project = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        if (project == null) {
            return;
        }
        VirtualFile[] virtualFiles = (VirtualFile[])CommonDataKeys.VIRTUAL_FILE_ARRAY.getData(dataContext);
        if (virtualFiles == null) {
            return;
        }
        Path directoryStorePath = ProjectKt.getStateStore(project).getDirectoryStorePath();
        final VirtualFile projectVirtualDirectory = directoryStorePath == null ? null : StandardFileSystems.local().findFileByPath(FileUtil.toSystemIndependentName((String)directoryStorePath.toString()));
        final FileTypeRegistry fileTypeManager = FileTypeRegistry.getInstance();
        for (VirtualFile file2 : virtualFiles) {
            VfsUtilCore.visitChildrenRecursively((VirtualFile)file2, (VirtualFileVisitor)new VirtualFileVisitor<Void>(new VirtualFileVisitor.Option[0]){

                @NotNull
                public VirtualFileVisitor.Result visitFileEx(@NotNull VirtualFile file2) {
                    if (AbstractConvertLineSeparatorsAction.shouldProcess(file2)) {
                        AbstractConvertLineSeparatorsAction.changeLineSeparators(project, file2, AbstractConvertLineSeparatorsAction.this.mySeparator);
                    }
                    return file2.isDirectory() && (file2.equals(projectVirtualDirectory) || fileTypeManager.isFileIgnored(file2)) ? SKIP_CHILDREN : CONTINUE;
                }
            });
        }
    }

    public static boolean shouldProcess(@NotNull VirtualFile file2) {
        return !file2.isDirectory() && file2.isWritable() && !(file2 instanceof VirtualFileWindow) && !FileTypeRegistry.getInstance().isFileIgnored(file2) && !file2.getFileType().isBinary() && !(file2.getFileType() instanceof InternalFileType);
    }

    public static void changeLineSeparators(@NotNull Project project, @NotNull VirtualFile virtualFile, @NotNull String newSeparator) {
        String currentSeparator;
        FileDocumentManager fileDocumentManager = FileDocumentManager.getInstance();
        Document document = fileDocumentManager.getCachedDocument(virtualFile);
        if (document != null) {
            fileDocumentManager.saveDocument(document);
        }
        String commandText = StringUtil.isEmpty((String)(currentSeparator = LoadTextUtil.detectLineSeparator(virtualFile, false))) ? PlatformEditorBundle.message((String)"command.name.changed.line.separators.to", (Object[])new Object[]{LineSeparator.fromString((String)newSeparator)}) : String.format("Changed line separators from %s to %s", LineSeparator.fromString((String)currentSeparator), LineSeparator.fromString((String)newSeparator));
        WriteCommandAction.writeCommandAction((Project)project).withName(commandText).run(() -> {
            try {
                LoadTextUtil.changeLineSeparators(project, virtualFile, newSeparator, virtualFile);
            }
            catch (IOException e) {
                LOG.info((Throwable)e);
            }
        });
    }
}

