/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.ui.actions;

import com.intellij.codeInspection.ui.InspectionResultsView;
import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.ui.content.Content;
import java.awt.Component;
import java.util.function.Supplier;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class InspectionViewActionBase
extends AnAction {
    public InspectionViewActionBase(@NotNull Supplier<String> text, @NotNull Supplier<String> description, @Nullable Icon icon2) {
        super(text, description, icon2);
    }

    public InspectionViewActionBase(@NotNull Supplier<String> name) {
        super(name);
    }

    public final void update(@NotNull AnActionEvent e) {
        InspectionResultsView view = InspectionViewActionBase.getView(e);
        boolean enabled = view != null && this.isEnabled(view, e);
        Presentation presentation2 = e.getPresentation();
        presentation2.setEnabled(enabled);
    }

    protected boolean isEnabled(@NotNull InspectionResultsView view, AnActionEvent e) {
        return true;
    }

    @Nullable
    public static InspectionResultsView getView(@Nullable AnActionEvent event) {
        if (event == null) {
            return null;
        }
        InspectionResultsView view = (InspectionResultsView)event.getData(InspectionResultsView.DATA_KEY);
        if (view == null) {
            Project project = event.getProject();
            if (project == null) {
                return null;
            }
            ToolWindowManager twManager = ToolWindowManager.getInstance((Project)project);
            ToolWindow window = twManager.getToolWindow("Inspection Results");
            if (window == null) {
                return null;
            }
            Content selectedContent = window.getContentManager().getSelectedContent();
            if (selectedContent == null) {
                return null;
            }
            DataContext twContext = DataManager.getInstance().getDataContext((Component)selectedContent.getComponent());
            view = (InspectionResultsView)InspectionResultsView.DATA_KEY.getData(twContext);
            if (view == null) {
                return null;
            }
        }
        return view.isDisposed() ? null : view;
    }
}

