/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.ui;

import com.intellij.codeInspection.ProblemDescriptorBase;
import com.intellij.codeInspection.ui.InspectionResultsView;
import com.intellij.codeInspection.ui.PreviewEditorFoldingRegion;
import com.intellij.diff.tools.util.FoldingModelSupport;
import com.intellij.diff.util.DiffDrawUtil;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.FoldRegion;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.usageView.UsageInfo;
import com.intellij.usages.impl.UsagePreviewPanel;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Container;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public final class ProblemPreviewEditorPresentation {
    private static final int VIEW_ADDITIONAL_OFFSET = 4;
    private static final int SHOWN_LINES_COUNT = 2;

    static void setupFoldingsAndHighlightProblems(@NotNull EditorEx editor, @NotNull InspectionResultsView view) {
        List usages = Arrays.stream(view.getTree().getAllValidSelectedDescriptors()).filter(ProblemDescriptorBase.class::isInstance).map(ProblemDescriptorBase.class::cast).map(d -> {
            PsiElement psi = d.getPsiElement();
            if (psi == null) {
                return null;
            }
            TextRange range2 = d.getTextRangeInElement();
            return range2 == null ? new UsageInfo(psi) : new UsageInfo(psi, range2.getStartOffset(), range2.getEndOffset());
        }).collect(Collectors.toList());
        ProblemPreviewEditorPresentation.setupFoldingsAndHighlightProblems(editor, view, usages, view.getProject());
    }

    public static void setupFoldingsAndHighlightProblems(@NotNull EditorEx editor, @NotNull Container editorContainer, @NotNull List<? extends UsageInfo> usages, @NotNull Project project) {
        DocumentEx doc = editor.getDocument();
        PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)project);
        InjectedLanguageManager injectedLanguageManager = InjectedLanguageManager.getInstance((Project)project);
        if (documentManager.isUncommited((Document)doc)) {
            WriteAction.run(() -> documentManager.commitDocument(doc));
        }
        if (usages.size() > 1) {
            TreeSet<PreviewEditorFoldingRegion> foldingRegions = new TreeSet<PreviewEditorFoldingRegion>();
            foldingRegions.add(new PreviewEditorFoldingRegion(0, doc.getLineCount()));
            boolean isUpdated = false;
            for (UsageInfo usageInfo : usages) {
                if (usageInfo == null) {
                    return;
                }
                PsiElement element2 = usageInfo.getElement();
                Segment segment = usageInfo.getSegment();
                assert (element2 != null);
                isUpdated |= ProblemPreviewEditorPresentation.makeVisible(foldingRegions, (Segment)injectedLanguageManager.injectedToHost(element2, segment != null ? TextRange.create((Segment)segment) : element2.getTextRange()), doc);
            }
            if (isUpdated) {
                ProblemPreviewEditorPresentation.setupFoldings(editor, foldingRegions);
            }
        }
        ProblemPreviewEditorPresentation.highlightProblems(editor, editorContainer, usages, project);
    }

    private static void highlightProblems(EditorEx editor, Container editorContainer, List<? extends UsageInfo> usages, @NotNull Project project) {
        List validUsages = ContainerUtil.filter(usages, Objects::nonNull);
        InjectedLanguageManager injectedLanguageManager = InjectedLanguageManager.getInstance((Project)project);
        PsiDocumentManager.getInstance((Project)project).performLaterWhenAllCommitted(() -> {
            if (!editor.isDisposed()) {
                editorContainer.invalidate();
                editorContainer.validate();
                UsagePreviewPanel.highlight((List)validUsages, (Editor)editor, (Project)project, (boolean)false, (int)6000);
                if (validUsages.size() == 1) {
                    UsageInfo usage = (UsageInfo)validUsages.get(0);
                    PsiElement element2 = usage.getElement();
                    Segment range2 = usage.getNavigationRange();
                    if (element2 != null && range2 != null) {
                        if (injectedLanguageManager.getInjectionHost(element2) != null) {
                            range2 = injectedLanguageManager.injectedToHost(element2, new TextRange(range2.getStartOffset(), range2.getEndOffset()));
                        }
                        DocumentEx document = editor.getDocument();
                        int offset = Math.min(range2.getEndOffset() + 4, document.getLineEndOffset(document.getLineNumber(range2.getEndOffset())));
                        editor.getScrollingModel().scrollTo(editor.offsetToLogicalPosition(offset), ScrollType.CENTER);
                        return;
                    }
                }
                editor.getScrollingModel().scrollTo(editor.offsetToLogicalPosition(0), ScrollType.CENTER_UP);
            }
        });
    }

    public static void setupFoldings(EditorEx editor, SortedSet<? extends PreviewEditorFoldingRegion> foldingRegions) {
        editor.getFoldingModel().runBatchFoldingOperation(() -> {
            editor.getFoldingModel().clearFoldRegions();
            editor.getMarkupModel().removeAllHighlighters();
            for (PreviewEditorFoldingRegion region : foldingRegions) {
                FoldRegion currentRegion;
                if (region.getEndLine() - region.getStartLine() <= 1 || (currentRegion = FoldingModelSupport.addFolding(editor, region.getStartLine(), region.getEndLine(), false)) == null) continue;
                DiffDrawUtil.createLineSeparatorHighlighter(editor, editor.getDocument().getLineStartOffset(region.getStartLine()), editor.getDocument().getLineEndOffset(region.getEndLine() - 1), () -> currentRegion.isValid() && !currentRegion.isExpanded());
            }
        });
    }

    private static boolean makeVisible(SortedSet<PreviewEditorFoldingRegion> foldingRegions, Segment toShowRange, Document document) {
        if (toShowRange == null) {
            return false;
        }
        boolean isUpdated = false;
        int startLine = Math.max(0, document.getLineNumber(toShowRange.getStartOffset()) - 2);
        int endLine = Math.min(document.getLineCount(), document.getLineNumber(toShowRange.getEndOffset()) + 2 + 1);
        for (PreviewEditorFoldingRegion range2 : new ArrayList<PreviewEditorFoldingRegion>(foldingRegions)) {
            boolean startInRegion = range2.contain(startLine);
            boolean endInRegion = range2.contain(endLine);
            if (startInRegion && endInRegion) {
                foldingRegions.remove(range2);
                if (range2.getStartLine() != startLine) {
                    foldingRegions.add(new PreviewEditorFoldingRegion(range2.getStartLine(), startLine));
                }
                if (endLine != range2.getEndLine()) {
                    foldingRegions.add(new PreviewEditorFoldingRegion(endLine, range2.getEndLine()));
                }
                return true;
            }
            if (startInRegion) {
                foldingRegions.remove(range2);
                if (range2.getStartLine() != startLine) {
                    foldingRegions.add(new PreviewEditorFoldingRegion(range2.getStartLine(), startLine));
                }
                isUpdated = true;
            }
            if (!endInRegion) continue;
            foldingRegions.remove(range2);
            if (endLine != range2.getEndLine()) {
                foldingRegions.add(new PreviewEditorFoldingRegion(endLine, range2.getEndLine()));
            }
            return true;
        }
        return isUpdated;
    }
}

