/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.ui;

import com.intellij.codeInspection.InspectionEP;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.actions.RunInspectionAction;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.codeInspection.ui.InspectionTree;
import com.intellij.diagnostic.PluginException;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.profile.codeInspection.ui.SingleInspectionProfilePanel;
import com.intellij.ui.ClickListener;
import com.intellij.ui.JBColor;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBLabelDecorator;
import com.intellij.ui.components.panels.StatelessCardLayout;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseEvent;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.Border;
import javax.swing.event.HyperlinkListener;
import org.jetbrains.annotations.NotNull;

public class InspectionNodeInfo
extends JPanel {
    private static final Logger LOG = Logger.getInstance(InspectionNodeInfo.class);

    public InspectionNodeInfo(final @NotNull InspectionTree tree, final @NotNull Project project) {
        String toolDescription;
        this.setLayout(new GridBagLayout());
        this.setBorder((Border)JBUI.Borders.emptyTop((int)11));
        final InspectionToolWrapper toolWrapper = tree.getSelectedToolWrapper(false);
        LOG.assertTrue(toolWrapper != null);
        final InspectionProfileImpl currentProfile = InspectionProjectProfileManager.getInstance(project).getCurrentProfile();
        final boolean enabled = currentProfile.getTools(toolWrapper.getShortName(), project).isEnabled();
        JPanel titlePanel = new JPanel();
        titlePanel.setLayout(new BoxLayout(titlePanel, 2));
        JBLabelDecorator label2 = JBLabelDecorator.createJBLabelDecorator().setBold(true);
        label2.setText(InspectionsBundle.message((String)"inspection.node.text", (Object[])new Object[]{toolWrapper.getDisplayName()}));
        titlePanel.add((Component)label2);
        titlePanel.add(Box.createHorizontalStrut(JBUIScale.scale((int)16)));
        if (!enabled) {
            JBLabel enabledLabel = new JBLabel();
            enabledLabel.setForeground((Color)JBColor.GRAY);
            enabledLabel.setText(InspectionsBundle.message((String)"inspection.node.disabled.state", (Object[])new Object[0]));
            titlePanel.add((Component)enabledLabel);
        }
        this.add((Component)titlePanel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, (Insets)new JBInsets(0, 12, 5, 16), 0, 0));
        JEditorPane description = new JEditorPane();
        description.setContentType("text/html");
        description.setEditable(false);
        description.setOpaque(false);
        description.setBackground(UIUtil.getLabelBackground());
        description.addHyperlinkListener((HyperlinkListener)SingleInspectionProfilePanel.createSettingsHyperlinkListener(project));
        String descriptionText = toolWrapper.loadDescription();
        if (descriptionText == null) {
            InspectionEP extension = toolWrapper.getExtension();
            LOG.error((Throwable)new PluginException("Inspection #" + toolWrapper.getShortName() + " has no description", extension != null ? extension.getPluginDescriptor().getPluginId() : null));
        }
        SingleInspectionProfilePanel.readHTML(description, SingleInspectionProfilePanel.toHTML(description, (toolDescription = InspectionNodeInfo.stripUIRefsFromInspectionDescription(StringUtil.notNullize((String)descriptionText))) == null ? "" : toolDescription, false));
        JScrollPane pane2 = ScrollPaneFactory.createScrollPane((Component)description, (boolean)true);
        int maxWidth = this.getFontMetrics(UIUtil.getLabelFont()).charWidth('f') * 110 - pane2.getMinimumSize().width;
        pane2.setMaximumSize(new Dimension(maxWidth, Integer.MAX_VALUE));
        pane2.setAlignmentX(0.0f);
        this.add((Component)StatelessCardLayout.wrap((Component)pane2), new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 18, 1, (Insets)new JBInsets(0, 10, 0, 0), 0, 0));
        JButton enableButton = null;
        if (currentProfile.getSingleTool() != null) {
            enableButton = enabled ? new JButton(InspectionsBundle.message((String)"disable.inspection.btn.text", (Object[])new Object[0])) : new JButton(InspectionsBundle.message((String)"enable.inspection.btn.text", (Object[])new Object[0]));
            new ClickListener(){

                public boolean onClick(@NotNull MouseEvent event, int clickCount) {
                    InspectionProfileImpl.setToolEnabled(!enabled, currentProfile, toolWrapper.getShortName(), project);
                    tree.getContext().getView().profileChanged();
                    return true;
                }
            }.installOn((Component)enableButton);
        }
        JButton runInspectionOnButton = new JButton(InspectionsBundle.message((String)"run.inspection.on.file.intention.text", (Object[])new Object[0]));
        new ClickListener(){

            public boolean onClick(@NotNull MouseEvent event, int clickCount) {
                RunInspectionAction.runInspection(project, toolWrapper.getShortName(), VirtualFile.EMPTY_ARRAY, null, null);
                return true;
            }
        }.installOn((Component)runInspectionOnButton);
        JPanel buttons = new JPanel();
        buttons.setLayout(new BoxLayout(buttons, 2));
        if (enableButton != null) {
            buttons.add(enableButton);
        }
        buttons.add(Box.createHorizontalStrut(JBUIScale.scale((int)3)));
        buttons.add(runInspectionOnButton);
        this.add((Component)buttons, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 18, 0, (Insets)new JBInsets(15, 9, 9, 0), 0, 0));
    }

    public static String stripUIRefsFromInspectionDescription(@NotNull String description) {
        int descriptionEnd = description.indexOf("<!-- tooltip end -->");
        if (descriptionEnd < 0) {
            Pattern pattern = Pattern.compile(".*Use.*(the (panel|checkbox|checkboxes|field|button|controls).*below).*", 32);
            Matcher matcher = pattern.matcher(description);
            int startFindIdx = 0;
            while (matcher.find(startFindIdx)) {
                int end;
                startFindIdx = end = matcher.end(1);
                description = description.substring(0, matcher.start(1)) + " inspection settings " + description.substring(end);
            }
        } else {
            description = description.substring(0, descriptionEnd);
        }
        return description;
    }
}

