/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.ui;

import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.ui.RegExFormatter;
import com.intellij.codeInspection.ui.RegExInputVerifier;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.ui.DocumentAdapter;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.text.NumberFormat;
import java.util.regex.Pattern;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import javax.swing.text.InternationalFormatter;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class ConventionOptionsPanel
extends JPanel {
    private static final Logger LOG = Logger.getInstance(ConventionOptionsPanel.class);

    public ConventionOptionsPanel(@NotNull InspectionProfileEntry owner, @NonNls String minLengthProperty, @NonNls String maxLengthProperty, @NonNls String regexProperty, @NonNls String regexPatternProperty, JComponent ... extraOptions) {
        this((Object)owner, minLengthProperty, maxLengthProperty, regexProperty, regexPatternProperty, extraOptions);
    }

    public ConventionOptionsPanel(final @NotNull Object owner, final @NonNls String minLengthProperty, final @NonNls String maxLengthProperty, final @NonNls String regexProperty, final @NonNls String regexPatternProperty, JComponent ... extraOptions) {
        super(new GridBagLayout());
        JLabel patternLabel = new JLabel(InspectionsBundle.message((String)"label.pattern", (Object[])new Object[0]));
        JLabel minLengthLabel = new JLabel(InspectionsBundle.message((String)"label.min.length", (Object[])new Object[0]));
        JLabel maxLengthLabel = new JLabel(InspectionsBundle.message((String)"label.max.length", (Object[])new Object[0]));
        NumberFormat numberFormat = NumberFormat.getIntegerInstance();
        numberFormat.setParseIntegerOnly(true);
        numberFormat.setMinimumIntegerDigits(1);
        numberFormat.setMaximumIntegerDigits(3);
        InternationalFormatter formatter = new InternationalFormatter(numberFormat);
        formatter.setAllowsInvalid(true);
        formatter.setMinimum(Integer.valueOf(0));
        formatter.setMaximum(Integer.valueOf(999));
        final JFormattedTextField minLengthField = new JFormattedTextField(formatter);
        minLengthField.setValue(ConventionOptionsPanel.getPropertyIntegerValue(owner, minLengthProperty));
        minLengthField.setColumns(2);
        UIUtil.fixFormattedField((JFormattedTextField)minLengthField);
        final JFormattedTextField maxLengthField = new JFormattedTextField(formatter);
        maxLengthField.setValue(ConventionOptionsPanel.getPropertyIntegerValue(owner, maxLengthProperty));
        maxLengthField.setColumns(2);
        UIUtil.fixFormattedField((JFormattedTextField)maxLengthField);
        final JFormattedTextField regexField = new JFormattedTextField(new RegExFormatter());
        regexField.setValue(ConventionOptionsPanel.getPropertyValue(owner, regexPatternProperty));
        regexField.setColumns(25);
        regexField.setInputVerifier(new RegExInputVerifier());
        regexField.setFocusLostBehavior(0);
        UIUtil.fixFormattedField((JFormattedTextField)regexField);
        DocumentAdapter listener2 = new DocumentAdapter(){

            public void textChanged(@NotNull DocumentEvent evt) {
                try {
                    regexField.commitEdit();
                    minLengthField.commitEdit();
                    maxLengthField.commitEdit();
                    Pattern pattern = (Pattern)regexField.getValue();
                    ConventionOptionsPanel.setPropertyValue(owner, regexPatternProperty, pattern);
                    ConventionOptionsPanel.setPropertyValue(owner, regexProperty, pattern.pattern());
                    ConventionOptionsPanel.setPropertyIntegerValue(owner, minLengthProperty, (Integer)minLengthField.getValue());
                    ConventionOptionsPanel.setPropertyIntegerValue(owner, maxLengthProperty, (Integer)maxLengthField.getValue());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        };
        Document regexDocument = regexField.getDocument();
        regexDocument.addDocumentListener((DocumentListener)listener2);
        Document minLengthDocument = minLengthField.getDocument();
        minLengthDocument.addDocumentListener((DocumentListener)listener2);
        Document maxLengthDocument = maxLengthField.getDocument();
        maxLengthDocument.addDocumentListener((DocumentListener)listener2);
        GridBagConstraints constraints2 = new GridBagConstraints();
        constraints2.gridx = 0;
        constraints2.gridy = 0;
        constraints2.weightx = 0.0;
        constraints2.insets.right = 10;
        constraints2.anchor = 512;
        constraints2.fill = 2;
        this.add((Component)patternLabel, constraints2);
        constraints2.gridx = 1;
        constraints2.gridy = 0;
        constraints2.weightx = 1.0;
        constraints2.insets.right = 0;
        this.add((Component)regexField, constraints2);
        constraints2.gridx = 0;
        constraints2.gridy = 1;
        constraints2.weightx = 0.0;
        constraints2.insets.right = 10;
        this.add((Component)minLengthLabel, constraints2);
        constraints2.gridx = 1;
        constraints2.gridy = 1;
        constraints2.weightx = 1.0;
        constraints2.insets.right = 0;
        this.add((Component)minLengthField, constraints2);
        constraints2.gridx = 0;
        constraints2.gridy = 2;
        constraints2.weightx = 0.0;
        constraints2.insets.right = 10;
        this.add((Component)maxLengthLabel, constraints2);
        constraints2.gridx = 1;
        constraints2.gridy = 2;
        constraints2.weightx = 1.0;
        constraints2.insets.right = 0;
        this.add((Component)maxLengthField, constraints2);
        constraints2.gridx = 0;
        constraints2.gridwidth = 2;
        for (JComponent extraOption : extraOptions) {
            ++constraints2.gridy;
            this.add((Component)extraOption, constraints2);
        }
        ++constraints2.gridy;
        constraints2.weighty = 1.0;
        this.add((Component)new JPanel(), constraints2);
    }

    private static void setPropertyIntegerValue(Object owner, String property, Integer value2) {
        ConventionOptionsPanel.setPropertyValue(owner, property, value2);
    }

    private static Integer getPropertyIntegerValue(Object owner, String property) {
        return (Integer)ConventionOptionsPanel.getPropertyValue(owner, property);
    }

    private static void setPropertyValue(@NotNull Object owner, String property, Object value2) {
        ReflectionUtil.setField(owner.getClass(), (Object)owner, null, (String)property, (Object)value2);
    }

    private static Object getPropertyValue(Object owner, String property) {
        return ReflectionUtil.getField(owner.getClass(), (Object)owner, null, (String)property);
    }
}

