/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.reference;

import com.intellij.codeInspection.reference.RefEntity;
import com.intellij.codeInspection.reference.RefEntityImpl;
import com.intellij.codeInspection.reference.RefManager;
import com.intellij.codeInspection.reference.RefModule;
import com.intellij.codeInspection.reference.RefProjectImpl;
import com.intellij.codeInspection.reference.RefVisitor;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.util.PlatformIcons;
import java.util.ArrayList;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class RefModuleImpl
extends RefEntityImpl
implements RefModule {
    private final Module myModule;

    RefModuleImpl(@NotNull Module module, @NotNull RefManager manager) {
        super(module.getName(), manager);
        this.myModule = module;
        ((RefProjectImpl)manager.getRefProject()).add(this);
    }

    @Override
    public synchronized void add(@NotNull RefEntity child2) {
        if (this.myChildren == null) {
            this.myChildren = new ArrayList();
        }
        this.myChildren.add(child2);
        if (child2.getOwner() == null) {
            ((RefEntityImpl)child2).setOwner(this);
        }
    }

    @Override
    public synchronized void removeChild(@NotNull RefEntity child2) {
        if (this.myChildren != null) {
            this.myChildren.remove(child2);
        }
    }

    @Override
    public void accept(@NotNull RefVisitor refVisitor) {
        ApplicationManager.getApplication().runReadAction(() -> refVisitor.visitModule((RefModule)this));
    }

    @NotNull
    public Module getModule() {
        return this.myModule;
    }

    public boolean isValid() {
        return !this.myModule.isDisposed();
    }

    public Icon getIcon(boolean expanded) {
        return PlatformIcons.CLOSED_MODULE_GROUP_ICON;
    }

    @Nullable
    static RefEntity moduleFromName(RefManager manager, String name) {
        return manager.getRefModule(ModuleManager.getInstance((Project)manager.getProject()).findModuleByName(name));
    }
}

