/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.naming;

import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.naming.NamingConvention;
import com.intellij.codeInspection.naming.NamingConventionBean;
import com.intellij.codeInspection.naming.NamingConventionWithFallbackBean;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.extensions.ExtensionPointListener;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.psi.SyntheticElement;
import com.intellij.serialization.SerializationException;
import com.intellij.ui.CheckBoxList;
import com.intellij.ui.CheckBoxListListener;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.xmlb.XmlSerializer;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Consumer;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractNamingConventionInspection<T extends PsiNameIdentifierOwner>
extends LocalInspectionTool {
    private static final Logger LOG = Logger.getInstance(AbstractNamingConventionInspection.class);
    private final Map<String, NamingConvention<T>> myNamingConventions = new LinkedHashMap<String, NamingConvention<T>>();
    private final Map<String, NamingConventionBean> myNamingConventionBeans = new LinkedHashMap<String, NamingConventionBean>();
    private final Map<String, Element> myUnloadedElements = new LinkedHashMap<String, Element>();
    private final Set<String> myDisabledShortNames = new HashSet<String>();
    @Nullable
    private final String myDefaultConventionShortName;

    protected AbstractNamingConventionInspection(Iterable<NamingConvention<T>> extensions2, @Nullable String defaultConventionShortName) {
        for (NamingConvention<T> convention : extensions2) {
            this.registerConvention(convention);
        }
        this.myDefaultConventionShortName = defaultConventionShortName;
    }

    protected void registerConvention(NamingConvention<T> convention) {
        String shortName = convention.getShortName();
        NamingConvention<T> oldConvention = this.myNamingConventions.put(shortName, convention);
        if (oldConvention != null) {
            LOG.error("Duplicated short names: " + shortName + " first: " + oldConvention + "; second: " + convention);
        }
        this.myNamingConventionBeans.put(shortName, convention.createDefaultBean());
        if (!convention.isEnabledByDefault()) {
            this.myDisabledShortNames.add(shortName);
        }
    }

    protected void unregisterConvention(@NotNull NamingConvention<T> extension) {
        String shortName = extension.getShortName();
        Element element2 = this.writeConvention(shortName, extension);
        if (element2 != null) {
            this.myUnloadedElements.put(shortName, element2);
        }
        this.myNamingConventionBeans.remove(shortName);
        this.myNamingConventions.remove(shortName);
        this.myDisabledShortNames.remove(shortName);
    }

    protected void registerConventionsListener(ExtensionPointName<NamingConvention<T>> epName) {
        Application application = ApplicationManager.getApplication();
        epName.getPoint((AreaInstance)application).addExtensionPointListener(new ExtensionPointListener<NamingConvention<T>>(){

            public void extensionAdded(@NotNull NamingConvention<T> extension, @NotNull PluginDescriptor pluginDescriptor) {
                AbstractNamingConventionInspection.this.registerConvention(extension);
            }

            public void extensionRemoved(@NotNull NamingConvention<T> extension, @NotNull PluginDescriptor pluginDescriptor) {
                AbstractNamingConventionInspection.this.unregisterConvention(extension);
            }
        }, false, (Disposable)application);
    }

    @Nullable
    protected abstract LocalQuickFix createRenameFix();

    private void initDisabledState() {
        this.myDisabledShortNames.clear();
        for (NamingConvention<T> convention : this.myNamingConventions.values()) {
            if (convention.isEnabledByDefault()) continue;
            this.myDisabledShortNames.add(convention.getShortName());
        }
    }

    public NamingConventionBean getNamingConventionBean(String shortName) {
        return this.myNamingConventionBeans.get(shortName);
    }

    public Set<String> getOldToolNames() {
        return this.myNamingConventions.keySet();
    }

    @NotNull
    protected String createErrorMessage(String name, String shortName) {
        return this.myNamingConventions.get(shortName).createErrorMessage(name, this.myNamingConventionBeans.get(shortName));
    }

    public void readSettings(@NotNull Element node) {
        this.initDisabledState();
        for (Element extension : node.getChildren("extension")) {
            String shortName = extension.getAttributeValue("name");
            if (shortName == null) continue;
            NamingConventionBean conventionBean = this.myNamingConventionBeans.get(shortName);
            if (conventionBean == null) {
                this.myUnloadedElements.put(shortName, extension);
                continue;
            }
            try {
                XmlSerializer.deserializeInto((Object)conventionBean, (Element)extension);
                conventionBean.initPattern();
            }
            catch (SerializationException e) {
                throw new InvalidDataException((Throwable)e);
            }
            String enabled = extension.getAttributeValue("enabled");
            if (!Boolean.parseBoolean(enabled)) continue;
            this.myDisabledShortNames.remove(shortName);
        }
    }

    public void writeSettings(@NotNull Element node) {
        TreeSet<String> shortNames = new TreeSet<String>(this.myNamingConventions.keySet());
        shortNames.addAll(this.myUnloadedElements.keySet());
        for (String shortName : shortNames) {
            Element element2;
            NamingConvention<T> convention = this.myNamingConventions.get(shortName);
            if (convention == null) {
                element2 = this.myUnloadedElements.get(shortName);
                if (element2 == null) continue;
                node.addContent(element2.clone());
                continue;
            }
            element2 = this.writeConvention(shortName, convention);
            if (element2 == null) continue;
            node.addContent(element2);
        }
    }

    private Element writeConvention(String shortName, NamingConvention<T> convention) {
        boolean disabled = this.myDisabledShortNames.contains(shortName);
        Element element2 = new Element("extension").setAttribute("name", shortName).setAttribute("enabled", disabled ? "false" : "true");
        NamingConventionBean conventionBean = this.myNamingConventionBeans.get(shortName);
        if (!convention.createDefaultBean().equals(conventionBean)) {
            XmlSerializer.serializeInto((Object)conventionBean, (Element)element2);
        } else if (disabled) {
            return null;
        }
        return element2;
    }

    public boolean isConventionEnabled(String shortName) {
        return !this.myDisabledShortNames.contains(shortName);
    }

    protected void checkName(@NotNull T member, @NotNull String name, @NotNull ProblemsHolder holder) {
        if (member instanceof SyntheticElement) {
            return;
        }
        this.checkName(member, shortName -> {
            LocalQuickFix[] fixes;
            if (holder.isOnTheFly()) {
                LocalQuickFix[] localQuickFixArray;
                LocalQuickFix fix = this.createRenameFix();
                if (fix != null) {
                    LocalQuickFix[] localQuickFixArray2 = new LocalQuickFix[1];
                    localQuickFixArray = localQuickFixArray2;
                    localQuickFixArray2[0] = fix;
                } else {
                    localQuickFixArray = null;
                }
                fixes = localQuickFixArray;
            } else {
                fixes = null;
            }
            PsiElement element2 = (PsiElement)ObjectUtils.notNull((Object)member.getNameIdentifier(), (Object)member);
            if (!element2.isPhysical()) {
                element2 = element2.getNavigationElement();
            }
            holder.registerProblem(element2, this.createErrorMessage(name, (String)shortName), fixes);
        });
    }

    protected void checkName(@NotNull T member, @NotNull Consumer<? super String> errorRegister) {
        for (NamingConvention<T> namingConvention : this.myNamingConventions.values()) {
            if (!namingConvention.isApplicable(member)) continue;
            String shortName = namingConvention.getShortName();
            if (this.myDisabledShortNames.contains(shortName)) break;
            NamingConventionBean activeBean = this.myNamingConventionBeans.get(shortName);
            if (activeBean instanceof NamingConventionWithFallbackBean && ((NamingConventionWithFallbackBean)activeBean).isInheritDefaultSettings()) {
                LOG.assertTrue(this.myDefaultConventionShortName != null, (Object)(activeBean + " expects that default conversion is configured"));
                shortName = this.myDefaultConventionShortName;
                if (this.myDisabledShortNames.contains(shortName)) break;
                activeBean = this.myNamingConventionBeans.get(shortName);
                namingConvention = this.myNamingConventions.get(shortName);
            }
            if (namingConvention.isValid(member, activeBean)) break;
            errorRegister.accept(shortName);
            break;
        }
    }

    @Nullable
    public JComponent createOptionsPanel() {
        JPanel panel2 = new JPanel(new BorderLayout(JBUIScale.scale((int)2), JBUIScale.scale((int)2)));
        CardLayout layout = new CardLayout();
        final JPanel descriptionPanel = new JPanel(layout);
        descriptionPanel.setBorder(JBUI.Borders.empty((int)2));
        panel2.add((Component)descriptionPanel, "Center");
        CheckBoxList list2 = new CheckBoxList();
        list2.setBorder(JBUI.Borders.empty((int)2));
        final ArrayList<NamingConvention<T>> values2 = new ArrayList<NamingConvention<T>>(this.myNamingConventions.values());
        Collections.reverse(values2);
        for (NamingConvention namingConvention : values2) {
            String shortName = namingConvention.getShortName();
            list2.addItem((Object)namingConvention, namingConvention.getElementDescription(), !this.myDisabledShortNames.contains(shortName));
            descriptionPanel.add((Component)this.myNamingConventionBeans.get(shortName).createOptionsPanel(), shortName);
        }
        list2.addListSelectionListener(e -> {
            int selectedIndex = list2.getSelectedIndex();
            NamingConvention item = (NamingConvention)list2.getItemAt(selectedIndex);
            if (item != null) {
                String shortName = item.getShortName();
                layout.show(descriptionPanel, shortName);
                UIUtil.setEnabled((Component)descriptionPanel, (boolean)list2.isItemSelected(selectedIndex), (boolean)true);
            }
        });
        list2.setCheckBoxListListener(new CheckBoxListListener(){

            public void checkBoxSelectionChanged(int index, boolean value2) {
                NamingConvention convention = (NamingConvention)values2.get(index);
                AbstractNamingConventionInspection.this.setEnabled(value2, convention.getShortName());
                UIUtil.setEnabled((Component)descriptionPanel, (boolean)value2, (boolean)true);
            }
        });
        list2.setSelectedIndex(0);
        panel2.add((Component)new JBScrollPane((Component)list2), "West");
        return panel2;
    }

    public void setEnabled(boolean value2, String conventionShortName) {
        if (value2) {
            this.myDisabledShortNames.remove(conventionShortName);
        } else {
            this.myDisabledShortNames.add(conventionShortName);
        }
    }
}

