/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.ex;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInsight.daemon.impl.SeverityRegistrar;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.codeInspection.ex.ScopeToolState;
import com.intellij.codeInspection.ex.Tools;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.packageDependencies.DependencyValidationManager;
import com.intellij.profile.codeInspection.InspectionProfileManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.scope.packageSet.CustomScopesProviderEx;
import com.intellij.psi.search.scope.packageSet.NamedScope;
import com.intellij.psi.search.scope.packageSet.NamedScopesHolder;
import com.intellij.psi.search.scope.packageSet.PackageSet;
import com.intellij.psi.search.scope.packageSet.PackageSetBase;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.SmartList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ToolsImpl
implements Tools {
    @NonNls
    static final String ENABLED_BY_DEFAULT_ATTRIBUTE = "enabled_by_default";
    @NonNls
    static final String ENABLED_ATTRIBUTE = "enabled";
    @NonNls
    static final String LEVEL_ATTRIBUTE = "level";
    private final String myShortName;
    private final ScopeToolState myDefaultState;
    private List<ScopeToolState> myTools;
    private boolean myEnabled;

    ToolsImpl(@NotNull InspectionToolWrapper toolWrapper, @NotNull HighlightDisplayLevel level, boolean enabled, boolean enabledByDefault) {
        this.myShortName = toolWrapper.getShortName();
        this.myDefaultState = new ScopeToolState(CustomScopesProviderEx.getAllScope(), toolWrapper, enabledByDefault, level);
        this.myTools = null;
        this.myEnabled = enabled;
    }

    @NotNull
    public ScopeToolState addTool(@NotNull NamedScope scope, @NotNull InspectionToolWrapper toolWrapper, boolean enabled, @NotNull HighlightDisplayLevel level) {
        return this.insertTool(scope, toolWrapper, enabled, level, this.myTools != null ? this.myTools.size() : 0);
    }

    @NotNull
    ScopeToolState prependTool(@NotNull NamedScope scope, @NotNull InspectionToolWrapper toolWrapper, boolean enabled, @NotNull HighlightDisplayLevel level) {
        return this.insertTool(scope, toolWrapper, enabled, level, 0);
    }

    @NotNull
    public ScopeToolState addTool(@NotNull String scopeName, @NotNull InspectionToolWrapper toolWrapper, boolean enabled, @NotNull HighlightDisplayLevel level) {
        return this.insertTool(new ScopeToolState(scopeName, toolWrapper, enabled, level), this.myTools != null ? this.myTools.size() : 0);
    }

    @NotNull
    private ScopeToolState insertTool(@NotNull NamedScope scope, @NotNull InspectionToolWrapper toolWrapper, boolean enabled, @NotNull HighlightDisplayLevel level, int idx) {
        return this.insertTool(new ScopeToolState(scope, toolWrapper, enabled, level), idx);
    }

    @NotNull
    private ScopeToolState insertTool(@NotNull ScopeToolState scopeToolState, int idx) {
        if (this.myTools == null) {
            this.myTools = new ArrayList<ScopeToolState>();
            if (scopeToolState.isEnabled()) {
                this.setEnabled(true);
            }
        }
        this.myTools.add(idx, scopeToolState);
        return scopeToolState;
    }

    @NotNull
    public InspectionToolWrapper getInspectionTool(@Nullable PsiElement element2) {
        if (this.myTools != null) {
            Project project = element2 == null ? null : element2.getProject();
            PsiFile containingFile = element2 == null ? null : InjectedLanguageManager.getInstance((Project)project).getTopLevelFile(element2);
            for (ScopeToolState state : this.myTools) {
                PackageSet packageSet;
                if (element2 == null) {
                    return state.getTool();
                }
                NamedScope scope = state.getScope(project);
                if (scope == null || (packageSet = scope.getValue()) == null || containingFile == null || !packageSet.contains(containingFile, (NamedScopesHolder)DependencyValidationManager.getInstance((Project)project))) continue;
                return state.getTool();
            }
        }
        return this.myDefaultState.getTool();
    }

    @NotNull
    public String getShortName() {
        return this.myShortName;
    }

    void cleanupTools(@NotNull Project project) {
        for (ScopeToolState state : this.getTools()) {
            state.getTool().cleanup(project);
        }
    }

    void scopesChanged() {
        if (this.myTools != null) {
            for (ScopeToolState tool : this.myTools) {
                tool.scopesChanged();
            }
        }
        this.myDefaultState.scopesChanged();
    }

    public void writeExternal(@NotNull Element inspectionElement) {
        if (this.myTools != null) {
            for (ScopeToolState state : this.myTools) {
                Element scopeElement = new Element("scope");
                scopeElement.setAttribute("name", state.getScopeName());
                scopeElement.setAttribute(LEVEL_ATTRIBUTE, state.getLevel().getName());
                scopeElement.setAttribute(ENABLED_ATTRIBUTE, Boolean.toString(state.isEnabled()));
                InspectionToolWrapper toolWrapper = state.getTool();
                if (toolWrapper.isInitialized()) {
                    toolWrapper.getTool().writeSettings(scopeElement);
                }
                inspectionElement.addContent(scopeElement);
            }
        }
        inspectionElement.setAttribute(ENABLED_ATTRIBUTE, Boolean.toString(this.isEnabled()));
        inspectionElement.setAttribute(LEVEL_ATTRIBUTE, this.getLevel().getName());
        inspectionElement.setAttribute(ENABLED_BY_DEFAULT_ATTRIBUTE, Boolean.toString(this.myDefaultState.isEnabled()));
        InspectionToolWrapper toolWrapper = this.myDefaultState.getTool();
        if (toolWrapper.isInitialized()) {
            ScopeToolState.tryWriteSettings((InspectionProfileEntry)toolWrapper.getTool(), (Element)inspectionElement);
        }
    }

    void readExternal(@NotNull Element toolElement, @NotNull InspectionProfileManager profileManager, @Nullable Map<String, List<String>> dependencies) {
        HighlightDisplayLevel level;
        String levelName = toolElement.getAttributeValue(LEVEL_ATTRIBUTE);
        SeverityRegistrar registrar = profileManager.getSeverityRegistrar();
        HighlightDisplayLevel highlightDisplayLevel = level = levelName != null ? HighlightDisplayLevel.find((HighlightSeverity)registrar.getSeverity(levelName)) : null;
        if (level == null) {
            level = HighlightDisplayLevel.WARNING;
        }
        this.myDefaultState.setLevel(level);
        String enabled = toolElement.getAttributeValue(ENABLED_ATTRIBUTE);
        boolean isEnabled = Boolean.parseBoolean(enabled);
        String enabledTool = toolElement.getAttributeValue(ENABLED_BY_DEFAULT_ATTRIBUTE);
        this.myDefaultState.setEnabled(enabledTool != null ? Boolean.parseBoolean(enabledTool) : isEnabled);
        InspectionToolWrapper toolWrapper = this.myDefaultState.getTool();
        List scopeElements = toolElement.getChildren("scope");
        if (!scopeElements.isEmpty()) {
            SmartList scopeNames = new SmartList();
            for (Element scopeElement : scopeElements) {
                HighlightDisplayLevel scopeLevel;
                String scopeName = scopeElement.getAttributeValue("name");
                if (scopeName == null) continue;
                NamedScopesHolder scopesHolder = profileManager.getScopesManager();
                NamedScope namedScope = null;
                if (scopesHolder != null) {
                    namedScope = scopesHolder.getScope(scopeName);
                }
                String errorLevel = scopeElement.getAttributeValue(LEVEL_ATTRIBUTE);
                String enabledInScope = scopeElement.getAttributeValue(ENABLED_ATTRIBUTE);
                InspectionToolWrapper copyToolWrapper = toolWrapper.createCopy();
                if (scopeElement.getAttributes().size() > 3 || !scopeElement.getChildren().isEmpty()) {
                    copyToolWrapper.getTool().readSettings(scopeElement);
                }
                HighlightDisplayLevel highlightDisplayLevel2 = scopeLevel = errorLevel != null ? HighlightDisplayLevel.find((HighlightSeverity)registrar.getSeverity(errorLevel)) : null;
                if (scopeLevel == null) {
                    scopeLevel = level;
                }
                if (namedScope != null) {
                    this.addTool(namedScope, copyToolWrapper, Boolean.parseBoolean(enabledInScope), scopeLevel);
                } else {
                    this.addTool(scopeName, copyToolWrapper, Boolean.parseBoolean(enabledInScope), scopeLevel);
                }
                scopeNames.add(scopeName);
            }
            if (dependencies != null) {
                for (int i2 = 0; i2 < scopeNames.size(); ++i2) {
                    String scopeName = (String)scopeNames.get(i2);
                    List order = dependencies.computeIfAbsent(scopeName, __ -> new ArrayList());
                    for (int j = i2 + 1; j < scopeNames.size(); ++j) {
                        order.add(scopeNames.get(j));
                    }
                }
            }
        }
        if (toolElement.getAttributes().size() > 4 || toolElement.getChildren().size() > scopeElements.size()) {
            ScopeToolState.tryReadSettings((InspectionProfileEntry)toolWrapper.getTool(), (Element)toolElement);
        }
        this.myEnabled = isEnabled;
    }

    @NotNull
    public InspectionToolWrapper getTool() {
        if (this.myTools == null) {
            return this.myDefaultState.getTool();
        }
        return this.myTools.iterator().next().getTool();
    }

    @NotNull
    public List<ScopeToolState> getTools() {
        if (this.myTools == null) {
            return Collections.singletonList(this.myDefaultState);
        }
        ArrayList<ScopeToolState> result2 = new ArrayList<ScopeToolState>(this.myTools);
        result2.add(this.myDefaultState);
        return result2;
    }

    public void collectTools(@NotNull List<? super ScopeToolState> result2) {
        if (this.myTools != null) {
            result2.addAll(this.myTools);
        }
        result2.add((ScopeToolState)this.myDefaultState);
    }

    @NotNull
    public ScopeToolState getDefaultState() {
        return this.myDefaultState;
    }

    void setDefaultEnabled(boolean isEnabled) {
        this.getDefaultState().setEnabled(isEnabled);
        if (isEnabled) {
            this.setEnabled(true);
        } else {
            this.disableWholeToolIfCan();
        }
    }

    public void removeScope(@NotNull String scopeName) {
        if (this.myTools != null) {
            for (ScopeToolState tool : this.myTools) {
                if (!scopeName.equals(tool.getScopeName())) continue;
                this.myTools.remove(tool);
                break;
            }
            this.checkToolsIsEmpty();
        }
    }

    private void checkToolsIsEmpty() {
        if (this.myTools.isEmpty()) {
            this.myTools = null;
            this.setEnabled(this.myDefaultState.isEnabled());
        }
    }

    public void removeAllScopes() {
        this.myTools = null;
    }

    public void setScope(int idx, @NotNull NamedScope namedScope) {
        if (this.myTools != null && this.myTools.size() > idx && idx >= 0) {
            ScopeToolState scopeToolState = this.myTools.get(idx);
            InspectionToolWrapper toolWrapper = scopeToolState.getTool();
            this.myTools.remove(idx);
            this.myTools.add(idx, new ScopeToolState(namedScope, toolWrapper, scopeToolState.isEnabled(), scopeToolState.getLevel()));
        }
    }

    boolean isEnabled(NamedScope namedScope, Project project) {
        if (!this.myEnabled) {
            return false;
        }
        if (namedScope != null && this.myTools != null) {
            for (ScopeToolState state : this.myTools) {
                if (!Comparing.equal((Object)namedScope, (Object)state.getScope(project))) continue;
                return state.isEnabled();
            }
        }
        return this.myDefaultState.isEnabled();
    }

    @NotNull
    public HighlightDisplayLevel getLevel(PsiElement element2) {
        if (this.myTools == null || element2 == null) {
            return this.myDefaultState.getLevel();
        }
        Project project = element2.getProject();
        DependencyValidationManager manager = DependencyValidationManager.getInstance((Project)project);
        for (ScopeToolState state : this.myTools) {
            NamedScope scope = state.getScope(project);
            PackageSet set = scope != null ? scope.getValue() : null;
            if (set == null || !set.contains(element2.getContainingFile(), (NamedScopesHolder)manager)) continue;
            return state.getLevel();
        }
        return this.myDefaultState.getLevel();
    }

    @NotNull
    public HighlightDisplayLevel getLevel() {
        return this.myDefaultState.getLevel();
    }

    public boolean isEnabled() {
        return this.myEnabled;
    }

    public boolean isEnabled(PsiElement element2) {
        if (!this.myEnabled) {
            return false;
        }
        if (this.myTools == null || element2 == null) {
            return this.myDefaultState.isEnabled();
        }
        Project project = element2.getProject();
        DependencyValidationManager manager = DependencyValidationManager.getInstance((Project)project);
        for (ScopeToolState state : this.myTools) {
            PackageSet set;
            NamedScope scope = state.getScope(project);
            if (scope == null || (set = scope.getValue()) == null || !set.contains(element2.getContainingFile(), (NamedScopesHolder)manager)) continue;
            return state.isEnabled();
        }
        return this.myDefaultState.isEnabled();
    }

    @Nullable
    public InspectionToolWrapper getEnabledTool(@Nullable PsiElement element2, boolean includeDoNotShow) {
        if (!this.myEnabled) {
            return null;
        }
        if (this.myTools != null && element2 != null) {
            Project project = element2.getProject();
            DependencyValidationManager manager = DependencyValidationManager.getInstance((Project)project);
            for (ScopeToolState state : this.myTools) {
                PackageSet set;
                NamedScope scope = state.getScope(project);
                if (scope == null || (set = scope.getValue()) == null || !set.contains(element2.getContainingFile(), (NamedScopesHolder)manager)) continue;
                return state.isEnabled() && (includeDoNotShow || !HighlightDisplayLevel.DO_NOT_SHOW.equals(state.getLevel())) ? state.getTool() : null;
            }
        }
        return this.myDefaultState.isEnabled() && (includeDoNotShow || !HighlightDisplayLevel.DO_NOT_SHOW.equals(this.myDefaultState.getLevel())) ? this.myDefaultState.getTool() : null;
    }

    @Nullable
    public InspectionToolWrapper getEnabledTool(@Nullable PsiElement element2) {
        return this.getEnabledTool(element2, true);
    }

    public void setEnabled(boolean enabled) {
        this.myEnabled = enabled;
    }

    public void enableTool(@NotNull NamedScope namedScope, Project project) {
        if (this.myTools != null) {
            for (ScopeToolState state : this.myTools) {
                if (!namedScope.equals(state.getScope(project))) continue;
                state.setEnabled(true);
            }
        }
        this.setEnabled(true);
    }

    void disableTool(@NotNull NamedScope namedScope, Project project) {
        if (this.myTools != null) {
            for (ScopeToolState state : this.myTools) {
                if (!Comparing.equal((Object)state.getScope(project), (Object)namedScope)) continue;
                state.setEnabled(false);
            }
            this.disableWholeToolIfCan();
        }
    }

    public void disableTool(@NotNull PsiElement element2) {
        Project project = element2.getProject();
        DependencyValidationManager validationManager = DependencyValidationManager.getInstance((Project)project);
        if (this.myTools != null) {
            for (ScopeToolState state : this.myTools) {
                PackageSet packageSet;
                NamedScope scope = state.getScope(project);
                if (scope == null || (packageSet = scope.getValue()) == null) continue;
                PsiFile file2 = element2.getContainingFile();
                if (file2 != null) {
                    if (!packageSet.contains(file2, (NamedScopesHolder)validationManager)) continue;
                    state.setEnabled(false);
                    return;
                }
                VirtualFile virtualFile = PsiUtilCore.getVirtualFile((PsiElement)element2);
                if (!(packageSet instanceof PackageSetBase) || virtualFile == null || !((PackageSetBase)packageSet).contains(virtualFile, project, (NamedScopesHolder)validationManager)) continue;
                state.setEnabled(false);
                return;
            }
            this.myDefaultState.setEnabled(false);
        } else {
            this.myDefaultState.setEnabled(false);
            this.setEnabled(false);
        }
    }

    @NotNull
    public HighlightDisplayLevel getLevel(NamedScope scope, Project project) {
        if (this.myTools != null && scope != null) {
            for (ScopeToolState state : this.myTools) {
                if (!Comparing.equal((Object)state.getScope(project), (Object)scope)) continue;
                return state.getLevel();
            }
        }
        return this.myDefaultState.getLevel();
    }

    public boolean equals(Object o) {
        if (!(o instanceof ToolsImpl)) {
            return false;
        }
        ToolsImpl tools = (ToolsImpl)o;
        if (this.myEnabled != tools.myEnabled) {
            return false;
        }
        if (this.getTools().size() != tools.getTools().size()) {
            return false;
        }
        for (int i2 = 0; i2 < this.getTools().size(); ++i2) {
            ScopeToolState toolState;
            ScopeToolState state = this.getTools().get(i2);
            if (state.equalTo(toolState = tools.getTools().get(i2))) continue;
            return false;
        }
        return true;
    }

    public void setLevel(@NotNull HighlightDisplayLevel level, @Nullable String scopeName, Project project) {
        if (scopeName == null) {
            this.myDefaultState.setLevel(level);
        } else {
            if (this.myTools == null) {
                return;
            }
            ScopeToolState scopeToolState = null;
            int index = -1;
            for (int i2 = 0; i2 < this.myTools.size(); ++i2) {
                ScopeToolState tool = this.myTools.get(i2);
                if (!scopeName.equals(tool.getScopeName())) continue;
                scopeToolState = tool;
                this.myTools.remove(tool);
                index = i2;
                break;
            }
            if (index < 0) {
                throw new IllegalStateException("Scope " + scopeName + " not found");
            }
            InspectionToolWrapper toolWrapper = scopeToolState.getTool();
            NamedScope scope = scopeToolState.getScope(project);
            if (scope != null) {
                this.myTools.add(index, new ScopeToolState(scope, toolWrapper, scopeToolState.isEnabled(), level));
            } else {
                this.myTools.add(index, new ScopeToolState(scopeToolState.getScopeName(), toolWrapper, scopeToolState.isEnabled(), level));
            }
        }
    }

    public void setDefaultState(@NotNull InspectionToolWrapper toolWrapper, boolean enabled, @NotNull HighlightDisplayLevel level) {
        this.myDefaultState.setTool(toolWrapper);
        this.myDefaultState.setLevel(level);
        this.myDefaultState.setEnabled(enabled);
    }

    public void setLevel(@NotNull HighlightDisplayLevel level) {
        this.myDefaultState.setLevel(level);
    }

    @Nullable
    public List<ScopeToolState> getNonDefaultTools() {
        return this.myTools;
    }

    private void disableWholeToolIfCan() {
        if (this.myDefaultState.isEnabled()) {
            return;
        }
        if (this.myTools != null) {
            for (ScopeToolState tool : this.myTools) {
                if (!tool.isEnabled()) continue;
                return;
            }
        }
        this.setEnabled(false);
    }
}

