/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.ex;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.codeInspection.BatchQuickFix;
import com.intellij.codeInspection.CommonProblemDescriptor;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.QuickFix;
import com.intellij.codeInspection.ex.BatchModeDescriptorsUtil;
import com.intellij.codeInspection.ex.GlobalInspectionContextImpl;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.codeInspection.ex.QuickFixAction;
import com.intellij.codeInspection.reference.RefElement;
import com.intellij.codeInspection.reference.RefEntity;
import com.intellij.codeInspection.reference.RefManager;
import com.intellij.codeInspection.ui.InspectionToolPresentation;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LocalQuickFixWrapper
extends QuickFixAction {
    private final QuickFix myFix;

    public LocalQuickFixWrapper(@NotNull QuickFix fix, @NotNull InspectionToolWrapper toolWrapper) {
        super(fix.getName(), toolWrapper);
        this.myFix = fix;
        this.setText(StringUtil.escapeMnemonics((String)this.myFix.getName()));
    }

    public void setText(@NotNull String text) {
        this.getTemplatePresentation().setText(text);
    }

    @Override
    protected boolean isProblemDescriptorsAcceptable() {
        return true;
    }

    @NotNull
    public QuickFix getFix() {
        return this.myFix;
    }

    @Nullable
    private QuickFix getWorkingQuickFix(QuickFix @NotNull [] fixes) {
        for (QuickFix fix : fixes) {
            if (!fix.getFamilyName().equals(this.myFix.getFamilyName())) continue;
            return fix;
        }
        return null;
    }

    @Override
    protected boolean applyFix(RefEntity @NotNull [] refElements) {
        return true;
    }

    @Override
    protected void applyFix(@NotNull Project project, @NotNull GlobalInspectionContextImpl context, CommonProblemDescriptor @NotNull [] descriptors, @NotNull Set<? super PsiElement> ignoredElements) {
        if (this.myFix instanceof BatchQuickFix) {
            ArrayList collectedElementsToIgnore = new ArrayList();
            Runnable refreshViews = () -> {
                DaemonCodeAnalyzer.getInstance((Project)project).restart();
                for (CommonProblemDescriptor descriptor2 : descriptors) {
                    this.ignore(ignoredElements, descriptor2, this.getWorkingQuickFix(descriptor2.getFixes()) != null, context);
                }
                RefManager refManager = context.getRefManager();
                RefElement[] refElements = new RefElement[collectedElementsToIgnore.size()];
                int collectedElementsToIgnoreSize = collectedElementsToIgnore.size();
                for (int i2 = 0; i2 < collectedElementsToIgnoreSize; ++i2) {
                    refElements[i2] = refManager.getReference((PsiElement)collectedElementsToIgnore.get(i2));
                }
                LocalQuickFixWrapper.removeElements((RefEntity[])refElements, project, this.myToolWrapper);
            };
            ((BatchQuickFix)this.myFix).applyFix(project, descriptors, collectedElementsToIgnore, refreshViews);
            return;
        }
        boolean restart = false;
        for (CommonProblemDescriptor descriptor2 : descriptors) {
            QuickFix fix;
            QuickFix[] fixes;
            if (descriptor2 == null || (fixes = descriptor2.getFixes()) == null || (fix = this.getWorkingQuickFix(fixes)) == null) continue;
            fix.applyFix(project, descriptor2);
            restart = true;
            this.ignore(ignoredElements, descriptor2, true, context);
        }
        if (restart) {
            DaemonCodeAnalyzer.getInstance((Project)project).restart();
        }
    }

    @Override
    protected boolean startInWriteAction() {
        return this.myFix.startInWriteAction();
    }

    @Override
    protected void performFixesInBatch(@NotNull Project project, @NotNull List<CommonProblemDescriptor[]> descriptors, @NotNull GlobalInspectionContextImpl context, Set<? super PsiElement> ignoredElements) {
        if (this.myFix instanceof BatchQuickFix) {
            this.applyFix(project, context, BatchModeDescriptorsUtil.flattenDescriptors(descriptors), ignoredElements);
        } else {
            super.performFixesInBatch(project, descriptors, context, ignoredElements);
        }
    }

    private void ignore(@NotNull Collection<? super PsiElement> ignoredElements, @NotNull CommonProblemDescriptor descriptor2, boolean hasFix, @NotNull GlobalInspectionContextImpl context) {
        PsiElement element2;
        if (hasFix) {
            InspectionToolPresentation presentation2 = context.getPresentation(this.myToolWrapper);
            presentation2.resolveProblem(descriptor2);
        }
        if (descriptor2 instanceof ProblemDescriptor && (element2 = ((ProblemDescriptor)descriptor2).getPsiElement()) != null) {
            ignoredElements.add((PsiElement)element2);
        }
    }
}

