/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.ex;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.stream.JsonWriter;
import com.intellij.codeInspection.InspectionsReportConverter;
import com.intellij.codeInspection.ex.Tools;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.CharsetToolkit;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JsonInspectionsReportConverter
implements InspectionsReportConverter {
    @NonNls
    private static final String FORMAT_NAME = "json";
    @NonNls
    private static final String JSON_EXTENSION = ".json";
    @NonNls
    private static final String FILE = "file";
    @NonNls
    private static final String LINE = "line";
    @NonNls
    private static final String OFFSET = "offset";
    @NonNls
    private static final String LENGTH = "length";
    @NonNls
    private static final String MODULE = "module";
    @NonNls
    private static final String PACKAGE = "package";
    @NonNls
    protected static final String PROBLEM = "problem";
    @NonNls
    protected static final String PROBLEMS = "problems";
    @NonNls
    private static final String DESCRIPTION = "description";
    @NonNls
    private static final String SEVERITY_ATTR = "severity";
    @NonNls
    private static final String ATTRIBUTE_KEY_ATTR = "attribute_key";
    @NonNls
    private static final String HINT = "hint";
    @NonNls
    private static final String HINTS = "hints";
    @NonNls
    private static final String DISPLAY_NAME = "displayName";
    @NonNls
    private static final String DEFAULT_SEVERITY = "defaultSeverity";
    @NonNls
    private static final String SHORT_NAME = "shortName";
    @NonNls
    private static final String ENABLED = "enabled";
    @NonNls
    private static final String NAME = "name";
    @NonNls
    private static final String ID = "id";
    @NonNls
    private static final String VALUE = "value";
    @NonNls
    private static final String GROUP = "group";
    @NonNls
    private static final String GROUPS = "groups";
    @NonNls
    private static final String INSPECTION = "inspection";
    @NonNls
    private static final String HIGHLIGHTED_ELEMENT = "highlighted_element";
    @NonNls
    private static final String PROJECT_FINGERPRINT = "ProjectFingerprint";
    @NonNls
    private static final String FILE_FINGERPRINT = "file_fingerprint";
    @NonNls
    private static final String FILE_NAME = "file_name";
    @NonNls
    private static final String FILE_PATH = "file_path";
    @NonNls
    private static final String LANGUAGE = "language";
    @NonNls
    private static final String LINES_COUNT = "lines_count";
    @NonNls
    private static final String MODIFICATION_TIMESTAMP = "modification_timestamp";
    @NonNls
    private static final String DUPLICATED_CODE_AGGREGATE = "DuplicatedCode_aggregate";

    public String getFormatName() {
        return FORMAT_NAME;
    }

    public boolean useTmpDirForRawData() {
        return true;
    }

    public void convert(@NotNull String rawDataDirectoryPath, @Nullable String outputPath, @NotNull Map<String, Tools> tools, @NotNull List<? extends File> inspectionsResults) throws InspectionsReportConverter.ConversionException {
        if (outputPath == null) {
            throw new InspectionsReportConverter.ConversionException("Output path isn't specified");
        }
        try {
            Files.createDirectories(new File(outputPath).toPath(), new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new InspectionsReportConverter.ConversionException("Cannot create dirs in output path: " + outputPath + " error: " + e.getMessage());
        }
        Gson gson2 = new GsonBuilder().setPrettyPrinting().create();
        SAXBuilder builder2 = new SAXBuilder();
        for (File file2 : inspectionsResults) {
            String fileNameWithoutExt = FileUtil.getNameWithoutExtension((File)file2);
            File jsonFile = new File(outputPath, fileNameWithoutExt + JSON_EXTENSION);
            try {
                BufferedWriter writer = Files.newBufferedWriter(jsonFile.toPath(), CharsetToolkit.UTF8_CHARSET, new OpenOption[0]);
                Throwable throwable = null;
                try {
                    JsonWriter jsonWriter = gson2.newJsonWriter((Writer)writer);
                    Throwable throwable2 = null;
                    try {
                        Document doc = builder2.build(file2);
                        if (".descriptions".equals(fileNameWithoutExt)) {
                            JsonInspectionsReportConverter.convertDescriptions(jsonWriter, doc);
                            continue;
                        }
                        if (PROJECT_FINGERPRINT.equals(fileNameWithoutExt)) {
                            JsonInspectionsReportConverter.convertProjectFingerprint(jsonWriter, doc);
                            continue;
                        }
                        if (DUPLICATED_CODE_AGGREGATE.equals(fileNameWithoutExt)) {
                            JsonInspectionsReportConverter.convertDuplicatedCode(jsonWriter, doc);
                            continue;
                        }
                        JsonInspectionsReportConverter.convertProblems(jsonWriter, doc);
                    }
                    catch (Throwable throwable3) {
                        throwable2 = throwable3;
                        throw throwable3;
                    }
                    finally {
                        if (jsonWriter == null) continue;
                        if (throwable2 != null) {
                            try {
                                jsonWriter.close();
                            }
                            catch (Throwable throwable4) {
                                throwable2.addSuppressed(throwable4);
                            }
                            continue;
                        }
                        jsonWriter.close();
                    }
                }
                catch (Throwable throwable5) {
                    throwable = throwable5;
                    throw throwable5;
                }
                finally {
                    if (writer == null) continue;
                    if (throwable != null) {
                        try {
                            ((Writer)writer).close();
                        }
                        catch (Throwable throwable6) {
                            throwable.addSuppressed(throwable6);
                        }
                        continue;
                    }
                    ((Writer)writer).close();
                }
            }
            catch (IOException | JDOMException e) {
                throw new InspectionsReportConverter.ConversionException("Cannot convert file: " + file2.getPath() + " error: " + e.getMessage());
            }
        }
    }

    private static void convertDuplicatedCode(@NotNull JsonWriter jsonWriter, @NotNull Document problems2) throws IOException {
        jsonWriter.beginObject();
        jsonWriter.name(PROBLEMS);
        jsonWriter.beginArray();
        for (Element duplicates : problems2.getRootElement().getChildren("duplicate")) {
            jsonWriter.beginArray();
            for (Element fragment : duplicates.getChildren("fragment")) {
                JsonInspectionsReportConverter.convertDuplicateFragment(jsonWriter, fragment);
            }
            jsonWriter.endArray();
        }
        jsonWriter.endArray();
        jsonWriter.endObject();
    }

    private static void convertDuplicateFragment(@NotNull JsonWriter jsonWriter, Element fragment) throws IOException {
        jsonWriter.beginObject();
        jsonWriter.name(FILE).value(fragment.getAttributeValue(FILE));
        String line = fragment.getAttributeValue(LINE);
        String start2 = fragment.getAttributeValue("start");
        String end = fragment.getAttributeValue("end");
        assert (line != null);
        assert (start2 != null);
        assert (end != null);
        jsonWriter.name(LINE).value((long)Integer.parseInt(line));
        jsonWriter.name("start").value((long)Integer.parseInt(start2));
        jsonWriter.name("end").value((long)Integer.parseInt(end));
        jsonWriter.endObject();
    }

    private static void convertProjectFingerprint(@NotNull JsonWriter jsonWriter, @NotNull Document problems2) throws IOException {
        jsonWriter.beginObject();
        jsonWriter.name(PROBLEMS);
        jsonWriter.beginArray();
        for (Element fileFingerprint : problems2.getRootElement().getChildren(FILE_FINGERPRINT)) {
            JsonInspectionsReportConverter.convertFileFingerprint(jsonWriter, fileFingerprint);
        }
        jsonWriter.endArray();
        jsonWriter.endObject();
    }

    private static void convertFileFingerprint(@NotNull JsonWriter writer, @NotNull Element problem) throws IOException {
        writer.beginObject();
        writer.name(FILE_NAME).value(problem.getChildText(FILE_NAME));
        writer.name(FILE_PATH).value(problem.getChildText(FILE_PATH));
        writer.name(LANGUAGE).value(problem.getChildText(LANGUAGE));
        try {
            int linesCount = Integer.parseInt(problem.getChildText(LINES_COUNT));
            writer.name(LINES_COUNT).value((long)linesCount);
        }
        catch (NumberFormatException e) {
            writer.name(LINES_COUNT).nullValue();
        }
        try {
            long modificationStamp = Long.parseLong(problem.getChildText(MODIFICATION_TIMESTAMP));
            writer.name(MODIFICATION_TIMESTAMP).value(modificationStamp);
        }
        catch (NumberFormatException e) {
            writer.name(MODIFICATION_TIMESTAMP).nullValue();
        }
        writer.endObject();
    }

    private static void convertProblems(@NotNull JsonWriter jsonWriter, @NotNull Document problems2) throws IOException {
        jsonWriter.beginObject();
        jsonWriter.name(PROBLEMS);
        jsonWriter.beginArray();
        for (Element problem : problems2.getRootElement().getChildren(PROBLEM)) {
            JsonInspectionsReportConverter.convertProblem(jsonWriter, problem);
        }
        jsonWriter.endArray();
        jsonWriter.endObject();
    }

    protected static void convertProblem(@NotNull JsonWriter writer, @NotNull Element problem) throws IOException {
        Element hints2;
        Element entryPoint;
        writer.beginObject();
        writer.name(FILE).value(problem.getChildText(FILE));
        JsonInspectionsReportConverter.writeInt(writer, problem, LINE);
        JsonInspectionsReportConverter.writeInt(writer, problem, OFFSET);
        JsonInspectionsReportConverter.writeInt(writer, problem, LENGTH);
        writer.name(MODULE).value(problem.getChildText(MODULE));
        writer.name(PACKAGE).value(problem.getChildText(PACKAGE));
        Element problemClassElement = problem.getChild("problem_class");
        if (problemClassElement != null) {
            JsonInspectionsReportConverter.convertProblemClass(writer, problemClassElement);
        }
        if ((entryPoint = problem.getChild("entry_point")) != null) {
            JsonInspectionsReportConverter.convertEntryPoint(writer, entryPoint);
        }
        if ((hints2 = problem.getChild(HINTS)) != null) {
            JsonInspectionsReportConverter.convertHints(writer, hints2);
        }
        writer.name(HIGHLIGHTED_ELEMENT).value(problem.getChildText(HIGHLIGHTED_ELEMENT));
        writer.name(DESCRIPTION).value(problem.getChildText(DESCRIPTION));
        writer.endObject();
    }

    private static void writeInt(@NotNull JsonWriter writer, @NotNull Element problem, @NotNull String elementName) throws IOException {
        try {
            int intValue = Integer.parseInt(problem.getChildText(elementName));
            writer.name(elementName).value((long)intValue);
        }
        catch (NumberFormatException e) {
            writer.name(elementName).nullValue();
        }
    }

    private static void convertProblemClass(@NotNull JsonWriter writer, @NotNull Element problemClass) throws IOException {
        writer.name("problem_class");
        writer.beginObject().name(NAME).value(problemClass.getText());
        String inspectionId = problemClass.getAttributeValue(ID);
        if (inspectionId != null) {
            writer.name(ID).value(inspectionId);
        }
        writer.name(SEVERITY_ATTR).value(problemClass.getAttributeValue(SEVERITY_ATTR)).name(ATTRIBUTE_KEY_ATTR).value(problemClass.getAttributeValue(ATTRIBUTE_KEY_ATTR)).endObject();
    }

    private static void convertEntryPoint(@NotNull JsonWriter writer, @NotNull Element entryPoint) throws IOException {
        writer.name("entry_point");
        writer.beginObject().name("TYPE").value(entryPoint.getAttributeValue("TYPE")).name("FQNAME").value(entryPoint.getAttributeValue("FQNAME")).endObject();
    }

    private static void convertHints(@NotNull JsonWriter writer, @NotNull Element hints2) throws IOException {
        writer.name(HINTS);
        writer.beginArray();
        for (Element hint : hints2.getChildren(HINT)) {
            writer.value(hint.getAttributeValue(VALUE));
        }
        writer.endArray();
    }

    private static void convertDescriptions(@NotNull JsonWriter writer, @NotNull Document descriptions) throws IOException {
        writer.beginObject();
        JsonInspectionsReportConverter.convertDescriptionsContents(writer, descriptions, null);
        writer.endObject();
    }

    protected static void convertDescriptionsContents(@NotNull JsonWriter writer, @NotNull Document descriptions, @Nullable Predicate<String> inspectionFilter) throws IOException {
        Element inspectionsElement = descriptions.getRootElement();
        writer.name("profile").value(inspectionsElement.getAttributeValue("profile"));
        writer.name(GROUPS);
        writer.beginArray();
        for (Element group : inspectionsElement.getChildren(GROUP)) {
            JsonInspectionsReportConverter.convertGroup(writer, group, inspectionFilter);
        }
        writer.endArray();
    }

    private static void convertGroup(@NotNull JsonWriter writer, @NotNull Element group, @Nullable Predicate<String> inspectionFilter) throws IOException {
        if (inspectionFilter != null) {
            boolean anyInspectionsInFilter = false;
            for (Element inspection : group.getChildren(INSPECTION)) {
                if (!inspectionFilter.test(inspection.getAttributeValue(SHORT_NAME))) continue;
                anyInspectionsInFilter = true;
                break;
            }
            if (!anyInspectionsInFilter) {
                return;
            }
        }
        writer.beginObject();
        writer.name(NAME).value(group.getAttributeValue(NAME));
        writer.name("inspections").beginArray();
        for (Element inspection : group.getChildren(INSPECTION)) {
            if (inspectionFilter != null && !inspectionFilter.test(inspection.getAttributeValue(SHORT_NAME))) continue;
            JsonInspectionsReportConverter.convertInspectionDescription(writer, inspection);
        }
        writer.endArray();
        writer.endObject();
    }

    private static void convertInspectionDescription(@NotNull JsonWriter writer, @NotNull Element inspection) throws IOException {
        writer.beginObject().name(SHORT_NAME).value(inspection.getAttributeValue(SHORT_NAME)).name(DISPLAY_NAME).value(inspection.getAttributeValue(DISPLAY_NAME)).name(DEFAULT_SEVERITY).value(inspection.getAttributeValue(DEFAULT_SEVERITY)).name(ENABLED).value(Boolean.parseBoolean(inspection.getAttributeValue(ENABLED))).name(DESCRIPTION).value(inspection.getValue()).endObject();
    }
}

