/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.ex;

import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.openapi.Disposable;
import com.intellij.util.containers.DisposableWrapperList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class InspectionToolsSupplier
implements Disposable {
    protected final DisposableWrapperList<Listener> listeners = new DisposableWrapperList();

    @NotNull
    public abstract List<InspectionToolWrapper<?, ?>> createTools();

    public void addListener(@NotNull Listener listener2, @Nullable Disposable parentDisposable) {
        if (parentDisposable == null) {
            this.listeners.add((Object)listener2);
        } else {
            this.listeners.add((Object)listener2, parentDisposable);
        }
    }

    public void dispose() {
        this.listeners.clear();
    }

    public static final class Simple
    extends InspectionToolsSupplier {
        @NotNull
        private final List<InspectionToolWrapper<?, ?>> myTools;

        public Simple(@NotNull List<InspectionToolWrapper<?, ?>> tools) {
            this.myTools = tools;
        }

        @Override
        @NotNull
        public List<InspectionToolWrapper<?, ?>> createTools() {
            return this.myTools;
        }
    }

    public static interface Listener {
        public void toolAdded(@NotNull InspectionToolWrapper<?, ?> var1);

        public void toolRemoved(@NotNull InspectionToolWrapper<?, ?> var1);
    }
}

