/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.ex;

import com.intellij.analysis.AnalysisScope;
import com.intellij.codeInspection.CommonProblemDescriptor;
import com.intellij.codeInspection.ex.GlobalInspectionContextImpl;
import com.intellij.codeInspection.ex.InspectionRVContentProvider;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.codeInspection.ex.QuickFixAction;
import com.intellij.codeInspection.reference.RefElement;
import com.intellij.codeInspection.reference.RefEntity;
import com.intellij.codeInspection.ui.InspectionResultsView;
import com.intellij.codeInspection.ui.InspectionToolPresentation;
import com.intellij.codeInspection.ui.InspectionTree;
import com.intellij.codeInspection.ui.InspectionTreeModel;
import com.intellij.codeInspection.ui.InspectionTreeNode;
import com.intellij.codeInspection.ui.util.SynchronizedBidiMultiMap;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.util.ArrayUtil;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;

public class InspectionRVContentProviderImpl
extends InspectionRVContentProvider {
    @Override
    public boolean checkReportedProblems(@NotNull GlobalInspectionContextImpl context, @NotNull InspectionToolWrapper toolWrapper) {
        InspectionToolPresentation presentation2 = context.getPresentation(toolWrapper);
        presentation2.updateContent();
        AnalysisScope scope = context.getCurrentScope();
        if (scope == null) {
            return false;
        }
        SearchScope searchScope = scope.toSearchScope();
        if (searchScope instanceof LocalSearchScope) {
            Map<String, Set<RefEntity>> contents = presentation2.getContent();
            SynchronizedBidiMultiMap<RefEntity, CommonProblemDescriptor> problemElements = presentation2.getProblemElements();
            for (Set<RefEntity> entities2 : contents.values()) {
                Iterator<RefEntity> iterator2 = entities2.iterator();
                while (iterator2.hasNext()) {
                    TextRange range2;
                    PsiElement element2;
                    VirtualFile vFile;
                    SmartPsiElementPointer pointer;
                    RefEntity entity = iterator2.next();
                    if (entity instanceof RefElement && (pointer = ((RefElement)entity).getPointer()) != null && (vFile = pointer.getVirtualFile()) != null && searchScope.contains(vFile) && (element2 = ((RefElement)entity).getPsiElement()) != null && (range2 = element2.getTextRange()) != null && ((LocalSearchScope)searchScope).containsRange(element2.getContainingFile(), range2)) continue;
                    problemElements.remove(entity);
                    iterator2.remove();
                }
            }
        }
        return presentation2.hasReportedProblems();
    }

    @Override
    public QuickFixAction @NotNull [] getCommonQuickFixes(@NotNull InspectionToolWrapper toolWrapper, @NotNull InspectionTree tree) {
        InspectionToolPresentation presentation2 = tree.getContext().getPresentation(toolWrapper);
        QuickFixAction[] fixes = InspectionRVContentProviderImpl.getCommonFixes(presentation2, tree.getSelectedDescriptors());
        return (QuickFixAction[])ArrayUtil.mergeArrays((Object[])fixes, (Object[])presentation2.getQuickFixes(tree.getSelectedElements()), QuickFixAction[]::new);
    }

    @Override
    public void appendToolNodeContent(@NotNull GlobalInspectionContextImpl context, @NotNull InspectionToolWrapper wrapper2, @NotNull InspectionTreeNode toolNode, boolean showStructure, boolean groupBySeverity, @NotNull Map<String, Set<RefEntity>> contents, @NotNull Function<? super RefEntity, CommonProblemDescriptor[]> problems2) {
        InspectionResultsView view = context.getView();
        this.buildTree(context, contents, wrapper2, refElement -> new InspectionRVContentProvider.RefEntityContainer<Object>((RefEntity)refElement, (Descriptor[])((Object[])problems2.apply((RefEntity)refElement))), showStructure, toolNode, view.getTree().getInspectionTreeModel());
    }

    @Override
    protected void appendDescriptor(@NotNull GlobalInspectionContextImpl context, @NotNull InspectionToolWrapper toolWrapper, @NotNull InspectionRVContentProvider.RefEntityContainer container2, @NotNull InspectionTreeNode parent) {
        RefEntity refElement = container2.getRefEntity();
        InspectionTreeModel model = context.getView().getTree().getInspectionTreeModel();
        InspectionToolPresentation presentation2 = context.getPresentation(toolWrapper);
        CommonProblemDescriptor[] problems2 = (CommonProblemDescriptor[])container2.getDescriptors();
        if (problems2 != null && problems2.length != 0) {
            for (CommonProblemDescriptor problem : problems2) {
                assert (problem != null);
                model.createProblemDescriptorNode(refElement, problem, presentation2, parent);
            }
        }
    }
}

