/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.ex;

import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.codeInspection.ActionClassHolder;
import com.intellij.codeInspection.CommonProblemDescriptor;
import com.intellij.codeInspection.InspectionManagerBase;
import com.intellij.codeInspection.ProblemDescriptorBase;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.QuickFix;
import com.intellij.codeInspection.ex.GlobalInspectionContextImpl;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.codeInspection.ex.LocalQuickFixWrapper;
import com.intellij.codeInspection.ex.QuickFixAction;
import com.intellij.codeInspection.ex.ScopeToolState;
import com.intellij.codeInspection.ex.Tools;
import com.intellij.codeInspection.reference.RefDirectory;
import com.intellij.codeInspection.reference.RefElement;
import com.intellij.codeInspection.reference.RefEntity;
import com.intellij.codeInspection.reference.RefModule;
import com.intellij.codeInspection.ui.InspectionModuleNode;
import com.intellij.codeInspection.ui.InspectionToolPresentation;
import com.intellij.codeInspection.ui.InspectionTree;
import com.intellij.codeInspection.ui.InspectionTreeModel;
import com.intellij.codeInspection.ui.InspectionTreeNode;
import com.intellij.codeInspection.ui.ProblemDescriptionNode;
import com.intellij.codeInspection.ui.RefElementNode;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.containers.TreeTraversal;
import com.intellij.util.ui.tree.TreeUtil;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class InspectionRVContentProvider {
    private static final Logger LOG = Logger.getInstance(InspectionRVContentProvider.class);

    public abstract boolean checkReportedProblems(@NotNull GlobalInspectionContextImpl var1, @NotNull InspectionToolWrapper var2);

    public Iterable<? extends ScopeToolState> getTools(Tools tools) {
        return tools.getTools();
    }

    public boolean hasQuickFixes(InspectionTree tree) {
        TreePath[] treePaths = tree.getSelectionPaths();
        if (treePaths == null) {
            return false;
        }
        for (TreePath selectionPath : treePaths) {
            if (TreeUtil.treeNodeTraverser((TreeNode)((TreeNode)selectionPath.getLastPathComponent())).traverse(TreeTraversal.PRE_ORDER_DFS).processEach(node -> {
                ProblemDescriptionNode problemDescriptionNode;
                if (!((InspectionTreeNode)node).isValid()) {
                    return true;
                }
                if (node instanceof ProblemDescriptionNode && !(problemDescriptionNode = (ProblemDescriptionNode)node).isQuickFixAppliedFromView()) {
                    CommonProblemDescriptor descriptor2 = problemDescriptionNode.getDescriptor();
                    QuickFix[] fixes = descriptor2 != null ? descriptor2.getFixes() : null;
                    return fixes == null || fixes.length == 0;
                }
                return true;
            })) continue;
            return true;
        }
        return false;
    }

    public abstract QuickFixAction @NotNull [] getCommonQuickFixes(@NotNull InspectionToolWrapper var1, @NotNull InspectionTree var2);

    public QuickFixAction @NotNull [] getPartialQuickFixes(@NotNull InspectionToolWrapper toolWrapper, @NotNull InspectionTree tree) {
        GlobalInspectionContextImpl context = tree.getContext();
        InspectionToolPresentation presentation2 = context.getPresentation(toolWrapper);
        CommonProblemDescriptor[] descriptors = tree.getSelectedDescriptors();
        LinkedHashMap<String, FixAndOccurrences> result2 = new LinkedHashMap<String, FixAndOccurrences>();
        for (CommonProblemDescriptor d : descriptors) {
            QuickFix[] fixes = d.getFixes();
            if (fixes == null || fixes.length == 0) continue;
            for (QuickFix fix : fixes) {
                String familyName = fix.getFamilyName();
                FixAndOccurrences fixAndOccurrences = (FixAndOccurrences)result2.get(familyName);
                if (fixAndOccurrences == null) {
                    LocalQuickFixWrapper localQuickFixWrapper = new LocalQuickFixWrapper(fix, presentation2.getToolWrapper());
                    try {
                        localQuickFixWrapper.setText(StringUtil.escapeMnemonics((String)fix.getFamilyName()));
                    }
                    catch (AbstractMethodError e) {
                        localQuickFixWrapper.setText("Name is not available");
                    }
                    fixAndOccurrences = new FixAndOccurrences(localQuickFixWrapper);
                    result2.put(familyName, fixAndOccurrences);
                } else {
                    LocalQuickFixWrapper quickFixAction = fixAndOccurrences.fix;
                    InspectionRVContentProvider.checkFixClass(presentation2, fix, quickFixAction);
                }
                ++fixAndOccurrences.occurrences;
            }
        }
        return (QuickFixAction[])result2.values().stream().filter(fixAndOccurrence -> fixAndOccurrence.occurrences != descriptors.length).sorted(Comparator.comparingInt(fixAndOccurrence -> fixAndOccurrence.occurrences).reversed()).map(fixAndOccurrence -> {
            LocalQuickFixWrapper fix = fixAndOccurrence.fix;
            int occurrences = fixAndOccurrence.occurrences;
            fix.setText(fix.getText() + " (" + occurrences + " problem" + (occurrences == 1 ? "" : "s") + ")");
            return fix;
        }).toArray(QuickFixAction[]::new);
    }

    protected static void checkFixClass(InspectionToolPresentation presentation2, QuickFix fix, LocalQuickFixWrapper quickFixAction) {
        Class<?> class2;
        Class<?> class1 = InspectionRVContentProvider.getFixClass(fix);
        if (!class1.equals(class2 = InspectionRVContentProvider.getFixClass(quickFixAction.getFix()))) {
            String message = MessageFormat.format("QuickFix-es with the same family name ({0}) should be the same class instances but actually are {1} and {2} instances. Please assign reported exception for the inspection \"{3}\" (\"{4}\") developer.", fix.getFamilyName(), class1.getName(), class2.getName(), presentation2.getToolWrapper().getTool().getClass(), presentation2.getToolWrapper().getShortName());
            AssertionError error = new AssertionError((Object)message);
            StreamEx.of(presentation2.getProblemDescriptors()).select(ProblemDescriptorBase.class).map(ProblemDescriptorBase::getCreationTrace).nonNull().map(InspectionRVContentProvider::extractStackTrace).findFirst().ifPresent(arg_0 -> error.setStackTrace(arg_0));
            LOG.error(message, (Throwable)((Object)error));
        }
    }

    private static StackTraceElement[] extractStackTrace(Throwable throwable) {
        HashSet classes = ContainerUtil.newHashSet((Object[])new String[]{ProblemDescriptorBase.class.getName(), InspectionManagerBase.class.getName(), ProblemsHolder.class.getName()});
        return (StackTraceElement[])((StreamEx)StreamEx.of((Object[])throwable.getStackTrace()).dropWhile(ste -> classes.contains(ste.getClassName()))).toArray(StackTraceElement.class);
    }

    public void appendToolNodeContent(@NotNull GlobalInspectionContextImpl context, @NotNull InspectionToolWrapper wrapper2, @NotNull InspectionTreeNode parentNode, boolean showStructure, boolean groupBySeverity) {
        InspectionToolPresentation presentation2 = context.getPresentation(wrapper2);
        Map<String, Set<RefEntity>> content2 = presentation2.getContent();
        this.appendToolNodeContent(context, wrapper2, parentNode, showStructure, groupBySeverity, content2, entity -> {
            if (context.getUIOptions().FILTER_RESOLVED_ITEMS) {
                return presentation2.isExcluded((RefEntity)entity) ? null : presentation2.getProblemElements().get((RefEntity)entity);
            }
            CommonProblemDescriptor[] problems2 = (CommonProblemDescriptor[])ObjectUtils.notNull((Object)presentation2.getProblemElements().get((RefEntity)entity), (Object)CommonProblemDescriptor.EMPTY_ARRAY);
            CommonProblemDescriptor[] suppressedProblems = presentation2.getSuppressedProblems((RefEntity)entity);
            CommonProblemDescriptor[] resolvedProblems = presentation2.getResolvedProblems((RefEntity)entity);
            CommonProblemDescriptor[] result2 = new CommonProblemDescriptor[problems2.length + suppressedProblems.length + resolvedProblems.length];
            System.arraycopy(problems2, 0, result2, 0, problems2.length);
            System.arraycopy(suppressedProblems, 0, result2, problems2.length, suppressedProblems.length);
            System.arraycopy(resolvedProblems, 0, result2, problems2.length + suppressedProblems.length, resolvedProblems.length);
            return result2;
        });
    }

    public abstract void appendToolNodeContent(@NotNull GlobalInspectionContextImpl var1, @NotNull InspectionToolWrapper var2, @NotNull InspectionTreeNode var3, boolean var4, boolean var5, @NotNull Map<String, Set<RefEntity>> var6, @NotNull Function<? super RefEntity, CommonProblemDescriptor[]> var7);

    protected abstract void appendDescriptor(@NotNull GlobalInspectionContextImpl var1, @NotNull InspectionToolWrapper var2, @NotNull RefEntityContainer var3, @NotNull InspectionTreeNode var4);

    public boolean isContentLoaded() {
        return true;
    }

    protected <T> void buildTree(@NotNull GlobalInspectionContextImpl context, @NotNull Map<String, Set<T>> packageContents, @NotNull InspectionToolWrapper toolWrapper, @NotNull Function<? super T, ? extends RefEntityContainer<?>> computeContainer, boolean showStructure, InspectionTreeNode parent, InspectionTreeModel model) {
        MultiMap evaluatedDescriptors = MultiMap.create();
        for (Map.Entry<String, Set<T>> entry : packageContents.entrySet()) {
            String packageName = entry.getKey();
            for (T problemDescriptor : entry.getValue()) {
                RefEntityContainer<?> container2 = computeContainer.apply(problemDescriptor);
                evaluatedDescriptors.putValue((Object)packageName, container2);
                showStructure &= container2.supportStructure();
            }
        }
        for (Map.Entry<String, Set<Object>> entry : evaluatedDescriptors.entrySet()) {
            for (RefEntityContainer container3 : (Collection)entry.getValue()) {
                InspectionTreeNode currentParent = parent;
                if (showStructure) {
                    String packageName = entry.getKey();
                    Module module = container3.getModule(context.getProject());
                    InspectionModuleNode moduleNode = module != null ? model.createModuleNode(module, parent) : null;
                    InspectionTreeNode actualParent = moduleNode == null ? parent : moduleNode;
                    currentParent = packageName == null ? actualParent : model.createPackageNode(packageName, actualParent);
                }
                InspectionToolPresentation presentation2 = context.getPresentation(toolWrapper);
                RefElementNode node = container3.createNode(presentation2, model, currentParent, showStructure || HighlightInfoType.getUnusedSymbolDisplayName().equals(toolWrapper.getDisplayName()) || presentation2.isDummy());
                this.appendDescriptor(context, toolWrapper, container3, node);
            }
        }
    }

    protected static QuickFixAction @NotNull [] getCommonFixes(@NotNull InspectionToolPresentation presentation2, CommonProblemDescriptor @NotNull [] descriptors) {
        LinkedHashMap<String, LocalQuickFixWrapper> result2 = null;
        for (CommonProblemDescriptor d : descriptors) {
            QuickFix[] fixes = d.getFixes();
            if (fixes == null || fixes.length == 0) continue;
            if (result2 == null) {
                result2 = new LinkedHashMap<String, LocalQuickFixWrapper>();
                for (QuickFix fix : fixes) {
                    if (fix == null) continue;
                    result2.put(fix.getFamilyName(), new LocalQuickFixWrapper(fix, presentation2.getToolWrapper()));
                }
                continue;
            }
            for (String familyName : new ArrayList(result2.keySet())) {
                boolean isFound = false;
                for (QuickFix fix : fixes) {
                    if (fix == null || !familyName.equals(fix.getFamilyName())) continue;
                    isFound = true;
                    LocalQuickFixWrapper quickFixAction = (LocalQuickFixWrapper)((Object)result2.get(fix.getFamilyName()));
                    InspectionRVContentProvider.checkFixClass(presentation2, fix, quickFixAction);
                    try {
                        quickFixAction.setText(StringUtil.escapeMnemonics((String)fix.getFamilyName()));
                    }
                    catch (AbstractMethodError e) {
                        quickFixAction.setText("Name is not available");
                    }
                    break;
                }
                if (isFound) continue;
                result2.remove(familyName);
                if (!result2.isEmpty()) continue;
                return QuickFixAction.EMPTY;
            }
        }
        return result2 == null || result2.isEmpty() ? QuickFixAction.EMPTY : result2.values().toArray(QuickFixAction.EMPTY);
    }

    private static Class<?> getFixClass(QuickFix<?> fix) {
        return fix instanceof ActionClassHolder ? ((ActionClassHolder)fix).getActionClass() : fix.getClass();
    }

    private static class FixAndOccurrences {
        final LocalQuickFixWrapper fix;
        int occurrences;

        FixAndOccurrences(LocalQuickFixWrapper fix) {
            this.fix = fix;
        }
    }

    protected static class RefEntityContainer<Descriptor> {
        private final Descriptor[] myDescriptors;
        @Nullable
        private final RefEntity myEntity;

        public RefEntityContainer(@Nullable RefEntity entity, Descriptor[] descriptors) {
            this.myEntity = entity;
            this.myDescriptors = descriptors;
        }

        @NotNull
        public RefElementNode createNode(@NotNull InspectionToolPresentation presentation2, InspectionTreeModel model, InspectionTreeNode topParent, boolean showStructure) {
            InspectionTreeNode parent;
            RefEntityContainer<Descriptor> owner = this.getOwner();
            if (owner == null) {
                parent = topParent;
            } else {
                parent = owner.createNode(presentation2, model, topParent, showStructure);
                if (!showStructure) {
                    return (RefElementNode)parent;
                }
            }
            return model.createRefElementNode(this.myEntity, () -> presentation2.createRefNode(this.myEntity, model, parent), parent);
        }

        @Nullable
        public RefEntity getRefEntity() {
            return this.myEntity;
        }

        @Nullable
        protected String getModuleName() {
            RefModule refModule = this.myEntity instanceof RefElement ? ((RefElement)this.myEntity).getModule() : (this.myEntity instanceof RefModule ? (RefModule)this.myEntity : null);
            return refModule != null ? refModule.getName() : null;
        }

        @Nullable
        public Module getModule(Project project) {
            String name = this.getModuleName();
            if (name == null) {
                return null;
            }
            return (Module)ReadAction.compute(() -> ModuleManager.getInstance((Project)project).findModuleByName(name));
        }

        boolean supportStructure() {
            return this.myEntity == null || this.myEntity instanceof RefElement && !(this.myEntity instanceof RefDirectory);
        }

        public Descriptor[] getDescriptors() {
            return this.myDescriptors;
        }

        @Nullable
        private RefEntityContainer<Descriptor> getOwner() {
            if (this.myEntity == null) {
                return null;
            }
            RefEntity entity = this.myEntity.getOwner();
            return entity instanceof RefElement && !(entity instanceof RefDirectory) ? new RefEntityContainer<Descriptor>(entity, this.myDescriptors) : null;
        }
    }
}

