/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.ex;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInspection.InspectionProfile;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.Key;
import com.intellij.profile.codeInspection.InspectionProfileManager;
import com.intellij.psi.PsiElement;
import gnu.trove.THashSet;
import java.util.List;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;

public class InspectionProfileWrapper {
    private static final Logger LOG = Logger.getInstance(InspectionProfileWrapper.class);
    public static final Key<Function<InspectionProfileImpl, InspectionProfileWrapper>> CUSTOMIZATION_KEY = Key.create((String)"Inspection Profile Wrapper Customization");
    private static boolean alreadyChecked;
    protected final InspectionProfile myProfile;
    protected final InspectionProfileManager myProfileManager;

    public InspectionProfileWrapper(@NotNull InspectionProfileImpl profile) {
        this.myProfile = profile;
        this.myProfileManager = profile.getProfileManager();
    }

    public InspectionProfileWrapper(@NotNull InspectionProfile profile, @NotNull InspectionProfileManager profileManager) {
        this.myProfile = profile;
        this.myProfileManager = profileManager;
    }

    public InspectionProfileManager getProfileManager() {
        return this.myProfileManager;
    }

    public static void checkInspectionsDuplicates(@NotNull List<InspectionToolWrapper<?, ?>> toolWrappers) {
        if (alreadyChecked) {
            return;
        }
        alreadyChecked = true;
        THashSet uniqueTools = new THashSet(toolWrappers.size());
        for (InspectionToolWrapper<?, ?> toolWrapper : toolWrappers) {
            ProgressManager.checkCanceled();
            if (uniqueTools.add(toolWrapper.getTool())) continue;
            LOG.error("Inspection " + toolWrapper.getDisplayName() + " (" + toolWrapper.getTool().getClass() + ") already registered");
        }
    }

    public boolean isToolEnabled(HighlightDisplayKey key, PsiElement element2) {
        return this.myProfile.isToolEnabled(key, element2);
    }

    @NotNull
    public HighlightDisplayLevel getErrorLevel(@NotNull HighlightDisplayKey inspectionToolKey, PsiElement element2) {
        return this.myProfile.getErrorLevel(inspectionToolKey, element2);
    }

    public InspectionToolWrapper<?, ?> getInspectionTool(String shortName, PsiElement element2) {
        return this.myProfile.getInspectionTool(shortName, element2);
    }

    @NotNull
    public InspectionProfile getInspectionProfile() {
        return this.myProfile;
    }
}

