/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.ex;

import com.intellij.codeInspection.ex.InspectionElementsMerger;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.WriteExternalException;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;

public abstract class InspectionElementsMergerBase
extends InspectionElementsMerger {
    protected Element writeOldSettings(@NotNull String sourceToolName) throws WriteExternalException {
        Element sourceElement = new Element("inspection_tool");
        sourceElement.setAttribute("class", sourceToolName);
        sourceElement.setAttribute("enabled", String.valueOf(this.isEnabledByDefault(sourceToolName)));
        sourceElement.setAttribute("level", this.getDefaultSeverityLevel(sourceToolName));
        sourceElement.setAttribute("enabled_by_default", String.valueOf(this.isEnabledByDefault(sourceToolName)));
        return sourceElement;
    }

    private String getDefaultSeverityLevel(@NotNull String sourceToolName) {
        return HighlightSeverity.WARNING.getName();
    }

    protected boolean isEnabledByDefault(@NotNull String sourceToolName) {
        return true;
    }

    @NotNull
    static String getMergedMarkerName(@NotNull String toolName) {
        return toolName + "Merged";
    }

    boolean markSettingsMerged(@NotNull Map<String, Element> inspectionsSettings) {
        Element merge = this.merge(inspectionsSettings, true);
        if (merge != null) {
            Element defaultElement = this.merge(Collections.emptyMap(), true);
            return !JDOMUtil.areElementsEqual((Element)merge, (Element)defaultElement);
        }
        return false;
    }

    protected boolean areSettingsMerged(@NotNull Map<String, Element> inspectionsSettings, @NotNull Element inspectionElement) {
        Element merge = this.merge(inspectionsSettings, true);
        return merge != null && JDOMUtil.areElementsEqual((Element)merge, (Element)inspectionElement);
    }

    protected Element merge(@NotNull Map<String, Element> inspectionElements) {
        return this.merge(inspectionElements, false);
    }

    protected Element merge(@NotNull Map<String, Element> inspectionElements, boolean includeDefaults) {
        LinkedHashMap<String, Element> scopes = new LinkedHashMap<String, Element>();
        LinkedHashMap<String, Set<String>> mentionedTools = new LinkedHashMap<String, Set<String>>();
        boolean enabled = false;
        String level = null;
        Element toolElement = new Element("inspection_tool");
        for (String sourceToolName : this.getSourceToolNames()) {
            Element sourceElement = this.getSourceElement(inspectionElements, sourceToolName);
            if (sourceElement == null) {
                if (includeDefaults) {
                    try {
                        sourceElement = this.writeOldSettings(sourceToolName);
                    }
                    catch (WriteExternalException writeExternalException) {}
                } else {
                    enabled |= this.isEnabledByDefault(sourceToolName);
                    if (level == null) {
                        level = this.getDefaultSeverityLevel(sourceToolName);
                    }
                }
            }
            if (sourceElement == null) continue;
            this.collectContent(sourceToolName, sourceElement, toolElement, scopes, mentionedTools);
            enabled |= Boolean.parseBoolean(sourceElement.getAttributeValue("enabled"));
            if (level != null) continue;
            level = InspectionElementsMergerBase.getLevel(sourceElement);
        }
        if (this.writeMergedContent(toolElement)) {
            toolElement.setAttribute("class", this.getMergedToolName());
            toolElement.setAttribute("enabled", String.valueOf(enabled));
            if (level != null) {
                toolElement.setAttribute("level", level);
            }
            toolElement.setAttribute("enabled_by_default", String.valueOf(enabled));
            for (String scopeName : scopes.keySet()) {
                Element scopeEl = scopes.get(scopeName);
                Set<String> toolsWithScope = mentionedTools.get(scopeName);
                for (String sourceToolName : this.getSourceToolNames()) {
                    if (toolsWithScope.contains(sourceToolName)) continue;
                    this.copyDefaultSettings(scopeEl, inspectionElements, sourceToolName);
                }
                toolElement.addContent(scopeEl);
            }
            return toolElement;
        }
        return null;
    }

    protected boolean writeMergedContent(@NotNull Element toolElement) {
        return !toolElement.getChildren().isEmpty();
    }

    protected Element getSourceElement(@NotNull Map<String, Element> inspectionElements, @NotNull String sourceToolName) {
        return inspectionElements.get(sourceToolName);
    }

    private void copyDefaultSettings(@NotNull Element targetElement, @NotNull Map<String, Element> inspectionElements, @NotNull String sourceToolName) {
        Element oldElement = this.getSourceElement(inspectionElements, sourceToolName);
        if (oldElement != null) {
            Element defaultElement = this.transformElement(sourceToolName, oldElement, targetElement);
            oldElement.getChildren().stream().filter(child2 -> !"scope".equals(child2.getName())).forEach(child2 -> defaultElement.addContent(child2.clone()));
        }
    }

    private static String getLevel(Element element2) {
        return element2 != null ? element2.getAttributeValue("level") : HighlightSeverity.WARNING.getName();
    }

    private void collectContent(@NotNull String sourceToolName, @NotNull Element sourceElement, @NotNull Element toolElement, @NotNull Map<String, Element> scopes, @NotNull Map<String, Set<String>> mentionedTools) {
        Element wrapElement = this.transformElement(sourceToolName, sourceElement, toolElement);
        for (Element element2 : sourceElement.getChildren()) {
            if ("scope".equals(element2.getName())) {
                String scopeName = element2.getAttributeValue("name");
                if (scopeName == null) continue;
                mentionedTools.computeIfAbsent(scopeName, s -> new HashSet()).add(sourceToolName);
                this.copyScopeContent(sourceToolName, element2, scopes.computeIfAbsent(scopeName, key -> {
                    Element scopeElement = element2.clone();
                    scopeElement.removeContent();
                    return scopeElement;
                }));
                continue;
            }
            wrapElement.addContent(element2.clone());
        }
    }

    private void copyScopeContent(@NotNull String sourceToolName, @NotNull Element element2, @NotNull Element scopeElement) {
        Element wrappedScope = this.transformElement(sourceToolName, element2, scopeElement);
        for (Element scopeEl : element2.getChildren()) {
            wrappedScope.addContent(scopeEl.clone());
        }
    }

    protected Element transformElement(@NotNull String sourceToolName, @NotNull Element sourceElement, @NotNull Element toolElement) {
        return toolElement;
    }
}

