/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.ex;

import com.intellij.codeInspection.GlobalInspectionContext;
import com.intellij.codeInspection.lang.InspectionExtensionsFactory;
import com.intellij.codeInspection.reference.RefElement;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLanguageInjectionHost;
import org.jetbrains.annotations.NotNull;

public final class GlobalInspectionContextUtil {
    public static RefElement retrieveRefElement(@NotNull PsiElement element2, @NotNull GlobalInspectionContext globalContext) {
        PsiLanguageInjectionHost context;
        PsiFile elementFile = element2.getContainingFile();
        RefElement refElement = globalContext.getRefManager().getReference((PsiElement)elementFile);
        if (refElement == null && (context = InjectedLanguageManager.getInstance((Project)elementFile.getProject()).getInjectionHost((PsiElement)elementFile)) != null) {
            refElement = globalContext.getRefManager().getReference((PsiElement)context.getContainingFile());
        }
        return refElement;
    }

    @Deprecated
    public static boolean canRunInspections(@NotNull Project project, boolean online) {
        return GlobalInspectionContextUtil.canRunInspections(project, online, () -> {});
    }

    public static boolean canRunInspections(@NotNull Project project, boolean online, @NotNull Runnable rerunAction) {
        if (InspectionExtensionsFactory.EP_NAME.getExtensionList().size() == 0) {
            return true;
        }
        for (InspectionExtensionsFactory factory2 : InspectionExtensionsFactory.EP_NAME.getExtensionList()) {
            if (!factory2.isProjectConfiguredToRunInspections(project, online, rerunAction)) continue;
            return true;
        }
        return false;
    }
}

