/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.ex;

import com.intellij.codeInspection.ExternalAnnotatorInspectionVisitor;
import com.intellij.codeInspection.GlobalInspectionContext;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ex.PairedUnfairLocalInspectionTool;
import com.intellij.lang.ExternalLanguageAnnotators;
import com.intellij.lang.Language;
import com.intellij.lang.annotation.ExternalAnnotator;
import com.intellij.openapi.application.ReadAction;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiFile;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public interface ExternalAnnotatorBatchInspection
extends PairedUnfairLocalInspectionTool {
    @NotNull
    public String getShortName();

    @Override
    @NotNull
    default public String getInspectionForBatchShortName() {
        return this.getShortName();
    }

    default public ProblemDescriptor @NotNull [] checkFile(@NotNull PsiFile file2, @NotNull GlobalInspectionContext context, @NotNull InspectionManager manager) {
        String shortName = this.getShortName();
        FileViewProvider viewProvider = file2.getViewProvider();
        Set relevantLanguages = (Set)ReadAction.compute(() -> viewProvider.getLanguages());
        for (Language language : relevantLanguages) {
            PsiFile psiRoot = (PsiFile)ReadAction.compute(() -> viewProvider.getPsi(language));
            List externalAnnotators = ExternalLanguageAnnotators.allForFile((Language)language, (PsiFile)psiRoot);
            for (ExternalAnnotator annotator : externalAnnotators) {
                if (!shortName.equals(annotator.getPairedBatchInspectionShortName())) continue;
                return ExternalAnnotatorInspectionVisitor.checkFileWithExternalAnnotator(file2, manager, false, annotator);
            }
        }
        return ProblemDescriptor.EMPTY_ARRAY;
    }
}

