/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.ex;

import com.intellij.analysis.AnalysisBundle;
import com.intellij.codeInspection.CommonProblemDescriptor;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemDescriptorUtil;
import com.intellij.codeInspection.QuickFix;
import com.intellij.codeInspection.ex.HTMLComposerImpl;
import com.intellij.codeInspection.ex.QuickFixAction;
import com.intellij.codeInspection.reference.RefElement;
import com.intellij.codeInspection.reference.RefEntity;
import com.intellij.codeInspection.ui.InspectionToolPresentation;
import com.intellij.injected.editor.VirtualFileWindow;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.text.CharArrayUtil;
import com.intellij.xml.util.XmlStringUtil;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;

public class DescriptorComposer
extends HTMLComposerImpl {
    private static final Logger LOG = Logger.getInstance(DescriptorComposer.class);
    private final InspectionToolPresentation myTool;

    public DescriptorComposer(@NotNull InspectionToolPresentation tool) {
        this.myTool = tool;
    }

    @Override
    public void compose(@NotNull StringBuilder buf, RefEntity refEntity) {
        this.genPageHeader(buf, refEntity);
        if (this.myTool.getDescriptions(refEntity) != null) {
            DescriptorComposer.appendHeading((StringBuilder)buf, (String)AnalysisBundle.message((String)"inspection.problem.synopsis", (Object[])new Object[0]));
            buf.append("<div class=\"problem-description\">");
            CommonProblemDescriptor[] descriptions = this.myTool.getDescriptions(refEntity);
            LOG.assertTrue(descriptions != null);
            this.startList(buf);
            for (int i2 = 0; i2 < descriptions.length; ++i2) {
                CommonProblemDescriptor description = descriptions[i2];
                this.startListItem(buf);
                this.composeDescription(description, i2, buf, refEntity);
                DescriptorComposer.doneListItem(buf);
            }
            this.doneList(buf);
            buf.append("</div>");
            this.appendResolution(buf, refEntity, DescriptorComposer.quickFixTexts(refEntity, this.myTool));
        } else {
            this.appendNoProblems(buf);
        }
    }

    public static String @NotNull [] quickFixTexts(RefEntity where, @NotNull InspectionToolPresentation toolPresentation) {
        QuickFixAction[] quickFixes = toolPresentation.getQuickFixes(where);
        ArrayList<String> texts = new ArrayList<String>();
        for (QuickFixAction quickFix : quickFixes) {
            String text = quickFix.getText();
            if (text == null) continue;
            texts.add(DescriptorComposer.escapeQuickFixText(text));
        }
        return ArrayUtilRt.toStringArray(texts);
    }

    private static String escapeQuickFixText(@NotNull String text) {
        return XmlStringUtil.isWrappedInHtml((String)text) ? XmlStringUtil.stripHtml((String)text) : StringUtil.escapeXmlEntities((String)text);
    }

    protected void composeAdditionalDescription(@NotNull StringBuilder buf, @NotNull RefEntity refEntity) {
    }

    @Override
    public void compose(@NotNull StringBuilder buf, RefEntity refElement, CommonProblemDescriptor descriptor2) {
        CommonProblemDescriptor[] descriptions = this.myTool.getDescriptions(refElement);
        int problemIdx = 0;
        if (descriptions != null) {
            problemIdx = -1;
            for (int i2 = 0; i2 < descriptions.length; ++i2) {
                CommonProblemDescriptor description = descriptions[i2];
                if (description != descriptor2) continue;
                problemIdx = i2;
                break;
            }
            if (problemIdx == -1) {
                return;
            }
        }
        this.genPageHeader(buf, refElement);
        DescriptorComposer.appendHeading((StringBuilder)buf, (String)AnalysisBundle.message((String)"inspection.problem.synopsis", (Object[])new Object[0]));
        buf.append("<br>");
        DescriptorComposer.appendAfterHeaderIndention((StringBuilder)buf);
        this.composeDescription(descriptor2, problemIdx, buf, refElement);
        if (refElement instanceof RefElement && !refElement.isValid()) {
            return;
        }
        QuickFix[] fixes = descriptor2.getFixes();
        if (fixes != null && fixes.length > 0) {
            buf.append("<br><br>");
            DescriptorComposer.appendHeading((StringBuilder)buf, (String)AnalysisBundle.message((String)"inspection.problem.resolution", (Object[])new Object[0]));
            buf.append("<br>");
            DescriptorComposer.appendAfterHeaderIndention((StringBuilder)buf);
            int idx = 0;
            for (QuickFix fix : fixes) {
                buf.append("<a HREF=\"file://bred.txt#invokelocal:" + idx++);
                buf.append("\">");
                buf.append(DescriptorComposer.escapeQuickFixText(fix.getName()));
                buf.append("</a>");
                buf.append("<br>");
                DescriptorComposer.appendAfterHeaderIndention((StringBuilder)buf);
            }
        }
    }

    protected void composeDescription(@NotNull CommonProblemDescriptor description, int i2, @NotNull StringBuilder buf, @NotNull RefEntity refElement) {
        Document doc;
        PsiElement expression = description instanceof ProblemDescriptor ? ((ProblemDescriptor)description).getPsiElement() : null;
        StringBuilder anchor2 = new StringBuilder();
        VirtualFile vFile = null;
        if (expression != null) {
            vFile = expression.getContainingFile().getVirtualFile();
            if (vFile instanceof VirtualFileWindow) {
                vFile = ((VirtualFileWindow)vFile).getDelegate();
            }
            anchor2.append("<a HREF=\"");
            anchor2.append(DescriptorComposer.appendURL(vFile, "descr:" + i2));
            anchor2.append("\">");
            anchor2.append(ProblemDescriptorUtil.extractHighlightedText(description, expression).replaceAll("\\$", "\\\\\\$"));
            anchor2.append("</a>");
        } else {
            anchor2.append("<font style=\"font-weight:bold; color:#FF0000\";>");
            anchor2.append(AnalysisBundle.message((String)"inspection.export.results.invalidated.item", (Object[])new Object[0]));
            anchor2.append("</font>");
        }
        String descriptionTemplate = description.getDescriptionTemplate();
        if (XmlStringUtil.isWrappedInHtml((String)descriptionTemplate)) {
            descriptionTemplate = XmlStringUtil.stripHtml((String)descriptionTemplate);
        } else {
            descriptionTemplate = StringUtil.replace((String)descriptionTemplate, (String)"<code>", (String)"'");
            descriptionTemplate = StringUtil.replace((String)descriptionTemplate, (String)"</code>", (String)"'");
            descriptionTemplate = XmlStringUtil.escapeString((String)descriptionTemplate);
        }
        String reference2 = "#ref";
        String res2 = descriptionTemplate.replaceAll("#ref", anchor2.toString());
        int lineNumber = description instanceof ProblemDescriptor ? ((ProblemDescriptor)description).getLineNumber() : -1;
        StringBuilder lineAnchor = new StringBuilder();
        if (expression != null && lineNumber >= 0 && (doc = FileDocumentManager.getInstance().getDocument(vFile)) != null && lineNumber < doc.getLineCount()) {
            lineNumber = Math.min(lineNumber, doc.getLineCount() - 1);
            lineAnchor.append(AnalysisBundle.message((String)"inspection.export.results.at.line", (Object[])new Object[0])).append(" ");
            lineAnchor.append("<a HREF=\"");
            int offset = doc.getLineStartOffset(lineNumber);
            offset = CharArrayUtil.shiftForward((CharSequence)doc.getCharsSequence(), (int)offset, (String)" \t");
            lineAnchor.append(DescriptorComposer.appendURL(vFile, String.valueOf(offset)));
            lineAnchor.append("\">");
            lineAnchor.append(lineNumber + 1);
            lineAnchor.append("</a>");
            String location = "#loc";
            if (!res2.contains("#loc")) {
                res2 = res2 + " (#loc)";
            }
            res2 = res2.replaceAll("#loc", lineAnchor.toString());
        }
        buf.append(res2.replace("#end", "").replace("#treeend", ""));
        buf.append("<br>").append("<br>");
        this.composeAdditionalDescription(buf, refElement);
    }

    private static String appendURL(VirtualFile vFile, String anchor2) {
        return vFile.getUrl() + "#" + anchor2;
    }
}

