/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.actions;

import com.intellij.CommonBundle;
import com.intellij.analysis.AnalysisScope;
import com.intellij.analysis.AnalysisUIOptions;
import com.intellij.analysis.BaseAnalysisActionDialog;
import com.intellij.analysis.dialog.ModelScopeItem;
import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInspection.CleanupLocalInspectionTool;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.actions.FileFilterPanel;
import com.intellij.codeInspection.actions.GotoInspectionModel;
import com.intellij.codeInspection.actions.InspectionElement;
import com.intellij.codeInspection.actions.RunInspectionIntention;
import com.intellij.codeInspection.ex.InspectionManagerEx;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.actions.GotoActionBase;
import com.intellij.ide.util.gotoByName.ChooseByNameFilter;
import com.intellij.ide.util.gotoByName.ChooseByNamePopup;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.TitledSeparator;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RunInspectionAction
extends GotoActionBase
implements DataProvider {
    private static final Logger LOGGER = Logger.getInstance(RunInspectionAction.class);
    private final String myPredefinedText;

    public RunInspectionAction() {
        this(null);
    }

    public RunInspectionAction(String predefinedText) {
        this.myPredefinedText = predefinedText;
        this.getTemplatePresentation().setText(IdeBundle.messagePointer((String)"goto.inspection.action.text", (Object[])new Object[0]));
    }

    @Override
    protected void gotoActionPerformed(@NotNull AnActionEvent e) {
        final Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        if (project == null) {
            return;
        }
        PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
        final PsiElement psiElement = (PsiElement)e.getData(CommonDataKeys.PSI_ELEMENT);
        final PsiFile psiFile = (PsiFile)e.getData(CommonDataKeys.PSI_FILE);
        final VirtualFile[] virtualFiles = (VirtualFile[])ObjectUtils.notNull((Object)e.getData(CommonDataKeys.VIRTUAL_FILE_ARRAY), (Object)VirtualFile.EMPTY_ARRAY);
        FeatureUsageTracker.getInstance().triggerFeatureUsed("navigation.goto.inspection");
        GotoInspectionModel model = new GotoInspectionModel(project);
        this.showNavigationPopup(e, model, new GotoActionBase.GotoActionCallback<Object>(){

            @Override
            protected ChooseByNameFilter<Object> createFilter(@NotNull ChooseByNamePopup popup2) {
                popup2.setSearchInAnyPlace(true);
                return super.createFilter(popup2);
            }

            @Override
            public void elementChosen(ChooseByNamePopup popup2, Object element2) {
                ApplicationManager.getApplication().invokeLater(() -> RunInspectionAction.runInspection(project, ((InspectionElement)element2).getToolWrapper().getShortName(), virtualFiles, psiElement, psiFile));
            }
        }, false);
    }

    @Nullable
    public Object getData(@NotNull String dataId) {
        return PlatformDataKeys.PREDEFINED_TEXT.is(dataId) ? this.myPredefinedText : null;
    }

    public static void runInspection(@NotNull Project project, @NotNull String shortName, @Nullable VirtualFile virtualFile, @Nullable PsiElement psiElement, @Nullable PsiFile psiFile) {
        VirtualFile[] virtualFileArray;
        if (virtualFile == null) {
            virtualFileArray = VirtualFile.EMPTY_ARRAY;
        } else {
            VirtualFile[] virtualFileArray2 = new VirtualFile[1];
            virtualFileArray = virtualFileArray2;
            virtualFileArray2[0] = virtualFile;
        }
        RunInspectionAction.runInspection(project, shortName, virtualFileArray, psiElement, psiFile);
    }

    public static void runInspection(final @NotNull Project project, @NotNull String shortName, VirtualFile @NotNull [] virtualFiles, @Nullable PsiElement psiElement, @Nullable PsiFile psiFile) {
        PsiElement element2 = psiFile == null ? psiElement : psiFile;
        InspectionProfileImpl currentProfile = InspectionProjectProfileManager.getInstance(project).getCurrentProfile();
        final InspectionToolWrapper toolWrapper = element2 != null ? currentProfile.getInspectionTool(shortName, element2) : currentProfile.getInspectionTool(shortName, project);
        LOGGER.assertTrue(toolWrapper != null, (Object)("Missed inspection: " + shortName));
        final InspectionManagerEx managerEx = (InspectionManagerEx)InspectionManager.getInstance((Project)project);
        Module module = RunInspectionAction.findModuleForFiles(project, virtualFiles);
        AnalysisScope analysisScope = null;
        if (psiFile != null) {
            analysisScope = new AnalysisScope(psiFile);
        } else {
            PsiDirectory psiDirectory;
            if (virtualFiles.length == 1 && virtualFiles[0].isDirectory() && (psiDirectory = PsiManager.getInstance((Project)project).findDirectory(virtualFiles[0])) != null) {
                analysisScope = new AnalysisScope(psiDirectory);
            }
            if (analysisScope == null && virtualFiles.length != 0) {
                analysisScope = new AnalysisScope(project, (Collection)ContainerUtil.newHashSet((Object[])virtualFiles));
            }
            if (analysisScope == null) {
                analysisScope = new AnalysisScope(project);
            }
        }
        AnalysisUIOptions options2 = AnalysisUIOptions.getInstance(project);
        final FileFilterPanel fileFilterPanel = new FileFilterPanel();
        fileFilterPanel.init(options2);
        final AnalysisScope initialAnalysisScope = analysisScope;
        List<ModelScopeItem> items = BaseAnalysisActionDialog.standardItems(project, analysisScope, module, psiElement);
        BaseAnalysisActionDialog dialog2 = new BaseAnalysisActionDialog(IdeBundle.message((String)"goto.inspection.action.dialog.title", (Object[])new Object[]{toolWrapper.getDisplayName()}), CodeInsightBundle.message((String)"analysis.scope.title", (Object[])new Object[]{InspectionsBundle.message((String)"inspection.action.noun", (Object[])new Object[0])}), project, items, options2, true){
            private InspectionToolWrapper<?, ?> myUpdatedSettingsToolWrapper;

            @Override
            @Nullable
            protected JComponent getAdditionalActionSettings(Project project2) {
                JPanel fileFilter2 = fileFilterPanel.getPanel();
                if (toolWrapper.getTool().createOptionsPanel() != null) {
                    JPanel additionPanel = new JPanel();
                    additionPanel.setLayout(new GridBagLayout());
                    additionPanel.add((Component)fileFilter2, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 11, 1, (Insets)JBUI.emptyInsets(), 0, 0));
                    this.myUpdatedSettingsToolWrapper = RunInspectionAction.copyToolWithSettings(toolWrapper);
                    additionPanel.add((Component)new TitledSeparator(IdeBundle.message((String)"goto.inspection.action.choose.inherit.settings.from", (Object[])new Object[0])), new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 11, 1, (Insets)JBUI.emptyInsets(), 0, 0));
                    JComponent optionsPanel = this.myUpdatedSettingsToolWrapper.getTool().createOptionsPanel();
                    LOGGER.assertTrue(optionsPanel != null);
                    GridBagConstraints constraints2 = new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 10, 1, (Insets)JBUI.emptyInsets(), 0, 0);
                    if (UIUtil.hasScrollPane((Component)optionsPanel)) {
                        additionPanel.add((Component)optionsPanel, constraints2);
                    } else {
                        additionPanel.add((Component)ScrollPaneFactory.createScrollPane((Component)optionsPanel, (int)0), constraints2);
                    }
                    return additionPanel;
                }
                return fileFilter2;
            }

            @Override
            @NotNull
            public AnalysisScope getScope(@NotNull AnalysisScope defaultScope) {
                AnalysisScope scope = super.getScope(defaultScope);
                GlobalSearchScope filterScope = fileFilterPanel.getSearchScope();
                if (filterScope == null) {
                    return scope;
                }
                scope.setFilter(filterScope);
                return scope;
            }

            private AnalysisScope getScope() {
                return this.getScope(initialAnalysisScope);
            }

            private InspectionToolWrapper<?, ?> getToolWrapper() {
                return this.myUpdatedSettingsToolWrapper == null ? toolWrapper : this.myUpdatedSettingsToolWrapper;
            }

            protected Action @NotNull [] createActions() {
                ArrayList<Action> actions = new ArrayList<Action>();
                boolean hasFixAll = toolWrapper.getTool() instanceof CleanupLocalInspectionTool;
                actions.add(new AbstractAction(hasFixAll ? CodeInsightBundle.message((String)"action.analyze.verb", (Object[])new Object[0]) : CommonBundle.getOkButtonText()){
                    {
                        super(x0);
                        this.putValue("DefaultAction", Boolean.TRUE);
                    }

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        AnalysisScope scope = this.getScope();
                        InspectionToolWrapper wrapper2 = this.getToolWrapper();
                        DumbService.getInstance((Project)project).smartInvokeLater(() -> RunInspectionIntention.rerunInspection(wrapper2, managerEx, scope, null));
                        this.close(0);
                    }
                });
                if (hasFixAll) {
                    actions.add(new AbstractAction(IdeBundle.message((String)"goto.inspection.action.fix.all", (Object[])new Object[0])){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            InspectionToolWrapper wrapper2 = this.getToolWrapper();
                            InspectionProfileImpl cleanupToolProfile = RunInspectionIntention.createProfile(wrapper2, managerEx, null);
                            managerEx.createNewGlobalContext().codeCleanup(this.getScope(), cleanupToolProfile, "Cleanup by " + wrapper2.getDisplayName(), null, false);
                            this.close(0);
                        }
                    });
                }
                actions.add(this.getCancelAction());
                if (SystemInfo.isMac) {
                    Collections.reverse(actions);
                }
                return actions.toArray(new Action[0]);
            }
        };
        dialog2.showAndGet();
    }

    @Nullable
    private static Module findModuleForFiles(@NotNull Project project, VirtualFile @NotNull [] files2) {
        Set modules2 = ContainerUtil.map2Set((Object[])files2, f -> ModuleUtilCore.findModuleForFile((VirtualFile)f, (Project)project));
        return (Module)ContainerUtil.getFirstItem((Collection)modules2);
    }

    private static InspectionToolWrapper<?, ?> copyToolWithSettings(@NotNull InspectionToolWrapper tool) {
        Element options2 = new Element("copy");
        tool.getTool().writeSettings(options2);
        InspectionToolWrapper copiedTool = tool.createCopy();
        copiedTool.getTool().readSettings(options2);
        return copiedTool;
    }
}

