/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.analysis.AnalysisBundle;
import com.intellij.codeInspection.CommonProblemDescriptor;
import com.intellij.codeInspection.ContainerBasedSuppressQuickFix;
import com.intellij.codeInspection.InjectionAwareSuppressQuickFix;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.SuppressIntentionAction;
import com.intellij.codeInspection.SuppressQuickFix;
import com.intellij.codeInspection.util.IntentionName;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ThreeState;
import com.intellij.util.containers.ContainerUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SuppressIntentionActionFromFix
extends SuppressIntentionAction {
    private final SuppressQuickFix myFix;

    private SuppressIntentionActionFromFix(@NotNull SuppressQuickFix fix) {
        this.myFix = fix;
    }

    public boolean startInWriteAction() {
        return this.myFix.startInWriteAction();
    }

    @Nullable
    public PsiElement getElementToMakeWritable(@NotNull PsiFile currentFile) {
        return this.myFix.getElementToMakeWritable(currentFile);
    }

    @NotNull
    public static SuppressIntentionAction convertBatchToSuppressIntentionAction(@NotNull SuppressQuickFix fix) {
        return new SuppressIntentionActionFromFix(fix);
    }

    public static SuppressIntentionAction @NotNull [] convertBatchToSuppressIntentionActions(SuppressQuickFix @NotNull [] actions) {
        return (SuppressIntentionAction[])ContainerUtil.map2Array((Object[])actions, SuppressIntentionAction.class, SuppressIntentionActionFromFix::convertBatchToSuppressIntentionAction);
    }

    public void invoke(@NotNull Project project, Editor editor, @NotNull PsiElement element2) throws IncorrectOperationException {
        PsiElement container2 = this.getContainer(element2);
        boolean caretWasBeforeStatement = editor != null && container2 != null && editor.getCaretModel().getOffset() == container2.getTextRange().getStartOffset();
        InspectionManager inspectionManager = InspectionManager.getInstance((Project)project);
        ProblemDescriptor descriptor2 = inspectionManager.createProblemDescriptor(element2, element2, "", ProblemHighlightType.GENERIC_ERROR_OR_WARNING, false, new LocalQuickFix[0]);
        this.myFix.applyFix(project, (CommonProblemDescriptor)descriptor2);
        if (caretWasBeforeStatement) {
            editor.getCaretModel().moveToOffset(container2.getTextRange().getStartOffset());
        }
    }

    public ThreeState isShouldBeAppliedToInjectionHost() {
        return this.myFix instanceof InjectionAwareSuppressQuickFix ? ((InjectionAwareSuppressQuickFix)this.myFix).isShouldBeAppliedToInjectionHost() : ThreeState.UNSURE;
    }

    public PsiElement getContainer(PsiElement element2) {
        return this.myFix instanceof ContainerBasedSuppressQuickFix ? ((ContainerBasedSuppressQuickFix)this.myFix).getContainer(element2) : null;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, @NotNull PsiElement element2) {
        return this.myFix.isAvailable(project, element2);
    }

    @NotNull
    public @IntentionName String getText() {
        return this.isShouldBeAppliedToInjectionHost() == ThreeState.NO ? AnalysisBundle.message((String)"intention.name.in.injection", (Object[])new Object[]{this.myFix.getName()}) : this.myFix.getName();
    }

    @NotNull
    public String getFamilyName() {
        return this.myFix.getFamilyName();
    }

    public boolean isSuppressAll() {
        return this.myFix.isSuppressAll();
    }
}

