/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.stream.JsonWriter;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.PathMacroManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.SourceFolder;
import com.intellij.openapi.vfs.CharsetToolkit;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.model.java.JavaModuleSourceRootTypes;
import org.jetbrains.jps.model.java.JavaResourceRootType;
import org.jetbrains.jps.model.java.JavaSourceRootProperties;
import org.jetbrains.jps.model.java.JavaSourceRootType;
import org.jetbrains.jps.model.module.JpsModuleSourceRootType;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=2, d1={"\u0000B\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\u001a \u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u001a \u0010\b\u001a\u00020\u00012\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u001a \u0010\u000b\u001a\u00020\u00012\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u001a\u0018\u0010\u000e\u001a\u00020\u00012\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\u001a\u0016\u0010\u000e\u001a\u00020\u00012\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u000f\u001a\u00020\u0010\u001a\f\u0010\u0013\u001a\u00020\u0014*\u00020\u0015H\u0002\u00a8\u0006\u0016"}, d2={"writeContentEntry", "", "contentEntry", "Lcom/intellij/openapi/roots/ContentEntry;", "writer", "Lcom/google/gson/stream/JsonWriter;", "macroManager", "Lcom/intellij/openapi/components/PathMacroManager;", "writeModuleDescription", "module", "Lcom/intellij/openapi/module/Module;", "writeOrderEntry", "orderEntry", "Lcom/intellij/openapi/roots/OrderEntry;", "writeProjectDescription", "project", "Lcom/intellij/openapi/project/Project;", "path", "Ljava/nio/file/Path;", "type", "", "Lcom/intellij/openapi/roots/SourceFolder;", "intellij.platform.analysis.impl"})
public final class ProjectDescriptionUtilKt {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void writeProjectDescription(@NotNull Path path, @NotNull Project project) {
        Gson gson2 = new GsonBuilder().setPrettyPrinting().create();
        BufferedWriter writer = Files.newBufferedWriter(path, CharsetToolkit.UTF8_CHARSET, new OpenOption[0]);
        Closeable closeable = writer;
        boolean bl = false;
        boolean bl2 = false;
        Throwable throwable = null;
        try {
            BufferedWriter it = (BufferedWriter)closeable;
            boolean bl3 = false;
            JsonWriter jsonWriter = gson2.newJsonWriter((Writer)writer);
            ProjectDescriptionUtilKt.writeProjectDescription(project, jsonWriter);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    private static final void writeProjectDescription(Project project, JsonWriter writer) {
        Module[] modules2 = ModuleManager.getInstance((Project)project).getModules();
        PathMacroManager macroManager = PathMacroManager.getInstance((ComponentManager)project);
        writer.beginObject();
        writer.name("modules");
        writer.beginArray();
        for (Module module : modules2) {
            ProjectDescriptionUtilKt.writeModuleDescription(module, writer, macroManager);
        }
        writer.endArray();
        writer.endObject();
    }

    private static final void writeModuleDescription(Module module, JsonWriter writer, PathMacroManager macroManager) {
        ModuleRootManager rootManager = ModuleRootManager.getInstance((Module)module);
        writer.beginObject();
        writer.name("Name").value(module.getName());
        writer.name("ContentEntries").beginArray();
        for (ContentEntry contentEntry : rootManager.getContentEntries()) {
            ProjectDescriptionUtilKt.writeContentEntry(contentEntry, writer, macroManager);
        }
        writer.endArray();
        writer.name("OrderEntries").beginArray();
        for (ContentEntry contentEntry : rootManager.getOrderEntries()) {
            ProjectDescriptionUtilKt.writeOrderEntry((OrderEntry)contentEntry, writer, macroManager);
        }
        writer.endArray();
        writer.endObject();
    }

    private static final void writeContentEntry(ContentEntry contentEntry, JsonWriter writer, PathMacroManager macroManager) {
        writer.beginObject();
        writer.name("Path").value(macroManager.collapsePath(contentEntry.getUrl()));
        writer.name("SourceFolders").beginArray();
        for (SourceFolder sourceFolder : contentEntry.getSourceFolders()) {
            writer.beginObject();
            writer.name("Path").value(macroManager.collapsePath(sourceFolder.getUrl()));
            writer.name("Type").value(ProjectDescriptionUtilKt.type(sourceFolder));
            writer.endObject();
        }
        for (SourceFolder sourceFolder : contentEntry.getExcludeFolders()) {
            writer.beginObject();
            writer.name("Path").value(macroManager.collapsePath(sourceFolder.getUrl()));
            writer.name("Type").value("Exclude");
            writer.endObject();
        }
        writer.endArray();
        writer.endObject();
    }

    private static final void writeOrderEntry(OrderEntry orderEntry, JsonWriter writer, PathMacroManager macroManager) {
        writer.beginObject();
        writer.name("Name").value(orderEntry.getPresentableName());
        writer.name("Roots").beginArray();
        for (String root : orderEntry.getUrls(OrderRootType.CLASSES)) {
            writer.beginObject();
            writer.name("Path").value(macroManager.collapsePath(root));
            writer.endObject();
        }
        writer.endArray();
        writer.endObject();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final String type(SourceFolder $this$type) {
        JpsModuleSourceRootType jpsModuleSourceRootType = $this$type.getRootType();
        if (Intrinsics.areEqual((Object)jpsModuleSourceRootType, (Object)JavaResourceRootType.RESOURCE)) {
            return "Resource";
        }
        if (Intrinsics.areEqual((Object)jpsModuleSourceRootType, (Object)JavaResourceRootType.TEST_RESOURCE)) {
            return "TestResource";
        }
        if (Intrinsics.areEqual((Object)jpsModuleSourceRootType, (Object)JavaSourceRootType.TEST_SOURCE)) {
            return "TestSource";
        }
        if (!Intrinsics.areEqual((Object)jpsModuleSourceRootType, (Object)JavaSourceRootType.SOURCE)) return "Source";
        JavaSourceRootProperties javaSourceRootProperties = (JavaSourceRootProperties)$this$type.getJpsElement().getProperties(JavaModuleSourceRootTypes.SOURCES);
        if (javaSourceRootProperties == null) return "Source";
        if (!javaSourceRootProperties.isForGeneratedSources()) return "Source";
        return "GeneratedSource";
    }
}

