/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.application.options.CodeStyle;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorSettings;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import org.jetbrains.annotations.NotNull;

public class ProblematicWhitespaceInspection
extends LocalInspectionTool {
    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        return new ProblematicWhitespaceVisitor(holder, isOnTheFly);
    }

    private class ProblematicWhitespaceVisitor
    extends PsiElementVisitor {
        private final ProblemsHolder myHolder;
        private final boolean myIsOnTheFly;

        ProblematicWhitespaceVisitor(ProblemsHolder holder, boolean isOnTheFly) {
            this.myHolder = holder;
            this.myIsOnTheFly = isOnTheFly;
        }

        public void visitFile(@NotNull PsiFile file2) {
            super.visitFile(file2);
            FileType fileType = file2.getFileType();
            if (!(fileType instanceof LanguageFileType)) {
                return;
            }
            CodeStyleSettings settings = CodeStyle.getSettings((PsiFile)file2);
            CommonCodeStyleSettings.IndentOptions indentOptions = settings.getIndentOptions(fileType);
            boolean useTabs = indentOptions.USE_TAB_CHARACTER;
            boolean smartTabs = indentOptions.SMART_TABS;
            Document document = PsiDocumentManager.getInstance((Project)file2.getProject()).getDocument(file2);
            if (document == null) {
                return;
            }
            int lineCount = document.getLineCount();
            int previousLineIndent = 0;
            block0: for (int i2 = 0; i2 < lineCount; ++i2) {
                int startOffset = document.getLineStartOffset(i2);
                int endOffset = document.getLineEndOffset(i2);
                String line = document.getText(new TextRange(startOffset, endOffset));
                boolean spaceSeen = false;
                int length = line.length();
                for (int j = 0; j < length; ++j) {
                    char c = line.charAt(j);
                    if (c == '\t') {
                        if (!(useTabs ? smartTabs && spaceSeen && this.registerError(file2, startOffset, true) : this.registerError(file2, startOffset, false))) continue;
                        return;
                    }
                    if (c == ' ') {
                        if (useTabs) {
                            if (!smartTabs) {
                                if (this.registerError(file2, startOffset, true)) {
                                    return;
                                }
                            } else if (!spaceSeen) {
                                if (j < previousLineIndent && this.registerError(file2, startOffset, true)) {
                                    return;
                                }
                                previousLineIndent = j;
                            }
                        }
                        spaceSeen = true;
                        continue;
                    }
                    if (spaceSeen) continue block0;
                    previousLineIndent = j;
                    continue block0;
                }
            }
        }

        private boolean registerError(PsiFile file2, int startOffset, boolean tab) {
            String description;
            PsiElement element2 = file2.findElementAt(startOffset);
            if (element2 != null && ProblematicWhitespaceInspection.this.isSuppressedFor(element2)) {
                return false;
            }
            String string = description = tab ? InspectionsBundle.message((String)"problematic.whitespace.spaces.problem.descriptor", (Object[])new Object[]{file2.getName()}) : InspectionsBundle.message((String)"problematic.whitespace.tabs.problem.descriptor", (Object[])new Object[]{file2.getName()});
            if (this.myIsOnTheFly) {
                this.myHolder.registerProblem((PsiElement)file2, description, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[]{new ShowWhitespaceFix()});
            } else {
                this.myHolder.registerProblem((PsiElement)file2, description, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[0]);
            }
            return true;
        }
    }

    private static class ShowWhitespaceFix
    implements LocalQuickFix {
        private ShowWhitespaceFix() {
        }

        @NotNull
        public String getFamilyName() {
            return InspectionsBundle.message((String)"problematic.whitespace.show.whitespaces.quickfix", (Object[])new Object[0]);
        }

        public boolean startInWriteAction() {
            return false;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
            EditorSettings settings;
            FileEditorManager editorManager = FileEditorManager.getInstance((Project)project);
            Editor editor = editorManager.getSelectedTextEditor();
            if (editor == null) {
                return;
            }
            settings.setWhitespacesShown(!(settings = editor.getSettings()).isWhitespacesShown());
            editor.getComponent().repaint();
        }
    }
}

