/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInspection.InspectionProfile;
import com.intellij.codeInspection.InspectionToolResultExporter;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.codeInspection.ui.AggregateResultsExporter;
import com.intellij.configurationStore.JbXmlOutputter;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.JBIterable;
import com.thoughtworks.xstream.io.xml.PrettyPrintWriter;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class InspectionsResultUtil {
    @NonNls
    public static final String DESCRIPTIONS = ".descriptions";
    @NonNls
    public static final String XML_EXTENSION = ".xml";
    static final Logger LOG = Logger.getInstance(InspectionsResultUtil.class);
    @NonNls
    public static final String PROFILE = "profile";
    @NonNls
    public static final String INSPECTIONS_NODE = "inspections";
    private static final String ROOT = "root";
    public static final String AGGREGATE = "_aggregate";

    public static void describeInspections(@NonNls Path outputPath, @Nullable String name, @NotNull InspectionProfile profile) throws IOException {
        HashMap<Pair, Set> map2 = new HashMap<Pair, Set>();
        for (InspectionToolWrapper toolWrapper : profile.getInspectionTools(null)) {
            String groupName = toolWrapper.getGroupDisplayName();
            Object[] path = toolWrapper.getGroupPath();
            String groupPath = path.length == 0 ? "" : String.join((CharSequence)"/", (Iterable<? extends CharSequence>)JBIterable.of((Object[])path).take(path.length - 1));
            Set groupInspections = map2.computeIfAbsent(Pair.create((Object)groupName, (Object)groupPath), __ -> new HashSet());
            groupInspections.add(toolWrapper);
        }
        try (OutputStreamWriter fw = new OutputStreamWriter(Files.newOutputStream(outputPath, new OpenOption[0]), StandardCharsets.UTF_8);){
            PrettyPrintWriter xmlWriter = new PrettyPrintWriter((Writer)fw);
            xmlWriter.startNode(INSPECTIONS_NODE);
            if (name != null) {
                xmlWriter.addAttribute(PROFILE, name);
            }
            ArrayList<String> inspectionsWithoutDescriptions = new ArrayList<String>(1);
            for (Map.Entry entry : map2.entrySet()) {
                xmlWriter.startNode("group");
                String groupName = (String)((Pair)entry.getKey()).getFirst();
                String groupPath = (String)((Pair)entry.getKey()).getSecond();
                xmlWriter.addAttribute("name", groupName);
                xmlWriter.addAttribute("path", groupPath);
                for (InspectionToolWrapper toolWrapper : (Set)entry.getValue()) {
                    xmlWriter.startNode("inspection");
                    String shortName = toolWrapper.getShortName();
                    xmlWriter.addAttribute("shortName", shortName);
                    xmlWriter.addAttribute("defaultSeverity", toolWrapper.getDefaultLevel().getSeverity().getName());
                    xmlWriter.addAttribute("displayName", toolWrapper.getDisplayName());
                    boolean toolEnabled = profile.isToolEnabled(HighlightDisplayKey.find((String)shortName));
                    xmlWriter.addAttribute("enabled", Boolean.toString(toolEnabled));
                    String description = toolWrapper.loadDescription();
                    if (description != null) {
                        xmlWriter.setValue(description);
                    } else {
                        inspectionsWithoutDescriptions.add(shortName);
                    }
                    xmlWriter.endNode();
                }
                xmlWriter.endNode();
            }
            xmlWriter.endNode();
            if (!inspectionsWithoutDescriptions.isEmpty()) {
                LOG.error("Descriptions are missed for tools: " + StringUtil.join(inspectionsWithoutDescriptions, (String)", "));
            }
        }
    }

    @NotNull
    public static Path getInspectionResultPath(@NotNull Path outputDir, String name) {
        return outputDir.resolve(name + XML_EXTENSION);
    }

    @NotNull
    public static Path getInspectionResultFile(@NotNull Path outputDirectory, @NotNull String name) {
        return outputDirectory.resolve(name + XML_EXTENSION);
    }

    @NotNull
    public static BufferedWriter getWriter(@NotNull Path outputDirectory, @NotNull String name) throws IOException {
        Path file2 = InspectionsResultUtil.getInspectionResultFile(outputDirectory, name);
        Files.createDirectories(outputDirectory, new FileAttribute[0]);
        return Files.newBufferedWriter(file2, new OpenOption[0]);
    }

    public static void writeInspectionResult(@NotNull Project project, @NotNull String shortName, @NotNull Collection<? extends InspectionToolWrapper<?, ?>> wrappers, @NotNull Path outputDirectory, @NotNull Function<InspectionToolWrapper, InspectionToolResultExporter> f) throws IOException {
        if (wrappers.isEmpty()) {
            return;
        }
        try (XmlWriterWrapper reportWriter = new XmlWriterWrapper(project, outputDirectory, shortName, "problems");
             XmlWriterWrapper aggregateWriter = new XmlWriterWrapper(project, outputDirectory, shortName + AGGREGATE, ROOT);){
            reportWriter.checkOpen();
            for (InspectionToolWrapper<?, ?> wrapper2 : wrappers) {
                InspectionToolResultExporter presentation2 = f.apply(wrapper2);
                presentation2.exportResults(reportWriter::writeElement, presentation2::isExcluded, presentation2::isExcluded);
                if (!(presentation2 instanceof AggregateResultsExporter)) continue;
                ((AggregateResultsExporter)((Object)presentation2)).exportAggregateResults(aggregateWriter::writeElement);
            }
        }
    }

    public static void writeProfileName(@NotNull Path outputDirectory, @Nullable String profileName) throws IOException {
        Element element2 = new Element(INSPECTIONS_NODE);
        element2.setAttribute(PROFILE, Objects.requireNonNull(profileName));
        JDOMUtil.write((Element)element2, (Path)outputDirectory.resolve(".descriptions.xml"));
    }

    private static final class XmlWriterWrapper
    implements Closeable {
        private final Project myProject;
        private final Path myOutputDirectory;
        private final String myName;
        private final String myRootTagName;
        private Writer myFileWriter;
        private JbXmlOutputter myOutputter;

        XmlWriterWrapper(@NotNull Project project, @NotNull Path outputDirectory, @NotNull String name, @NotNull String rootTagName) {
            this.myProject = project;
            this.myOutputDirectory = outputDirectory;
            this.myName = name;
            this.myRootTagName = rootTagName;
        }

        void writeElement(@NotNull Element element2) {
            try {
                this.checkOpen();
                this.myFileWriter.write(10);
                this.myOutputter.output(element2, this.myFileWriter);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        void checkOpen() throws IOException {
            if (this.myFileWriter == null) {
                this.myFileWriter = XmlWriterWrapper.openFile(this.myOutputDirectory, this.myName);
                this.myOutputter = JbXmlOutputter.createOutputter((ComponentManager)this.myProject);
                this.startWritingXml();
            }
        }

        @Override
        public void close() throws IOException {
            if (this.myFileWriter == null) {
                return;
            }
            try {
                this.endWritingXml();
            }
            finally {
                Writer fileWriter = this.myFileWriter;
                this.myFileWriter = null;
                fileWriter.close();
            }
        }

        @NotNull
        private static Writer openFile(@NotNull Path outputDirectory, @NotNull String name) throws IOException {
            return InspectionsResultUtil.getWriter(outputDirectory, name);
        }

        private void startWritingXml() throws IOException {
            this.myFileWriter.write(60);
            this.myFileWriter.write(this.myRootTagName);
            this.myFileWriter.write(62);
        }

        private void endWritingXml() throws IOException {
            try {
                this.myFileWriter.write("\n");
                this.myFileWriter.write(60);
                this.myFileWriter.write(47);
                this.myFileWriter.write(this.myRootTagName);
                this.myFileWriter.write(62);
            }
            finally {
                this.myFileWriter.close();
            }
        }
    }
}

