/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.google.common.base.Predicates;
import com.google.common.collect.Lists;
import com.intellij.analysis.AnalysisScope;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.InspectionManagerBase;
import com.intellij.codeInspection.InspectionToolCmdlineOptionHelpProvider;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.InspectionsReportConverter;
import com.intellij.codeInspection.InspectionsResultUtil;
import com.intellij.codeInspection.ProblemDescriptorBase;
import com.intellij.codeInspection.ex.ApplicationInspectionProfileManagerBase;
import com.intellij.codeInspection.ex.GlobalInspectionContextEx;
import com.intellij.codeInspection.ex.GlobalInspectionContextUtil;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.codeInspection.ex.ReportConverterUtil;
import com.intellij.codeInspection.ex.XSLTReportConverter;
import com.intellij.codeInspection.reference.RefElement;
import com.intellij.conversion.ConversionListener;
import com.intellij.conversion.ConversionService;
import com.intellij.diagnostic.ThreadDumper;
import com.intellij.diff.tools.util.text.LineOffsetsUtil;
import com.intellij.diff.util.Range;
import com.intellij.icons.AllIcons;
import com.intellij.ide.CommandLineInspectionProgressReporter;
import com.intellij.ide.CommandLineInspectionProjectConfigurator;
import com.intellij.ide.impl.PatchProjectUtil;
import com.intellij.ide.impl.ProjectUtil;
import com.intellij.ide.startup.StartupManagerEx;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.application.ex.ApplicationInfoEx;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.util.ProgressIndicatorBase;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ex.ProjectManagerEx;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.changes.InvokeAfterUpdateMode;
import com.intellij.openapi.vcs.changes.VcsPreservingExecutor;
import com.intellij.openapi.vcs.ex.RangesBuilder;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.GlobalSearchScopesCore;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.scope.packageSet.NamedScope;
import com.intellij.psi.search.scope.packageSet.NamedScopesHolder;
import com.intellij.psi.search.scope.packageSet.PackageSet;
import com.intellij.psi.search.scope.packageSet.PackageSetFactory;
import com.intellij.psi.search.scope.packageSet.ParsingException;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.messages.MessageBusConnection;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.LockSupport;
import java.util.function.Predicate;
import one.util.streamex.StreamEx;
import org.jdom.JDOMException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.AsyncPromise;

public final class InspectionApplication
implements CommandLineInspectionProgressReporter {
    static final Logger LOG = Logger.getInstance(InspectionApplication.class);
    InspectionToolCmdlineOptionHelpProvider myHelpProvider;
    public String myProjectPath;
    public String myOutPath;
    String mySourceDirectory;
    public String myStubProfile;
    String myProfileName;
    String myProfilePath;
    public boolean myRunWithEditorSettings;
    boolean myRunGlobalToolsOnly;
    boolean myAnalyzeChanges;
    boolean myPathProfiling;
    private int myVerboseLevel;
    private final Map<String, List<Range>> diffMap = new ConcurrentHashMap<String, List<Range>>();
    private final MultiMap<Pair<String, Integer>, String> originalWarnings = MultiMap.createConcurrent();
    private final AsyncPromise<Void> isMappingLoaded = new AsyncPromise();
    public String myOutputFormat;
    private InspectionProfileImpl myInspectionProfile;
    public boolean myErrorCodeRequired = true;
    public String myScopePattern;
    Map<Path, Long> myCompleteProfile;

    public void startup() {
        if (this.myProjectPath == null) {
            this.reportError("Project to inspect is not defined");
            this.printHelp();
        }
        if (this.myProfileName == null && this.myProfilePath == null && this.myStubProfile == null) {
            this.reportError("Profile to inspect with is not defined");
            this.printHelp();
        }
        ApplicationManagerEx.getApplicationEx().setSaveAllowed(false);
        try {
            this.execute();
        }
        catch (Throwable e) {
            LOG.error(e);
            this.reportError(e.getMessage());
            this.gracefulExit();
            return;
        }
        if (this.myErrorCodeRequired) {
            ApplicationManagerEx.getApplicationEx().exit(true, true);
        }
    }

    public void enablePathProfiling() {
        this.myPathProfiling = true;
    }

    public Map<Path, Long> getPathProfile() {
        return this.myCompleteProfile;
    }

    public void execute() throws Exception {
        ApplicationInfoEx appInfo = (ApplicationInfoEx)ApplicationInfo.getInstance();
        this.reportMessageNoLineBreak(1, InspectionsBundle.message((String)"inspection.application.starting.up", (Object[])new Object[]{appInfo.getFullApplicationName() + " (build " + appInfo.getBuild().asString() + ")"}));
        this.reportMessage(1, InspectionsBundle.message((String)"inspection.done", (Object[])new Object[0]));
        Disposable disposable2 = Disposer.newDisposable();
        try {
            this.run(Paths.get(FileUtil.toCanonicalPath((String)this.myProjectPath), new String[0]), disposable2);
        }
        finally {
            Disposer.dispose((Disposable)disposable2);
        }
    }

    private void printHelp() {
        assert (this.myHelpProvider != null);
        this.myHelpProvider.printHelpAndExit();
    }

    @NotNull
    private CommandLineInspectionProjectConfigurator.ConfiguratorContext configuratorContext(final @NotNull Path projectPath, final @Nullable AnalysisScope scope) {
        return new CommandLineInspectionProjectConfigurator.ConfiguratorContext(){

            @Override
            @NotNull
            public ProgressIndicator getProgressIndicator() {
                return new ProgressIndicatorBase();
            }

            @Override
            @Nullable
            public AnalysisScope getAnalyzerScope() {
                return scope;
            }

            @Override
            @NotNull
            public CommandLineInspectionProgressReporter getLogger() {
                return InspectionApplication.this;
            }

            @Override
            @NotNull
            public Path getProjectPath() {
                return projectPath;
            }

            @Override
            @NotNull
            public Predicate<Path> getFilesFilter() {
                return Predicates.alwaysTrue();
            }

            @Override
            @NotNull
            public Predicate<VirtualFile> getVirtualFilesFilter() {
                return Predicates.alwaysTrue();
            }
        };
    }

    private void run(@NotNull Path projectPath, @NotNull Disposable parentDisposable) throws IOException, JDOMException, InterruptedException, ExecutionException {
        VirtualFile vfsProject = LocalFileSystem.getInstance().findFileByPath(FileUtil.toSystemIndependentName((String)projectPath.toString()));
        if (vfsProject == null) {
            this.reportError(InspectionsBundle.message((String)"inspection.application.file.cannot.be.found", (Object[])new Object[]{projectPath}));
            this.printHelp();
        }
        this.reportMessageNoLineBreak(1, InspectionsBundle.message((String)"inspection.application.opening.project", (Object[])new Object[0]));
        if (ConversionService.getInstance().convertSilently(projectPath, this.createConversionListener()).openingIsCanceled()) {
            this.gracefulExit();
            return;
        }
        for (CommandLineInspectionProjectConfigurator configurator : CommandLineInspectionProjectConfigurator.EP_NAME.getExtensionList()) {
            CommandLineInspectionProjectConfigurator.ConfiguratorContext context;
            if (!configurator.isApplicable(context = this.configuratorContext(projectPath, null))) continue;
            configurator.configureEnvironment(context);
        }
        Project project = ProjectUtil.openOrImport(projectPath);
        if (project == null) {
            this.reportError("Unable to open project");
            this.gracefulExit();
            return;
        }
        InspectionApplication.waitAllStartupActivitiesPassed(project);
        MessageBusConnection connection = project.getMessageBus().connect();
        connection.subscribe(ProjectLevelVcsManager.VCS_CONFIGURATION_CHANGED, () -> this.isMappingLoaded.setResult(null));
        Disposer.register((Disposable)parentDisposable, () -> InspectionApplication.closeProject(project));
        ApplicationManager.getApplication().invokeAndWait(() -> VirtualFileManager.getInstance().refreshWithoutFileWatcher(false));
        ApplicationManager.getApplication().invokeAndWait(() -> PatchProjectUtil.patchProject(project));
        this.reportMessage(1, InspectionsBundle.message((String)"inspection.done", (Object[])new Object[0]));
        this.reportMessageNoLineBreak(1, InspectionsBundle.message((String)"inspection.application.initializing.project", (Object[])new Object[0]));
        this.myInspectionProfile = this.loadInspectionProfile(project);
        if (this.myInspectionProfile == null) {
            return;
        }
        if (this.myAnalyzeChanges) {
            ChangeListManager changeListManager = ChangeListManager.getInstance((Project)project);
            changeListManager.invokeAfterUpdate(() -> {
                List files2 = changeListManager.getAffectedFiles();
                for (VirtualFile file2 : files2) {
                    this.reportMessage(0, "modified file" + file2.getPath());
                }
                try {
                    this.runAnalysisOnScope(projectPath, parentDisposable, project, this.myInspectionProfile, new AnalysisScope(project, (Collection)files2));
                }
                catch (IOException e) {
                    LOG.error((Throwable)e);
                }
            }, InvokeAfterUpdateMode.SYNCHRONOUS_NOT_CANCELLABLE, null, null);
        } else {
            AnalysisScope scope;
            if (this.myScopePattern != null) {
                try {
                    PackageSet packageSet = PackageSetFactory.getInstance().compile(this.myScopePattern);
                    NamedScope namedScope = new NamedScope("commandLineScope", AllIcons.Ide.LocalScope, packageSet);
                    scope = new AnalysisScope((SearchScope)GlobalSearchScopesCore.filterScope((Project)project, (NamedScope)namedScope), project);
                }
                catch (ParsingException e) {
                    LOG.error("Error of scope parsing", (Throwable)e);
                    this.gracefulExit();
                    return;
                }
            } else if (this.mySourceDirectory == null) {
                String scopeName = System.getProperty("idea.analyze.scope");
                NamedScope namedScope = scopeName != null ? NamedScopesHolder.getScope((Project)project, (String)scopeName) : null;
                scope = namedScope != null ? new AnalysisScope((SearchScope)GlobalSearchScopesCore.filterScope((Project)project, (NamedScope)namedScope), project) : new AnalysisScope(project);
            } else {
                this.mySourceDirectory = this.mySourceDirectory.replace(File.separatorChar, '/');
                VirtualFile vfsDir = LocalFileSystem.getInstance().findFileByPath(this.mySourceDirectory);
                if (vfsDir == null) {
                    this.reportError(InspectionsBundle.message((String)"inspection.application.directory.cannot.be.found", (Object[])new Object[]{this.mySourceDirectory}));
                    this.printHelp();
                }
                PsiDirectory psiDirectory = (PsiDirectory)ReadAction.compute(() -> {
                    assert (vfsDir != null);
                    return PsiManager.getInstance((Project)project).findDirectory(vfsDir);
                });
                scope = new AnalysisScope(Objects.requireNonNull(psiDirectory));
            }
            LOG.info("Used scope: " + scope.toString());
            this.runAnalysisOnScope(projectPath, parentDisposable, project, this.myInspectionProfile, scope);
        }
    }

    private static void waitAllStartupActivitiesPassed(@NotNull Project project) throws InterruptedException, ExecutionException {
        LOG.assertTrue(!ApplicationManager.getApplication().isDispatchThread());
        LOG.info("Waiting for startup activities");
        int timeout = Registry.intValue((String)"batch.inspections.startup.activities.timeout", (int)180);
        try {
            StartupManagerEx.getInstanceEx(project).getAllActivitiesPassedFuture().get(timeout, TimeUnit.MINUTES);
            LOG.info("Startup activities finished");
        }
        catch (TimeoutException e) {
            String threads = ThreadDumper.dumpThreadsToString();
            throw new RuntimeException(String.format("Cannot process startup activities in %s minutes. ", timeout) + "You can try to increase batch.inspections.startup.activities.timeout registry value. Thread dumps\n: " + threads, e);
        }
    }

    @NotNull
    private GlobalInspectionContextEx createGlobalInspectionContext(Project project) {
        InspectionManagerBase im = (InspectionManagerBase)InspectionManager.getInstance((Project)project);
        GlobalInspectionContextEx context = (GlobalInspectionContextEx)im.createNewGlobalContext();
        context.setExternalProfile(this.myInspectionProfile);
        if (this.myPathProfiling) {
            context.startPathProfiling();
        }
        im.setProfile(this.myInspectionProfile.getName());
        return context;
    }

    private void runAnalysisOnScope(Path projectPath, @NotNull Disposable parentDisposable, Project project, InspectionProfileImpl inspectionProfile, AnalysisScope scope) throws IOException {
        Path resultsDataPath;
        InspectionsReportConverter reportConverter;
        this.reportMessage(1, InspectionsBundle.message((String)"inspection.done", (Object[])new Object[0]));
        if (!this.myRunWithEditorSettings) {
            this.reportMessage(1, InspectionsBundle.message((String)"inspection.application.chosen.profile.log.message", (Object[])new Object[]{inspectionProfile.getName()}));
        }
        if ((reportConverter = ReportConverterUtil.getReportConverter(this.myOutputFormat)) == null && this.myOutputFormat != null && this.myOutputFormat.endsWith(".xsl")) {
            reportConverter = new XSLTReportConverter(this.myOutputFormat);
        }
        try {
            resultsDataPath = ReportConverterUtil.getResultsDataPath(parentDisposable, reportConverter, this.myOutPath);
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
            System.err.println("Cannot create tmp directory.");
            System.exit(1);
            return;
        }
        this.runAnalysis(project, projectPath, inspectionProfile, scope, reportConverter, resultsDataPath);
    }

    private void configureProject(@NotNull Path projectPath, @NotNull Project project, @NotNull AnalysisScope scope) {
        for (CommandLineInspectionProjectConfigurator configurator : CommandLineInspectionProjectConfigurator.EP_NAME.getIterable()) {
            CommandLineInspectionProjectConfigurator.ConfiguratorContext context;
            if (!configurator.isApplicable(context = this.configuratorContext(projectPath, scope))) continue;
            configurator.configureProject(project, context);
        }
        InspectionApplication.waitForInvokeLaterActivities();
    }

    private static void waitForInvokeLaterActivities() {
        ApplicationManager.getApplication().invokeAndWait(() -> {}, ModalityState.any());
    }

    private void runAnalysis(Project project, Path projectPath, InspectionProfileImpl inspectionProfile, AnalysisScope scope, InspectionsReportConverter reportConverter, Path resultsDataPath) throws IOException {
        GlobalInspectionContextEx context = this.createGlobalInspectionContext(project);
        if (this.myAnalyzeChanges) {
            scope = this.runAnalysisOnCodeWithoutChanges(project, projectPath, this.createGlobalInspectionContext(project), scope, resultsDataPath);
            this.setupSecondAnalysisHandler(project, context);
        }
        ArrayList<Path> inspectionsResults = new ArrayList<Path>();
        this.runUnderProgress(project, projectPath, context, scope, resultsDataPath, inspectionsResults);
        Path descriptionsFile = resultsDataPath.resolve(".descriptions.xml");
        InspectionsResultUtil.describeInspections(descriptionsFile, this.myRunWithEditorSettings ? null : inspectionProfile.getName(), inspectionProfile);
        inspectionsResults.add(descriptionsFile);
        this.saveProfile(context);
        if (reportConverter != null) {
            try {
                reportConverter.convert(resultsDataPath.toString(), this.myOutPath, context.getTools(), ContainerUtil.map2List(inspectionsResults, path -> path.toFile()));
                reportConverter.projectData(project, this.myOutPath);
            }
            catch (InspectionsReportConverter.ConversionException e) {
                this.reportError("\n" + e.getMessage());
                this.printHelp();
            }
        }
    }

    private void saveProfile(GlobalInspectionContextEx context) {
        if (!this.myPathProfiling) {
            return;
        }
        Map<Path, Long> profile = context.getPathProfile();
        HashMap<Path, Long> completeProfile = new HashMap<Path, Long>();
        profile.forEach((path, millis) -> {
            while (path != null) {
                completeProfile.merge((Path)path, (Long)millis, Long::sum);
                path = path.getParent();
            }
        });
        this.myCompleteProfile = completeProfile;
    }

    @NotNull
    private AnalysisScope runAnalysisOnCodeWithoutChanges(Project project, Path projectPath, GlobalInspectionContextEx context, AnalysisScope scope, Path resultsDataPath) {
        VirtualFile[] changes = ChangesUtil.getFilesFromChanges((Collection)ChangeListManager.getInstance((Project)project).getAllChanges());
        this.setupFirstAnalysisHandler(context);
        ArrayList inspectionsResults = new ArrayList();
        DumbService dumbService = DumbService.getInstance((Project)project);
        while (dumbService.isDumb()) {
            LockSupport.parkNanos(50000000L);
        }
        if (ProjectLevelVcsManager.getInstance((Project)project).getAllVcsRoots().length == 0) {
            try {
                this.isMappingLoaded.blockingGet(60000);
            }
            catch (ExecutionException | TimeoutException e) {
                this.reportError("Cannot initialize vcs mapping");
                this.gracefulExit();
            }
        }
        InspectionApplication.runAnalysisAfterShelvingSync(project, ChangeListManager.getInstance((Project)project).getAffectedFiles(), this.createProcessIndicator(), () -> {
            InspectionApplication.syncProject(project, changes);
            this.runUnderProgress(project, projectPath, context, scope, resultsDataPath, inspectionsResults);
        });
        InspectionApplication.syncProject(project, changes);
        List files2 = ChangeListManager.getInstance((Project)project).getAffectedFiles();
        if (this.myVerboseLevel == 3) {
            for (VirtualFile file2 : files2) {
                this.reportMessage(1, "modified after unshelving: " + file2.getPath());
            }
        }
        return new AnalysisScope(project, (Collection)files2);
    }

    private static void syncProject(Project project, VirtualFile[] changes) {
        VfsUtil.markDirtyAndRefresh((boolean)false, (boolean)false, (boolean)false, (VirtualFile[])changes);
        WriteAction.runAndWait(() -> PsiDocumentManager.getInstance((Project)project).commitAllDocuments());
    }

    private void setupFirstAnalysisHandler(GlobalInspectionContextEx context) {
        if (this.myVerboseLevel > 0) {
            this.reportMessage(1, "Running first analysis stage...");
        }
        context.setGlobalReportedProblemFilter((entity, description) -> {
            if (!(entity instanceof RefElement)) {
                return false;
            }
            Pair<VirtualFile, Integer> fileAndLine = InspectionApplication.findFileAndLineByRefElement((RefElement)entity);
            if (fileAndLine == null) {
                return false;
            }
            this.originalWarnings.putValue((Object)Pair.create((Object)((VirtualFile)fileAndLine.first).getPath(), (Object)fileAndLine.second), (Object)description);
            return false;
        });
        context.setReportedProblemFilter((element2, descriptors) -> {
            List problemDescriptors = StreamEx.of((Object[])descriptors).select(ProblemDescriptorBase.class).toList();
            if (!problemDescriptors.isEmpty()) {
                ProblemDescriptorBase problemDescriptor = (ProblemDescriptorBase)problemDescriptors.get(0);
                VirtualFile file2 = problemDescriptor.getContainingFile();
                if (file2 == null) {
                    return false;
                }
                int lineNumber = problemDescriptor.getLineNumber();
                for (ProblemDescriptorBase it : problemDescriptors) {
                    this.originalWarnings.putValue((Object)Pair.create((Object)file2.getPath(), (Object)lineNumber), (Object)it.toString());
                }
            }
            return false;
        });
    }

    private void setupSecondAnalysisHandler(Project project, GlobalInspectionContextEx context) {
        if (this.myVerboseLevel > 0) {
            this.reportMessage(1, "Running second analysis stage...");
        }
        this.printBeforeSecondStageProblems();
        ChangeListManager changeListManager = ChangeListManager.getInstance((Project)project);
        context.setGlobalReportedProblemFilter((entity, description) -> {
            if (!(entity instanceof RefElement)) {
                return false;
            }
            Pair<VirtualFile, Integer> fileAndLine = InspectionApplication.findFileAndLineByRefElement((RefElement)entity);
            if (fileAndLine == null) {
                return false;
            }
            return this.secondAnalysisFilter(changeListManager, description, (VirtualFile)fileAndLine.first, (Integer)fileAndLine.second);
        });
        context.setReportedProblemFilter((element2, descriptors) -> {
            List any = StreamEx.of((Object[])descriptors).select(ProblemDescriptorBase.class).toList();
            if (!any.isEmpty()) {
                ProblemDescriptorBase problemDescriptor = (ProblemDescriptorBase)any.get(0);
                String text = problemDescriptor.toString();
                VirtualFile file2 = problemDescriptor.getContainingFile();
                if (file2 == null) {
                    return true;
                }
                int line = problemDescriptor.getLineNumber();
                return this.secondAnalysisFilter(changeListManager, text, file2, line);
            }
            return true;
        });
    }

    @Nullable
    private static Pair<VirtualFile, Integer> findFileAndLineByRefElement(RefElement refElement) {
        PsiElement element2 = refElement.getPsiElement();
        PsiFile psiFile = element2.getContainingFile();
        if (psiFile == null) {
            return null;
        }
        VirtualFile virtualFile = psiFile.getVirtualFile();
        if (virtualFile == null) {
            return null;
        }
        int line = (Integer)ReadAction.compute(() -> {
            Document document = PsiDocumentManager.getInstance((Project)psiFile.getProject()).getDocument(psiFile);
            return document == null ? -1 : document.getLineNumber(element2.getTextRange().getStartOffset());
        });
        return Pair.create((Object)virtualFile, (Object)line);
    }

    private boolean secondAnalysisFilter(ChangeListManager changeListManager, String text, VirtualFile file2, int line) {
        List<Range> ranges = this.getOrComputeUnchangedRanges(file2, changeListManager);
        Optional first = StreamEx.of(ranges).findFirst(it -> it.start1 <= line && line < it.end1);
        if (!first.isPresent()) {
            this.logNotFiltered(text, file2, line, -1);
            return true;
        }
        Range originRange = (Range)first.get();
        int position = originRange.start2 + line - originRange.start1;
        Collection problems2 = this.originalWarnings.get((Object)Pair.create((Object)file2.getPath(), (Object)position));
        if (problems2.stream().anyMatch(it -> Objects.equals(it, text))) {
            return false;
        }
        this.logNotFiltered(text, file2, line, position);
        return true;
    }

    private void logNotFiltered(String text, VirtualFile file2, int line, int position) {
        if (text.contains("unused")) {
            return;
        }
        this.reportMessage(3, "Not filtered: ");
        this.reportMessage(3, file2.getPath() + ":" + (line + 1) + " Original: " + (position + 1));
        this.reportMessage(3, "\t\t" + text);
    }

    private void printBeforeSecondStageProblems() {
        if (this.myVerboseLevel == 3) {
            this.reportMessage(3, "Old warnings:");
            ArrayList<Map.Entry> entries = new ArrayList<Map.Entry>(this.originalWarnings.entrySet());
            this.reportMessage(3, "total size: " + entries.size());
            entries.sort(Comparator.comparing(o -> (String)((Pair)o.getKey()).first).thenComparingInt(o -> (Integer)((Pair)o.getKey()).second));
            for (Map.Entry entry : entries) {
                this.reportMessage(3, (String)((Pair)entry.getKey()).first + ":" + ((Integer)((Pair)entry.getKey()).second + 1));
                for (String value2 : (Collection)entry.getValue()) {
                    this.reportMessage(3, "\t\t" + value2);
                }
            }
        }
    }

    private void runUnderProgress(@NotNull Project project, @NotNull Path projectPath, @NotNull GlobalInspectionContextEx context, @NotNull AnalysisScope scope, @NotNull Path resultsDataPath, @NotNull List<? super Path> inspectionsResults) {
        ProgressManager.getInstance().runProcess(() -> {
            this.configureProject(projectPath, project, scope);
            if (!GlobalInspectionContextUtil.canRunInspections(project, false, () -> {})) {
                this.gracefulExit();
                return;
            }
            context.launchInspectionsOffline(scope, resultsDataPath, this.myRunGlobalToolsOnly, inspectionsResults);
            this.reportMessage(1, "\n" + InspectionsBundle.message((String)"inspection.capitalized.done", (Object[])new Object[0]) + "\n");
            if (!this.myErrorCodeRequired) {
                InspectionApplication.closeProject(project);
            }
        }, (ProgressIndicator)this.createProcessIndicator());
    }

    @NotNull
    private ProgressIndicatorBase createProcessIndicator() {
        return new ProgressIndicatorBase(){
            private String lastPrefix = "";
            private int myLastPercent = -1;
            {
                this.setText("");
            }

            @Override
            public void setText(String text) {
                if (InspectionApplication.this.myVerboseLevel == 0) {
                    return;
                }
                if (InspectionApplication.this.myVerboseLevel == 1) {
                    if (text == null) {
                        return;
                    }
                    String prefix = InspectionApplication.getPrefix(text);
                    if (prefix == null) {
                        return;
                    }
                    if (prefix.equals(this.lastPrefix)) {
                        InspectionApplication.this.reportMessageNoLineBreak(1, ".");
                        return;
                    }
                    this.lastPrefix = prefix;
                    InspectionApplication.this.reportMessage(1, "");
                    InspectionApplication.this.reportMessage(1, prefix);
                    return;
                }
                if (InspectionApplication.this.myVerboseLevel == 3) {
                    if (text == null) {
                        return;
                    }
                    if (!this.isIndeterminate() && this.getFraction() > 0.0) {
                        int percent = (int)(this.getFraction() * 100.0);
                        if (this.myLastPercent == percent) {
                            return;
                        }
                        String prefix = InspectionApplication.getPrefix(text);
                        this.myLastPercent = percent;
                        String msg = (prefix != null ? prefix : InspectionsBundle.message((String)"inspection.display.name", (Object[])new Object[0])) + " " + percent + "%";
                        InspectionApplication.this.reportMessage(2, msg);
                    }
                    return;
                }
                InspectionApplication.this.reportMessage(2, text);
            }
        };
    }

    private static void runAnalysisAfterShelvingSync(Project project, List<? extends VirtualFile> files2, ProgressIndicator progressIndicator2, Runnable afterShelve) {
        Set versionedRoots = StreamEx.of(files2).map(it -> ProjectLevelVcsManager.getInstance((Project)project).getVcsRootFor(it)).nonNull().toSet();
        String message = VcsBundle.message((String)"searching.for.code.smells.freezing.process", (Object[])new Object[0]);
        VcsPreservingExecutor.executeOperation((Project)project, (Collection)versionedRoots, (String)message, (ProgressIndicator)progressIndicator2, (Runnable)afterShelve);
    }

    private void gracefulExit() {
        if (!this.myErrorCodeRequired) {
            throw new RuntimeException("Failed to proceed");
        }
        System.exit(1);
    }

    private static void closeProject(@NotNull Project project) {
        ApplicationManager.getApplication().invokeAndWait(() -> {
            if (!project.isDisposed()) {
                ProjectManagerEx.getInstanceEx().forceCloseProject(project);
            }
        });
    }

    @Nullable
    private InspectionProfileImpl loadInspectionProfile(@NotNull Project project) throws IOException, JDOMException {
        InspectionProfileImpl inspectionProfile = null;
        if (this.myProfileName != null) {
            inspectionProfile = this.loadProfileByName(project, this.myProfileName);
            if (inspectionProfile == null) {
                this.reportError("Profile with configured name (" + this.myProfileName + ") was not found (neither in project nor in config directory)");
                this.gracefulExit();
                return null;
            }
            return inspectionProfile;
        }
        if (this.myProfilePath != null) {
            inspectionProfile = this.loadProfileByPath(this.myProfilePath);
            if (inspectionProfile == null) {
                this.reportError("Failed to load profile from '" + this.myProfilePath + "'");
                this.gracefulExit();
                return null;
            }
            return inspectionProfile;
        }
        if (this.myStubProfile != null) {
            if (!this.myRunWithEditorSettings) {
                inspectionProfile = this.loadProfileByName(project, this.myStubProfile);
                if (inspectionProfile != null) {
                    return inspectionProfile;
                }
                inspectionProfile = this.loadProfileByPath(this.myStubProfile);
                if (inspectionProfile != null) {
                    return inspectionProfile;
                }
            }
            inspectionProfile = InspectionProjectProfileManager.getInstance(project).getCurrentProfile();
            this.reportError("Using default project profile");
        }
        return inspectionProfile;
    }

    @Nullable
    private InspectionProfileImpl loadProfileByPath(@NotNull String profilePath) throws IOException, JDOMException {
        InspectionProfileImpl inspectionProfile = ApplicationInspectionProfileManagerBase.getInstanceBase().loadProfile(profilePath);
        if (inspectionProfile != null) {
            this.reportMessage(1, "Loaded profile '" + inspectionProfile.getName() + "' from file '" + profilePath + "'");
        }
        return inspectionProfile;
    }

    @Nullable
    private InspectionProfileImpl loadProfileByName(@NotNull Project project, @NotNull String profileName) {
        InspectionProjectProfileManager profileManager = InspectionProjectProfileManager.getInstance(project);
        InspectionProfileImpl inspectionProfile = profileManager.getProfile(profileName, false);
        if (inspectionProfile != null) {
            this.reportMessage(1, "Loaded shared project profile '" + profileName + "'");
        } else {
            for (InspectionProfileImpl profile : profileManager.getProfiles()) {
                if (!Comparing.strEqual((String)profile.getName(), (String)profileName)) continue;
                inspectionProfile = profile;
                this.reportMessage(1, "Loaded local profile '" + profileName + "'");
                break;
            }
        }
        return inspectionProfile;
    }

    private ConversionListener createConversionListener() {
        return new ConversionListener(){

            @Override
            public void conversionNeeded() {
                InspectionApplication.this.reportMessage(1, InspectionsBundle.message((String)"inspection.application.project.has.older.format.and.will.be.converted", (Object[])new Object[0]));
            }

            @Override
            public void successfullyConverted(@NotNull File backupDir) {
                InspectionApplication.this.reportMessage(1, InspectionsBundle.message((String)"inspection.application.project.was.succesfully.converted.old.project.files.were.saved.to.0", (Object[])new Object[]{backupDir.getAbsolutePath()}));
            }

            @Override
            public void error(@NotNull String message) {
                InspectionApplication.this.reportError(InspectionsBundle.message((String)"inspection.application.cannot.convert.project.0", (Object[])new Object[]{message}));
            }

            @Override
            public void cannotWriteToFiles(@NotNull List<? extends File> readonlyFiles) {
                StringBuilder files2 = new StringBuilder();
                for (File file2 : readonlyFiles) {
                    files2.append(file2.getAbsolutePath()).append("; ");
                }
                InspectionApplication.this.reportError(InspectionsBundle.message((String)"inspection.application.cannot.convert.the.project.the.following.files.are.read.only.0", (Object[])new Object[]{files2.toString()}));
            }
        };
    }

    @Nullable
    private static String getPrefix(@NotNull String text) {
        int idx = text.indexOf(" in ");
        if (idx == -1) {
            idx = text.indexOf(" of ");
        }
        return idx == -1 ? null : text.substring(0, idx);
    }

    public void setVerboseLevel(int verboseLevel) {
        this.myVerboseLevel = verboseLevel;
    }

    private void reportMessageNoLineBreak(int minVerboseLevel, String message) {
        if (this.myVerboseLevel >= minVerboseLevel) {
            System.out.print(message);
        }
    }

    @Override
    public void reportError(String message) {
        System.err.println(message);
    }

    @Override
    public void reportMessage(int minVerboseLevel, String message) {
        if (this.myVerboseLevel >= minVerboseLevel) {
            System.out.println(message);
        }
    }

    private List<Range> getOrComputeUnchangedRanges(@NotNull VirtualFile virtualFile, @NotNull ChangeListManager changeListManager) {
        return this.diffMap.computeIfAbsent(virtualFile.getPath(), key -> InspectionApplication.computeDiff(virtualFile, changeListManager));
    }

    private static List<Range> computeDiff(@NotNull VirtualFile virtualFile, @NotNull ChangeListManager changeListManager) {
        try {
            Change change = changeListManager.getChange(virtualFile);
            if (change == null) {
                return Collections.emptyList();
            }
            ContentRevision revision = change.getBeforeRevision();
            if (revision == null) {
                return Collections.emptyList();
            }
            String oldContent = revision.getContent();
            if (oldContent == null) {
                return Collections.emptyList();
            }
            String newContent = VfsUtilCore.loadText((VirtualFile)virtualFile);
            return Lists.newArrayList(RangesBuilder.compareLines(newContent, oldContent, LineOffsetsUtil.create(newContent), LineOffsetsUtil.create(oldContent)).iterateUnchanged());
        }
        catch (VcsException | IOException e) {
            LOG.error("Couldn't load content", e);
            return Collections.emptyList();
        }
    }
}

