/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.codeInsight.daemon.impl.SeverityRegistrar;
import com.intellij.codeInspection.CommonProblemDescriptor;
import com.intellij.codeInspection.GlobalInspectionTool;
import com.intellij.codeInspection.InspectionToolResultExporter;
import com.intellij.codeInspection.InspectionsResultUtil;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemDescriptorBase;
import com.intellij.codeInspection.ProblemDescriptorUtil;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.QuickFix;
import com.intellij.codeInspection.ex.GlobalInspectionContextEx;
import com.intellij.codeInspection.ex.GlobalInspectionToolWrapper;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.codeInspection.ex.LocalInspectionToolWrapper;
import com.intellij.codeInspection.ex.ScopeToolState;
import com.intellij.codeInspection.ex.Tools;
import com.intellij.codeInspection.reference.RefElement;
import com.intellij.codeInspection.reference.RefEntity;
import com.intellij.codeInspection.reference.RefManager;
import com.intellij.codeInspection.reference.RefVisitor;
import com.intellij.codeInspection.ui.AggregateResultsExporter;
import com.intellij.codeInspection.ui.GlobalReportedProblemFilter;
import com.intellij.codeInspection.ui.ReportedProblemFilter;
import com.intellij.codeInspection.ui.util.SynchronizedBidiMultiMap;
import com.intellij.configurationStore.JbXmlOutputter;
import com.intellij.injected.editor.VirtualFileWindow;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.util.ArrayFactory;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashSet;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.jdom.Element;
import org.jdom.Verifier;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DefaultInspectionToolResultExporter
implements InspectionToolResultExporter {
    protected static final Logger LOG = Logger.getInstance(DefaultInspectionToolResultExporter.class);
    public static final String INSPECTION_RESULTS_PROBLEM_CLASS_ELEMENT = "problem_class";
    public static final String INSPECTION_RESULTS_SEVERITY_ATTRIBUTE = "severity";
    public static final String INSPECTION_RESULTS_ATTRIBUTE_KEY_ATTRIBUTE = "attribute_key";
    public static final String INSPECTION_RESULTS_ID_ATTRIBUTE = "id";
    public static final String INSPECTION_RESULTS_DESCRIPTION_ELEMENT = "description";
    public static final String INSPECTION_RESULTS_HINTS_ELEMENT = "hints";
    public static final String INSPECTION_RESULTS_HINT_ELEMENT = "hint";
    public static final String INSPECTION_RESULTS_VALUE_ATTRIBUTE = "value";
    @NotNull
    protected final InspectionToolWrapper myToolWrapper;
    @NotNull
    protected final GlobalInspectionContextEx myContext;
    private final SynchronizedBidiMultiMap<RefEntity, CommonProblemDescriptor> myExcludedElements = DefaultInspectionToolResultExporter.createBidiMap();
    protected final SynchronizedBidiMultiMap<RefEntity, CommonProblemDescriptor> myProblemElements = DefaultInspectionToolResultExporter.createBidiMap();
    protected final SynchronizedBidiMultiMap<RefEntity, CommonProblemDescriptor> mySuppressedElements = DefaultInspectionToolResultExporter.createBidiMap();
    protected final SynchronizedBidiMultiMap<RefEntity, CommonProblemDescriptor> myResolvedElements = DefaultInspectionToolResultExporter.createBidiMap();
    protected final Map<String, Set<RefEntity>> myContents = Collections.synchronizedMap(new HashMap(1));

    public DefaultInspectionToolResultExporter(@NotNull InspectionToolWrapper toolWrapper, @NotNull GlobalInspectionContextEx context) {
        this.myToolWrapper = toolWrapper;
        this.myContext = context;
    }

    @Override
    @NotNull
    public InspectionToolWrapper getToolWrapper() {
        return this.myToolWrapper;
    }

    @NotNull
    public RefManager getRefManager() {
        return this.getContext().getRefManager();
    }

    @Override
    @NotNull
    public SynchronizedBidiMultiMap<RefEntity, CommonProblemDescriptor> getProblemElements() {
        return this.myProblemElements;
    }

    protected synchronized void writeOutput(CommonProblemDescriptor @NotNull [] descriptions, @NotNull RefEntity refElement) throws IOException {
        Path file2 = InspectionsResultUtil.getInspectionResultFile(this.myContext.getOutputPath(), this.myToolWrapper.getShortName());
        boolean exists = Files.exists(file2, new LinkOption[0]);
        Files.createDirectories(file2.getParent(), new FileAttribute[0]);
        try (BufferedWriter writer = Files.newBufferedWriter(file2, StandardOpenOption.CREATE, StandardOpenOption.WRITE, StandardOpenOption.APPEND);){
            if (!exists) {
                ((Writer)writer).write(60);
                writer.write("problems");
                ((Writer)writer).write(32);
                writer.write("is_local_tool");
                ((Writer)writer).write(61);
                ((Writer)writer).write(34);
                writer.write(Boolean.toString(this.myToolWrapper instanceof LocalInspectionToolWrapper));
                ((Writer)writer).write(34);
                ((Writer)writer).write(62);
                ((Writer)writer).write(10);
            }
            this.exportResults(descriptions, refElement, p -> {
                try {
                    JbXmlOutputter.collapseMacrosAndWrite(p, (ComponentManager)this.getContext().getProject(), writer);
                }
                catch (IOException e) {
                    LOG.error((Throwable)e);
                }
            }, d -> false);
            ((Writer)writer).write(10);
        }
    }

    @Override
    public void exportResults(final @NotNull Consumer<? super Element> resultConsumer, final @NotNull Predicate<? super RefEntity> excludedEntities, final @NotNull Predicate<? super CommonProblemDescriptor> excludedDescriptors) {
        this.getRefManager().iterate(new RefVisitor(){

            public void visitElement(@NotNull RefEntity elem) {
                if (!excludedEntities.test(elem)) {
                    DefaultInspectionToolResultExporter.this.exportResults((Consumer<? super Element>)resultConsumer, elem, (Predicate<? super CommonProblemDescriptor>)excludedDescriptors);
                }
            }
        });
    }

    @Override
    @NotNull
    public Project getProject() {
        return this.myContext.getProject();
    }

    @Override
    public void exportResults(@NotNull Consumer<? super Element> resultConsumer, @NotNull RefEntity refEntity, @NotNull Predicate<? super CommonProblemDescriptor> isDescriptorExcluded) {
        CommonProblemDescriptor[] descriptions = this.getProblemElements().get(refEntity);
        if (descriptions != null) {
            this.exportResults(descriptions, refEntity, resultConsumer, isDescriptorExcluded);
        }
    }

    protected void exportResults(CommonProblemDescriptor @NotNull [] descriptors, @NotNull RefEntity refEntity, @NotNull Consumer<? super Element> problemSink, @NotNull Predicate<? super CommonProblemDescriptor> isDescriptorExcluded) {
        for (CommonProblemDescriptor descriptor2 : descriptors) {
            if (isDescriptorExcluded.test((CommonProblemDescriptor)descriptor2)) continue;
            int line = descriptor2 instanceof ProblemDescriptor ? ((ProblemDescriptor)descriptor2).getLineNumber() : -1;
            Element element2 = null;
            try {
                element2 = refEntity.getRefManager().export(refEntity, line);
            }
            catch (ProcessCanceledException e) {
                throw e;
            }
            catch (Throwable e) {
                LOG.error(e);
            }
            if (element2 == null) {
                return;
            }
            this.exportResult(refEntity, descriptor2, element2);
            problemSink.accept((Element)element2);
        }
    }

    private void exportResult(@NotNull RefEntity refEntity, @NotNull CommonProblemDescriptor descriptor2, @NotNull Element element2) {
        PsiElement psiElement = descriptor2 instanceof ProblemDescriptor ? ((ProblemDescriptor)descriptor2).getPsiElement() : null;
        try {
            TextRange textRange;
            Element problemClassElement = new Element(INSPECTION_RESULTS_PROBLEM_CLASS_ELEMENT);
            problemClassElement.setAttribute(INSPECTION_RESULTS_ID_ATTRIBUTE, this.myToolWrapper.getShortName());
            problemClassElement.addContent(DefaultInspectionToolResultExporter.sanitizeIllegalXmlChars(this.myToolWrapper.getDisplayName()));
            HighlightSeverity severity = InspectionToolResultExporter.getSeverity(refEntity, psiElement, this);
            SeverityRegistrar severityRegistrar = this.myContext.getCurrentProfile().getProfileManager().getSeverityRegistrar();
            HighlightInfoType type = descriptor2 instanceof ProblemDescriptor ? ProblemDescriptorUtil.highlightTypeFromDescriptor((ProblemDescriptor)descriptor2, severity, severityRegistrar) : ProblemDescriptorUtil.getHighlightInfoType(ProblemHighlightType.GENERIC_ERROR_OR_WARNING, severity, severityRegistrar);
            problemClassElement.setAttribute(INSPECTION_RESULTS_SEVERITY_ATTRIBUTE, type.getSeverity(psiElement).getName());
            problemClassElement.setAttribute(INSPECTION_RESULTS_ATTRIBUTE_KEY_ATTRIBUTE, type.getAttributesKey().getExternalName());
            element2.addContent(problemClassElement);
            if (this.myToolWrapper instanceof GlobalInspectionToolWrapper) {
                GlobalInspectionTool globalInspectionTool = (GlobalInspectionTool)((GlobalInspectionToolWrapper)this.myToolWrapper).getTool();
                QuickFix[] fixes = descriptor2.getFixes();
                if (fixes != null) {
                    Element hintsElement = new Element(INSPECTION_RESULTS_HINTS_ELEMENT);
                    for (QuickFix fix : fixes) {
                        String hint = globalInspectionTool.getHint(fix);
                        if (hint == null) continue;
                        Element hintElement = new Element(INSPECTION_RESULTS_HINT_ELEMENT);
                        hintElement.setAttribute(INSPECTION_RESULTS_VALUE_ATTRIBUTE, DefaultInspectionToolResultExporter.sanitizeIllegalXmlChars(hint));
                        hintsElement.addContent(hintElement);
                    }
                    element2.addContent(hintsElement);
                }
            }
            String template = descriptor2.getDescriptionTemplate();
            String highlightedText = ProblemDescriptorUtil.extractHighlightedText(descriptor2, psiElement);
            String problemText = StringUtil.replace((String)StringUtil.replace((String)template, (String)"#ref", (String)(psiElement != null ? highlightedText : "")), (String)" #loc ", (String)" ");
            Element descriptionElement = new Element(INSPECTION_RESULTS_DESCRIPTION_ELEMENT);
            descriptionElement.addContent(DefaultInspectionToolResultExporter.sanitizeIllegalXmlChars(problemText));
            element2.addContent(descriptionElement);
            Element highLightedElement = new Element("highlighted_element");
            highLightedElement.addContent(DefaultInspectionToolResultExporter.sanitizeIllegalXmlChars(highlightedText));
            element2.addContent(highLightedElement);
            if (descriptor2 instanceof ProblemDescriptorBase && (textRange = ((ProblemDescriptorBase)descriptor2).getTextRangeForNavigation()) != null) {
                int offset = textRange.getStartOffset() - ((ProblemDescriptorBase)descriptor2).getLineStartOffset();
                int length = textRange.getLength();
                element2.addContent(new Element("offset").addContent(String.valueOf(offset)));
                element2.addContent(new Element("length").addContent(String.valueOf(length)));
            }
        }
        catch (RuntimeException e) {
            String message = "Cannot save results for " + refEntity.getName() + ", inspection which caused problem: " + this.myToolWrapper.getShortName() + ", problem descriptor " + descriptor2;
            if (psiElement != null) {
                message = message + ", element class: " + psiElement.getClass() + ", containing file: " + psiElement.getContainingFile();
            }
            LOG.error(message, (Throwable)e);
        }
    }

    private static String sanitizeIllegalXmlChars(String text) {
        if (Verifier.checkCharacterData((String)text) == null) {
            return text;
        }
        return text.codePoints().map(cp -> Verifier.isXMLCharacter((int)cp) ? cp : 63).collect(StringBuilder::new, StringBuilder::appendCodePoint, StringBuilder::append).toString();
    }

    protected String getSeverityDelegateName() {
        return this.getToolWrapper().getShortName();
    }

    @NotNull
    public GlobalInspectionContextEx getContext() {
        return this.myContext;
    }

    @NotNull
    private static SynchronizedBidiMultiMap<RefEntity, CommonProblemDescriptor> createBidiMap() {
        return new SynchronizedBidiMultiMap<RefEntity, CommonProblemDescriptor>(){

            @Override
            @NotNull
            protected ArrayFactory<CommonProblemDescriptor> arrayFactory() {
                return CommonProblemDescriptor.ARRAY_FACTORY;
            }
        };
    }

    @Override
    @Nullable
    public HighlightSeverity getSeverity(@NotNull RefElement element2) {
        return (HighlightSeverity)ReadAction.nonBlocking(() -> {
            PsiFile psiElement = ((RefElement)element2.getRefManager().getRefinedElement((RefEntity)element2)).getPointer().getContainingFile();
            if (psiElement != null) {
                GlobalInspectionContextEx context = this.getContext();
                String shortName = this.getSeverityDelegateName();
                Tools tools = context.getTools().get(shortName);
                if (tools != null) {
                    for (ScopeToolState state : tools.getTools()) {
                        InspectionToolWrapper toolWrapper = state.getTool();
                        if (toolWrapper != this.getToolWrapper()) continue;
                        return context.getCurrentProfile().getErrorLevel(HighlightDisplayKey.find((String)shortName), (PsiElement)psiElement).getSeverity();
                    }
                }
                InspectionProfileImpl profile = InspectionProjectProfileManager.getInstance(context.getProject()).getCurrentProfile();
                HighlightDisplayLevel level = profile.getErrorLevel(HighlightDisplayKey.find((String)shortName), (PsiElement)psiElement);
                return level.getSeverity();
            }
            return null;
        }).executeSynchronously();
    }

    @Override
    public boolean isExcluded(@NotNull CommonProblemDescriptor descriptor2) {
        return this.myExcludedElements.containsValue(descriptor2);
    }

    @Override
    public boolean isExcluded(@NotNull RefEntity entity) {
        Object[] excluded = this.myExcludedElements.get(entity);
        Object[] problems2 = this.myProblemElements.get(entity);
        return excluded != null && problems2 != null && Comparing.equal((Object)ContainerUtil.set((Object[])excluded), (Object)ContainerUtil.set((Object[])problems2));
    }

    @Override
    public void amnesty(@NotNull RefEntity element2) {
        this.myExcludedElements.remove(element2);
    }

    @Override
    public void exclude(@NotNull RefEntity element2) {
        this.myExcludedElements.put(element2, (CommonProblemDescriptor[])this.myProblemElements.getOrDefault(element2, (CommonProblemDescriptor[])CommonProblemDescriptor.EMPTY_ARRAY));
    }

    @Override
    public void amnesty(@NotNull CommonProblemDescriptor descriptor2) {
        this.myExcludedElements.removeValue(descriptor2);
    }

    @Override
    public void exclude(@NotNull CommonProblemDescriptor descriptor2) {
        RefEntity entity = (RefEntity)ObjectUtils.chooseNotNull((Object)this.myProblemElements.getKeyFor(descriptor2), (Object)this.myResolvedElements.getKeyFor(descriptor2));
        if (entity != null) {
            this.myExcludedElements.put(entity, (CommonProblemDescriptor[])new CommonProblemDescriptor[]{descriptor2});
        }
    }

    @Override
    public void suppressProblem(@NotNull CommonProblemDescriptor descriptor2) {
        RefEntity removed = this.myProblemElements.removeValue(descriptor2);
        if (removed != null) {
            this.mySuppressedElements.put(removed, (CommonProblemDescriptor[])new CommonProblemDescriptor[]{descriptor2});
        }
    }

    @Override
    public void suppressProblem(@NotNull RefEntity entity) {
        CommonProblemDescriptor[] removed = this.myProblemElements.remove(entity);
        if (removed != null) {
            this.mySuppressedElements.put(entity, (CommonProblemDescriptor[])removed);
        }
    }

    @Override
    public synchronized void updateContent() {
        this.myContents.clear();
        this.updateProblemElements();
    }

    protected void updateProblemElements() {
        Object elements2;
        if (this.filterResolvedItems()) {
            elements2 = this.getProblemElements().keys().stream().filter(entity -> !this.isExcluded((RefEntity)entity)).collect(Collectors.toSet());
        } else {
            elements2 = new THashSet(this.getProblemElements().keys());
            elements2.addAll(this.getResolvedElements());
            elements2.addAll(this.mySuppressedElements.keys());
        }
        Iterator iterator2 = elements2.iterator();
        while (iterator2.hasNext()) {
            RefEntity element2 = (RefEntity)iterator2.next();
            String groupName = element2 instanceof RefElement ? element2.getRefManager().getGroupName((RefElement)element2) : element2.getQualifiedName();
            this.registerContentEntry(element2, groupName);
        }
    }

    protected boolean filterResolvedItems() {
        return false;
    }

    protected void registerContentEntry(RefEntity element2, String packageName) {
        GlobalReportedProblemFilter globalReportedProblemFilter = this.myContext.getGlobalReportedProblemFilter();
        if (globalReportedProblemFilter == null || globalReportedProblemFilter.shouldReportProblem(element2, this.getToolWrapper().getShortName())) {
            Set content2 = this.myContents.computeIfAbsent(packageName, k -> new HashSet());
            content2.add(element2);
        }
    }

    public void addProblemElement(@Nullable RefEntity refElement, CommonProblemDescriptor ... descriptions) {
        this.addProblemElement(refElement, true, descriptions);
    }

    @Override
    public void addProblemElement(@Nullable RefEntity refElement, boolean filterSuppressed, CommonProblemDescriptor ... descriptors) {
        if (refElement == null || descriptors.length == 0) {
            return;
        }
        ReportedProblemFilter filter2 = this.myContext.getReportedProblemFilter();
        if (filter2 != null && !filter2.shouldReportProblem(refElement, descriptors)) {
            return;
        }
        DefaultInspectionToolResultExporter.checkFromSameFile(refElement, descriptors);
        if (filterSuppressed) {
            if (this.myContext.getOutputPath() == null || !(this.myToolWrapper instanceof LocalInspectionToolWrapper) || this instanceof AggregateResultsExporter) {
                this.myProblemElements.put(refElement, (CommonProblemDescriptor[])descriptors);
            } else {
                try {
                    this.writeOutput(descriptors, refElement);
                }
                catch (IOException e) {
                    LOG.error((Throwable)e);
                }
            }
        } else {
            this.myProblemElements.put(refElement, (CommonProblemDescriptor[])descriptors);
        }
    }

    private static void checkFromSameFile(RefEntity element2, CommonProblemDescriptor[] descriptors) {
        if (!(element2 instanceof RefElement)) {
            return;
        }
        SmartPsiElementPointer pointer = ((RefElement)element2).getPointer();
        if (pointer == null) {
            return;
        }
        VirtualFile entityFile = DefaultInspectionToolResultExporter.ensureNotInjectedFile(pointer.getVirtualFile());
        if (entityFile == null) {
            return;
        }
        for (CommonProblemDescriptor d : descriptors) {
            VirtualFile file2;
            if (!(d instanceof ProblemDescriptorBase) || (file2 = ((ProblemDescriptorBase)d).getContainingFile()) == null) continue;
            LOG.assertTrue(DefaultInspectionToolResultExporter.ensureNotInjectedFile(file2).equals(entityFile), (Object)("descriptor and containing entity files should be the same; descriptor: " + d.getDescriptionTemplate()));
        }
    }

    @Contract(value="null -> null")
    private static VirtualFile ensureNotInjectedFile(VirtualFile file2) {
        return file2 instanceof VirtualFileWindow ? ((VirtualFileWindow)file2).getDelegate() : file2;
    }

    @Override
    @NotNull
    public Collection<CommonProblemDescriptor> getProblemDescriptors() {
        return this.myProblemElements.getValues();
    }

    public void resolveProblem(@NotNull CommonProblemDescriptor descriptor2) {
        RefEntity entity = this.myProblemElements.removeValue(descriptor2);
        if (entity != null) {
            this.myResolvedElements.put(entity, (CommonProblemDescriptor[])new CommonProblemDescriptor[]{descriptor2});
        }
    }

    @Override
    public boolean isProblemResolved(@Nullable CommonProblemDescriptor descriptor2) {
        return this.myResolvedElements.containsValue(descriptor2);
    }

    @Override
    public boolean isProblemResolved(@Nullable RefEntity entity) {
        return this.myResolvedElements.containsKey(entity) && !this.myProblemElements.containsKey(entity);
    }

    @Override
    @NotNull
    public Collection<RefEntity> getResolvedElements() {
        return this.myResolvedElements.keys();
    }

    @Override
    public CommonProblemDescriptor @NotNull [] getResolvedProblems(@NotNull RefEntity entity) {
        return this.myResolvedElements.getOrDefault(entity, (CommonProblemDescriptor[])CommonProblemDescriptor.EMPTY_ARRAY);
    }

    @Override
    public synchronized boolean hasReportedProblems() {
        return !this.myContents.isEmpty();
    }

    @Override
    @NotNull
    public Map<String, Set<RefEntity>> getContent() {
        return this.myContents;
    }
}

