/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template.postfix.templates;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.template.postfix.templates.PostfixTemplate;
import com.intellij.codeInsight.template.postfix.templates.PostfixTemplateExpressionSelector;
import com.intellij.codeInsight.template.postfix.templates.PostfixTemplateProvider;
import com.intellij.codeInsight.template.postfix.templates.PostfixTemplatesUtils;
import com.intellij.codeInsight.unwrap.ScopeHighlighter;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.Pass;
import com.intellij.psi.PsiElement;
import com.intellij.refactoring.IntroduceTargetChooser;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PostfixTemplateWithExpressionSelector
extends PostfixTemplate {
    @NotNull
    private final PostfixTemplateExpressionSelector mySelector;

    @Deprecated
    protected PostfixTemplateWithExpressionSelector(@NotNull String name, @NotNull String key, @NotNull String example, @NotNull PostfixTemplateExpressionSelector selector) {
        this(null, name, key, example, selector, null);
    }

    @Deprecated
    protected PostfixTemplateWithExpressionSelector(@NotNull String name, @NotNull String example, @NotNull PostfixTemplateExpressionSelector selector) {
        this(null, name, example, selector, null);
    }

    protected PostfixTemplateWithExpressionSelector(@Nullable String id2, @NotNull String name, @NotNull String example, @NotNull PostfixTemplateExpressionSelector selector, @Nullable PostfixTemplateProvider provider) {
        super(id2, name, example, provider);
        this.mySelector = selector;
    }

    protected PostfixTemplateWithExpressionSelector(@Nullable String id2, @NotNull String name, @NotNull String key, @NotNull String example, @NotNull PostfixTemplateExpressionSelector selector, @Nullable PostfixTemplateProvider provider) {
        super(id2, name, key, example, provider);
        this.mySelector = selector;
    }

    @Override
    public final boolean isApplicable(@NotNull PsiElement context, @NotNull Document copyDocument, int newOffset) {
        return this.mySelector.hasExpression(context, copyDocument, newOffset);
    }

    @Override
    public final void expand(@NotNull PsiElement context, final @NotNull Editor editor) {
        List<PsiElement> expressions = this.mySelector.getExpressions(context, editor.getDocument(), editor.getCaretModel().getOffset());
        if (expressions.isEmpty()) {
            PostfixTemplatesUtils.showErrorHint(context.getProject(), editor);
            return;
        }
        if (expressions.size() == 1) {
            this.prepareAndExpandForChooseExpression(expressions.get(0), editor);
            return;
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            PsiElement item = (PsiElement)ContainerUtil.getFirstItem(expressions);
            assert (item != null);
            this.prepareAndExpandForChooseExpression(item, editor);
            return;
        }
        IntroduceTargetChooser.showChooser(editor, expressions, new Pass<PsiElement>(){

            public void pass(@NotNull PsiElement e) {
                PostfixTemplateWithExpressionSelector.this.prepareAndExpandForChooseExpression(e, editor);
            }
        }, this.mySelector.getRenderer(), CodeInsightBundle.message((String)"dialog.title.expressions", (Object[])new Object[0]), 0, ScopeHighlighter.NATURAL_RANGER);
    }

    protected void prepareAndExpandForChooseExpression(@NotNull PsiElement expression, @NotNull Editor editor) {
        ApplicationManager.getApplication().runWriteAction(() -> CommandProcessor.getInstance().executeCommand(expression.getProject(), () -> this.expandForChooseExpression(expression, editor), CodeInsightBundle.message((String)"command.expand.postfix.template", (Object[])new Object[0]), (Object)"POSTFIX_TEMPLATE_ID"));
    }

    @Override
    public boolean startInWriteAction() {
        return false;
    }

    protected abstract void expandForChooseExpression(@NotNull PsiElement var1, @NotNull Editor var2);
}

