/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template.postfix.templates;

import com.intellij.codeInsight.template.postfix.templates.LanguagePostfixTemplate;
import com.intellij.codeInsight.template.postfix.templates.PostfixTemplate;
import com.intellij.codeInsight.template.postfix.templates.PostfixTemplateProvider;
import com.intellij.internal.statistic.eventLog.FeatureUsageData;
import com.intellij.internal.statistic.eventLog.validator.ValidationResultType;
import com.intellij.internal.statistic.eventLog.validator.rules.EventContext;
import com.intellij.internal.statistic.eventLog.validator.rules.impl.CustomValidationRule;
import com.intellij.internal.statistic.service.fus.collectors.FUCounterUsageLogger;
import com.intellij.internal.statistic.utils.PluginInfo;
import com.intellij.internal.statistic.utils.PluginInfoDetectorKt;
import com.intellij.lang.Language;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PostfixTemplateLogger {
    private static final String USAGE_GROUP = "completion.postfix";
    private static final String CUSTOM = "custom";
    private static final String NO_PROVIDER = "no.provider";
    private static final String TEMPLATE_FIELD = "template";
    private static final String PROVIDER_FIELD = "provider";

    static void log(@NotNull PostfixTemplate template, @NotNull PsiElement context) {
        Project project = context.getProject();
        FeatureUsageData data2 = new FeatureUsageData().addLanguage(context.getLanguage());
        if (template.isBuiltin()) {
            PostfixTemplateProvider provider = template.getProvider();
            String providerId = provider != null ? provider.getId() : NO_PROVIDER;
            data2.addData(PROVIDER_FIELD, providerId).addData(TEMPLATE_FIELD, template.getId());
        } else {
            data2.addData(PROVIDER_FIELD, CUSTOM).addData(TEMPLATE_FIELD, CUSTOM);
        }
        FUCounterUsageLogger.getInstance().logEvent(project, USAGE_GROUP, "expanded", data2);
    }

    public static class PostfixTemplateValidator
    extends CustomValidationRule {
        public boolean acceptRuleId(@Nullable String ruleId) {
            return "completion_template".equals(ruleId) || "completion_provider_template".equals(ruleId);
        }

        @NotNull
        protected ValidationResultType doValidate(@NotNull String data2, @NotNull EventContext context) {
            if (StringUtil.equals((CharSequence)data2, (CharSequence)PostfixTemplateLogger.CUSTOM) || StringUtil.equals((CharSequence)data2, (CharSequence)PostfixTemplateLogger.NO_PROVIDER)) {
                return ValidationResultType.ACCEPTED;
            }
            Language lang = this.getLanguage(context);
            if (lang == null) {
                return ValidationResultType.REJECTED;
            }
            String provider = this.getEventDataField(context, PostfixTemplateLogger.PROVIDER_FIELD);
            String template = this.getEventDataField(context, PostfixTemplateLogger.TEMPLATE_FIELD);
            if (provider == null || template == null || !PostfixTemplateValidator.isProviderOrTemplate(data2, provider, template)) {
                return ValidationResultType.REJECTED;
            }
            Pair<PostfixTemplate, PostfixTemplateProvider> result2 = PostfixTemplateValidator.findPostfixTemplate(lang, provider, template);
            if (result2.getFirst() != null && result2.getSecond() != null) {
                PluginInfo templateInfo = PluginInfoDetectorKt.getPluginInfo(((PostfixTemplate)result2.getFirst()).getClass());
                PluginInfo providerInfo = PluginInfoDetectorKt.getPluginInfo(((PostfixTemplateProvider)result2.getSecond()).getClass());
                context.setPluginInfo(templateInfo);
                return templateInfo.isDevelopedByJetBrains() && providerInfo.isDevelopedByJetBrains() ? ValidationResultType.ACCEPTED : ValidationResultType.THIRD_PARTY;
            }
            return ValidationResultType.REJECTED;
        }

        private static boolean isProviderOrTemplate(@NotNull String data2, @NotNull String provider, @NotNull String template) {
            return StringUtil.equals((CharSequence)data2, (CharSequence)provider) || StringUtil.equals((CharSequence)data2, (CharSequence)template);
        }

        @NotNull
        private static Pair<PostfixTemplate, PostfixTemplateProvider> findPostfixTemplate(@NotNull Language lang, @NotNull String providerId, @NotNull String templateId) {
            if (!StringUtil.equals((CharSequence)providerId, (CharSequence)PostfixTemplateLogger.NO_PROVIDER)) {
                PostfixTemplateProvider provider = PostfixTemplateValidator.findProviderById(providerId, lang);
                PostfixTemplate template = provider != null ? PostfixTemplateValidator.findTemplateById(provider, templateId) : null;
                return provider != null && template != null ? Pair.create((Object)template, (Object)provider) : Pair.empty();
            }
            for (PostfixTemplateProvider provider : LanguagePostfixTemplate.LANG_EP.allForLanguage(lang)) {
                PostfixTemplate template = PostfixTemplateValidator.findTemplateById(provider, templateId);
                if (template == null) continue;
                return Pair.create((Object)template, (Object)provider);
            }
            return Pair.empty();
        }

        @Nullable
        private static PostfixTemplateProvider findProviderById(@NotNull String id2, @NotNull Language lang) {
            for (PostfixTemplateProvider provider : LanguagePostfixTemplate.LANG_EP.allForLanguage(lang)) {
                if (!StringUtil.equals((CharSequence)provider.getId(), (CharSequence)id2)) continue;
                return provider;
            }
            return null;
        }

        @Nullable
        private static PostfixTemplate findTemplateById(@NotNull PostfixTemplateProvider provider, @NotNull String id2) {
            for (PostfixTemplate template : provider.getTemplates()) {
                if (!StringUtil.equals((CharSequence)template.getId(), (CharSequence)id2)) continue;
                return template;
            }
            return null;
        }
    }
}

