/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template.macro;

import com.google.common.annotations.VisibleForTesting;
import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.ExpressionContext;
import com.intellij.codeInsight.template.Result;
import com.intellij.codeInsight.template.TextResult;
import com.intellij.codeInsight.template.macro.MacroBase;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.codeStyle.NameUtil;
import org.jetbrains.annotations.NotNull;

public abstract class SplitWordsMacro
extends MacroBase {
    private final char mySeparator;

    private SplitWordsMacro(String name, String description, char separator) {
        super(name, description);
        this.mySeparator = separator;
    }

    @Override
    protected Result calculateResult(Expression @NotNull [] params, ExpressionContext context, boolean quick) {
        String text = SplitWordsMacro.getTextResult(params, context, true);
        return text != null ? new TextResult(!text.isEmpty() ? this.convertString(text) : "") : null;
    }

    @VisibleForTesting
    public String convertString(String text) {
        return NameUtil.splitWords((String)text, (char)this.mySeparator, this::convertCase);
    }

    @NotNull
    protected abstract String convertCase(@NotNull String var1);

    public static class SpaceSeparated
    extends SplitWordsMacro {
        public SpaceSeparated() {
            super("spaceSeparated", "spaceSeparated(String)", ' ');
        }

        @Override
        @NotNull
        protected String convertCase(@NotNull String word) {
            return word;
        }
    }

    public static class LowercaseAndDash
    extends SplitWordsMacro {
        public LowercaseAndDash() {
            super("lowercaseAndDash", "lowercaseAndDash(String)", '-');
        }

        @Override
        @NotNull
        protected String convertCase(@NotNull String word) {
            return StringUtil.toLowerCase((String)word);
        }
    }

    public static class SnakeCaseMacro
    extends SplitWordsMacro {
        public SnakeCaseMacro() {
            super("snakeCase", "snakeCase(String)", '_');
        }

        @Override
        @NotNull
        protected String convertCase(@NotNull String word) {
            return StringUtil.toLowerCase((String)word);
        }
    }
}

