/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template.macro;

import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.ExpressionContext;
import com.intellij.codeInsight.template.Result;
import com.intellij.codeInsight.template.TextResult;
import com.intellij.codeInsight.template.macro.MacroBase;
import com.intellij.lang.Commenter;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageCommenters;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.util.PsiUtilBase;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CommentMacro
extends MacroBase {
    private final Function<? super Commenter, String> myCommenterFunction;

    protected CommentMacro(String name, Function<? super Commenter, String> commenterFunction) {
        super(name, name + "()");
        this.myCommenterFunction = commenterFunction;
    }

    @Override
    @Nullable
    protected Result calculateResult(Expression @NotNull [] params, ExpressionContext context, boolean quick) {
        Editor editor = context.getEditor();
        Language language = editor == null ? null : PsiUtilBase.getLanguageInEditor((Editor)editor, (Project)context.getProject());
        Commenter commenter = language == null ? null : (Commenter)LanguageCommenters.INSTANCE.forLanguage(language);
        String lineCommentPrefix = commenter == null ? null : this.myCommenterFunction.apply((Commenter)commenter);
        return lineCommentPrefix == null ? null : new TextResult(lineCommentPrefix.trim());
    }

    public static class AnyCommentEnd
    extends CommentMacro {
        public AnyCommentEnd() {
            super("commentEnd", (? super Commenter commenter) -> {
                String line = commenter.getLineCommentPrefix();
                return StringUtil.isNotEmpty((String)line) ? "" : commenter.getBlockCommentSuffix();
            });
        }
    }

    public static class AnyCommentStart
    extends CommentMacro {
        public AnyCommentStart() {
            super("commentStart", (? super Commenter commenter) -> {
                String line = commenter.getLineCommentPrefix();
                return StringUtil.isNotEmpty((String)line) ? line : commenter.getBlockCommentPrefix();
            });
        }
    }

    public static class BlockCommentEnd
    extends CommentMacro {
        public BlockCommentEnd() {
            super("blockCommentEnd", Commenter::getBlockCommentSuffix);
        }
    }

    public static class BlockCommentStart
    extends CommentMacro {
        public BlockCommentStart() {
            super("blockCommentStart", Commenter::getBlockCommentPrefix);
        }
    }

    public static class LineCommentStart
    extends CommentMacro {
        public LineCommentStart() {
            super("lineCommentStart", Commenter::getLineCommentPrefix);
        }
    }
}

