/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template.impl;

import com.intellij.codeInsight.template.impl.TemplateGroup;
import com.intellij.codeInsight.template.impl.TemplateImpl;
import com.intellij.codeInsight.template.impl.TemplateSettings;
import com.intellij.ide.ui.OptionsSearchTopHitProvider;
import com.intellij.ide.ui.search.BooleanOptionDescription;
import com.intellij.ide.ui.search.OptionDescription;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;

final class LiveTemplatesOptionsTopHitProvider
implements OptionsSearchTopHitProvider.ApplicationLevelProvider {
    LiveTemplatesOptionsTopHitProvider() {
    }

    @Override
    @NotNull
    public String getId() {
        return "templates";
    }

    @Override
    @NotNull
    public Collection<OptionDescription> getOptions() {
        TemplateSettings settings = TemplateSettings.getInstance();
        if (settings == null) {
            return Collections.emptyList();
        }
        ArrayList<Option> options2 = new ArrayList<Option>();
        for (TemplateGroup group : settings.getTemplateGroups()) {
            for (TemplateImpl element2 : group.getElements()) {
                options2.add(new Option(element2));
            }
        }
        return Collections.unmodifiableCollection(options2);
    }

    private static final class Option
    extends BooleanOptionDescription {
        private final TemplateImpl myElement;

        private Option(TemplateImpl element2) {
            super(Option.getOptionName(element2), "editing.templates");
            this.myElement = element2;
        }

        public boolean isOptionEnabled() {
            return !this.myElement.isDeactivated();
        }

        public void setOptionState(boolean enabled) {
            this.myElement.setDeactivated(!enabled);
        }

        private static String getOptionName(TemplateImpl element2) {
            StringBuilder sb = new StringBuilder().append(element2.getGroupName()).append(": ").append(element2.getKey());
            String description = element2.getDescription();
            if (description != null) {
                sb.append(" (").append(description).append(")");
            }
            return sb.toString();
        }
    }
}

