/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template.impl;

import com.intellij.codeInsight.template.impl.TemplateContext;
import com.intellij.codeInsight.template.impl.TemplateGroup;
import com.intellij.codeInsight.template.impl.TemplateImpl;
import com.intellij.codeInsight.template.impl.TemplateListPanel;
import com.intellij.codeInsight.template.impl.TemplateSettings;
import com.intellij.ide.CopyProvider;
import com.intellij.ide.PasteProvider;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.CheckboxTree;
import com.intellij.ui.CheckedTreeNode;
import com.intellij.ui.SpeedSearchComparator;
import com.intellij.ui.TreeSpeedSearch;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.SystemProperties;
import com.intellij.util.containers.Convertor;
import java.awt.GraphicsEnvironment;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.util.Collections;
import java.util.Set;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class LiveTemplateTree
extends CheckboxTree
implements DataProvider,
CopyProvider,
PasteProvider {
    private final TemplateListPanel myConfigurable;

    LiveTemplateTree(CheckboxTree.CheckboxTreeCellRenderer renderer, CheckedTreeNode root, TemplateListPanel configurable2) {
        super(renderer, root);
        this.myConfigurable = configurable2;
        if (!GraphicsEnvironment.isHeadless()) {
            this.setDragEnabled(true);
        }
    }

    protected void onNodeStateChanged(CheckedTreeNode node) {
        Object obj = node.getUserObject();
        if (obj instanceof TemplateImpl) {
            ((TemplateImpl)obj).setDeactivated(!node.isChecked());
        }
    }

    @Override
    protected void installSpeedSearch() {
        new TreeSpeedSearch((Tree)this, (Convertor<? super TreePath, String>)((Convertor)o -> {
            Object object = ((DefaultMutableTreeNode)o.getLastPathComponent()).getUserObject();
            if (object instanceof TemplateGroup) {
                return ((TemplateGroup)object).getName();
            }
            if (object instanceof TemplateImpl) {
                TemplateImpl template = (TemplateImpl)object;
                return StringUtil.notNullize((String)template.getGroupName()) + " " + StringUtil.notNullize((String)template.getKey()) + " " + StringUtil.notNullize((String)template.getDescription()) + " " + template.getTemplateText();
            }
            return "";
        }), true).setComparator(new SubstringSpeedSearchComparator());
    }

    @Nullable
    public Object getData(@NotNull @NonNls String dataId) {
        if (PlatformDataKeys.COPY_PROVIDER.is(dataId) || PlatformDataKeys.PASTE_PROVIDER.is(dataId)) {
            return this;
        }
        return null;
    }

    public void performCopy(@NotNull DataContext dataContext) {
        Set<TemplateImpl> templates = this.myConfigurable.getSelectedTemplates().keySet();
        TemplateSettings templateSettings = TemplateSettings.getInstance();
        CopyPasteManager.getInstance().setContents((Transferable)new StringSelection(StringUtil.join(templates, template -> JDOMUtil.writeElement((Element)TemplateSettings.serializeTemplate(template, templateSettings.getDefaultTemplate((TemplateImpl)template), TemplateContext.getIdToType())), (String)SystemProperties.getLineSeparator())));
    }

    public boolean isCopyEnabled(@NotNull DataContext dataContext) {
        return !this.myConfigurable.getSelectedTemplates().isEmpty();
    }

    public boolean isCopyVisible(@NotNull DataContext dataContext) {
        return this.isCopyEnabled(dataContext);
    }

    public boolean isPastePossible(@NotNull DataContext dataContext) {
        if (this.myConfigurable.getSingleContextGroup() == null) {
            return false;
        }
        String s = (String)CopyPasteManager.getInstance().getContents(DataFlavor.stringFlavor);
        return s != null && s.trim().startsWith("<template ");
    }

    public boolean isPasteEnabled(@NotNull DataContext dataContext) {
        return this.isPastePossible(dataContext);
    }

    public void performPaste(@NotNull DataContext dataContext) {
        TemplateGroup group = this.myConfigurable.getSingleContextGroup();
        assert (group != null);
        String buffer = (String)CopyPasteManager.getInstance().getContents(DataFlavor.stringFlavor);
        assert (buffer != null);
        try {
            for (Element templateElement : JDOMUtil.load((CharSequence)("<root>" + buffer + "</root>")).getChildren("template")) {
                TemplateImpl template = TemplateSettings.readTemplateFromElement(group.getName(), templateElement, ((Object)((Object)this)).getClass().getClassLoader());
                while (group.containsTemplate(template.getKey(), template.getId())) {
                    template.setKey(template.getKey() + "1");
                    if (template.getId() == null) continue;
                    template.setId(template.getId() + "1");
                }
                this.myConfigurable.addTemplate(template);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static class SubstringSpeedSearchComparator
    extends SpeedSearchComparator {
        private SubstringSpeedSearchComparator() {
        }

        @Override
        public int matchingDegree(String pattern, String text) {
            return this.matchingFragments(pattern, text) != null ? 1 : 0;
        }

        @Override
        @Nullable
        public Iterable<TextRange> matchingFragments(@NotNull String pattern, @NotNull String text) {
            int index = StringUtil.indexOfIgnoreCase((String)text, (String)pattern, (int)0);
            return index >= 0 ? Collections.singleton(TextRange.from((int)index, (int)pattern.length())) : null;
        }
    }
}

