/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template;

import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateActionContext;
import com.intellij.codeInsight.template.TemplateContextType;
import com.intellij.codeInsight.template.TemplateEditingListener;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.codeInsight.template.impl.TemplateImpl;
import com.intellij.codeInsight.template.impl.TemplateManagerImpl;
import com.intellij.codeInsight.template.impl.TemplateSettings;
import com.intellij.diagnostic.AttachmentFactory;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CustomTemplateCallback {
    private static final Logger LOGGER = Logger.getInstance(CustomTemplateCallback.class);
    private final TemplateManager myTemplateManager;
    @NotNull
    private final Editor myEditor;
    @NotNull
    private final PsiFile myFile;
    private final int myOffset;
    @NotNull
    private final Project myProject;
    private final boolean myInInjectedFragment;
    protected Set<TemplateContextType> myApplicableContextTypes;

    public CustomTemplateCallback(@NotNull Editor editor, @NotNull PsiFile file2) {
        this.myProject = file2.getProject();
        this.myTemplateManager = TemplateManager.getInstance(this.myProject);
        int parentEditorOffset = CustomTemplateCallback.getOffset(editor);
        PsiElement element2 = InjectedLanguageManager.getInstance((Project)file2.getProject()).findInjectedElementAt(file2, parentEditorOffset);
        this.myFile = element2 != null ? element2.getContainingFile() : file2;
        this.myInInjectedFragment = InjectedLanguageManager.getInstance((Project)this.myProject).isInjectedFragment(this.myFile);
        this.myEditor = this.myInInjectedFragment ? InjectedLanguageUtil.getEditorForInjectedLanguageNoCommit(editor, file2, parentEditorOffset) : editor;
        this.myOffset = this.myInInjectedFragment ? CustomTemplateCallback.getOffset(this.myEditor) : parentEditorOffset;
    }

    public TemplateManager getTemplateManager() {
        return this.myTemplateManager;
    }

    @NotNull
    public PsiFile getFile() {
        return this.myFile;
    }

    @NotNull
    public PsiElement getContext() {
        return CustomTemplateCallback.getContext(this.myFile, this.getOffset(), this.myInInjectedFragment);
    }

    public int getOffset() {
        return this.myOffset;
    }

    public static int getOffset(@NotNull Editor editor) {
        SelectionModel selectionModel = editor.getSelectionModel();
        return selectionModel.hasSelection() ? selectionModel.getSelectionStart() : Math.max(editor.getCaretModel().getOffset() - 1, 0);
    }

    @Nullable
    public TemplateImpl findApplicableTemplate(@NotNull String key) {
        return (TemplateImpl)ContainerUtil.getFirstItem(this.findApplicableTemplates(key));
    }

    @NotNull
    public List<TemplateImpl> findApplicableTemplates(@NotNull String key) {
        ArrayList<TemplateImpl> result2 = new ArrayList<TemplateImpl>();
        for (TemplateImpl candidate : CustomTemplateCallback.getMatchingTemplates(key)) {
            if (!this.isAvailableTemplate(candidate)) continue;
            result2.add(candidate);
        }
        return result2;
    }

    private boolean isAvailableTemplate(@NotNull TemplateImpl template) {
        if (this.myApplicableContextTypes == null) {
            this.myApplicableContextTypes = TemplateManagerImpl.getApplicableContextTypes(TemplateActionContext.create((PsiFile)this.myFile, (Editor)this.myEditor, (int)this.myOffset, (int)this.myOffset, (boolean)false));
        }
        return !template.isDeactivated() && TemplateManagerImpl.isApplicable(template, this.myApplicableContextTypes);
    }

    public void startTemplate(@NotNull Template template, Map<String, String> predefinedValues, TemplateEditingListener listener2) {
        if (this.myInInjectedFragment) {
            template.setToReformat(false);
        }
        this.myTemplateManager.startTemplate(this.myEditor, template, false, predefinedValues, listener2);
    }

    @NotNull
    private static List<TemplateImpl> getMatchingTemplates(@NotNull String templateKey) {
        TemplateSettings settings = TemplateSettings.getInstance();
        ArrayList<TemplateImpl> candidates = new ArrayList<TemplateImpl>();
        for (TemplateImpl template : settings.getTemplates(templateKey)) {
            if (template.isDeactivated()) continue;
            candidates.add(template);
        }
        return candidates;
    }

    @NotNull
    public Editor getEditor() {
        return this.myEditor;
    }

    @NotNull
    public FileType getFileType() {
        return this.myFile.getFileType();
    }

    @NotNull
    public Project getProject() {
        return this.myProject;
    }

    public void deleteTemplateKey(@NotNull String key) {
        int caretAt = this.myEditor.getCaretModel().getOffset();
        int templateStart = caretAt - key.length();
        this.myEditor.getDocument().deleteString(templateStart, caretAt);
        this.myEditor.getCaretModel().moveToOffset(templateStart);
        this.myEditor.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
        this.myEditor.getSelectionModel().removeSelection();
    }

    @NotNull
    public static PsiElement getContext(@NotNull PsiFile file2, int offset) {
        return CustomTemplateCallback.getContext(file2, offset, true);
    }

    @NotNull
    public static PsiElement getContext(@NotNull PsiFile file2, int offset, boolean searchInInjectedFragment) {
        PsiElement element2 = null;
        if (searchInInjectedFragment && !InjectedLanguageManager.getInstance((Project)file2.getProject()).isInjectedFragment(file2)) {
            PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)file2.getProject());
            Document document = documentManager.getDocument(file2);
            if (document != null && !documentManager.isCommitted(document)) {
                LOGGER.error("Trying to access to injected template context on uncommited document, offset = " + offset, new Attachment[]{AttachmentFactory.createAttachment(file2.getVirtualFile())});
            } else {
                element2 = InjectedLanguageManager.getInstance((Project)file2.getProject()).findInjectedElementAt(file2, offset);
            }
        }
        if (element2 == null) {
            element2 = PsiUtilCore.getElementAtOffset((PsiFile)file2, (int)offset);
        }
        return element2;
    }

    public boolean isInInjectedFragment() {
        return this.myInInjectedFragment;
    }
}

