/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.navigation.actions;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.TargetElementUtil;
import com.intellij.codeInsight.hint.HintManager;
import com.intellij.codeInsight.navigation.actions.GotoDeclarationAction;
import com.intellij.codeInsight.navigation.impl.CommonKt;
import com.intellij.ide.IdeEventQueue;
import com.intellij.lang.LanguageNamesValidation;
import com.intellij.lang.refactoring.NamesValidator;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.awt.AWTEvent;
import java.awt.event.MouseEvent;
import kotlin.Metadata;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=2, d1={"\u0000.\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\u001a \u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0000\u001a \u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\rH\u0002\u001a\b\u0010\u000e\u001a\u00020\tH\u0002\u001a \u0010\u000f\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0000\u001a(\u0010\u0010\u001a\u00020\u00012\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\rH\u0000\u00a8\u0006\u0011"}, d2={"gotoTarget", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lcom/intellij/psi/PsiFile;", "navigatable", "Lcom/intellij/pom/Navigatable;", "isKeywordUnderCaret", "", "project", "Lcom/intellij/openapi/project/Project;", "offset", "", "isUnderDoubleClick", "navigateToLookupItem", "notifyNowhereToGo", "intellij.platform.lang.impl"})
public final class UiKt {
    public static final boolean navigateToLookupItem(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file2) {
        PsiElement psiElement;
        block3: {
            block2: {
                psiElement = TargetElementUtil.getTargetElementFromLookup(project);
                if (psiElement == null) break block2;
                PsiElement psiElement2 = psiElement;
                boolean bl = false;
                boolean bl2 = false;
                PsiElement p1 = psiElement2;
                boolean bl3 = false;
                psiElement = CommonKt.gtdTargetNavigatable(p1);
                if (psiElement != null) break block3;
            }
            return false;
        }
        PsiElement navigatable = psiElement;
        UiKt.gotoTarget(editor, file2, (Navigatable)navigatable);
        return true;
    }

    public static final void gotoTarget(@NotNull Editor editor, @NotNull PsiFile file2, @NotNull Navigatable navigatable) {
        if (navigatable instanceof PsiElement && GotoDeclarationAction.navigateInCurrentEditor((PsiElement)navigatable, file2, editor)) {
            return;
        }
        if (navigatable.canNavigate()) {
            navigatable.navigate(true);
        }
    }

    public static final void notifyNowhereToGo(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file2, int offset) {
        if (!UiKt.isUnderDoubleClick() && !UiKt.isKeywordUnderCaret(project, file2, offset)) {
            HintManager.getInstance().showErrorHint(editor, CodeInsightBundle.message((String)"declaration.navigation.nowhere.to.go", (Object[])new Object[0]));
        }
    }

    private static final boolean isUnderDoubleClick() {
        AWTEvent event = IdeEventQueue.getInstance().getTrueCurrentEvent();
        return event instanceof MouseEvent && ((MouseEvent)event).getClickCount() == 2;
    }

    private static final boolean isKeywordUnderCaret(Project project, PsiFile file2, int offset) {
        PsiElement psiElement = file2.findElementAt(offset);
        if (psiElement == null) {
            return false;
        }
        PsiElement elementAtCaret = psiElement;
        NamesValidator namesValidator = LanguageNamesValidation.INSTANCE.forLanguage(elementAtCaret.getLanguage());
        return namesValidator.isKeyword(elementAtCaret.getText(), project);
    }
}

