/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.navigation.actions;

import com.intellij.codeInsight.CodeInsightActionHandler;
import com.intellij.codeInsight.TargetElementUtil;
import com.intellij.codeInsight.actions.BaseCodeInsightAction;
import com.intellij.codeInsight.navigation.CtrlMouseAction;
import com.intellij.codeInsight.navigation.CtrlMouseInfo;
import com.intellij.codeInsight.navigation.GotoImplementationHandler;
import com.intellij.codeInsight.navigation.ImplementationSearcher;
import com.intellij.codeInsight.navigation.MultipleTargetElementsInfo;
import com.intellij.codeInsight.navigation.SingleTargetElementInfo;
import com.intellij.ide.util.EditSourceUtil;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.editor.Editor;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.DefinitionsScopedSearch;
import com.intellij.psi.util.PsiUtilCore;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GotoImplementationAction
extends BaseCodeInsightAction
implements CtrlMouseAction {
    @NotNull
    protected CodeInsightActionHandler getHandler() {
        return new GotoImplementationHandler();
    }

    @Override
    protected boolean isValidForLookup() {
        return true;
    }

    @Override
    public void update(@NotNull AnActionEvent event) {
        if (!DefinitionsScopedSearch.INSTANCE.hasAnyExecutors()) {
            event.getPresentation().setVisible(false);
        } else {
            super.update(event);
        }
    }

    @Override
    @Nullable
    public CtrlMouseInfo getCtrlMouseInfo(@NotNull Editor editor, @NotNull PsiFile file2, int offset) {
        PsiElement elementAtPointer = file2.findElementAt(offset);
        if (elementAtPointer == null) {
            return null;
        }
        PsiElement element2 = TargetElementUtil.getInstance().findTargetElement(editor, ImplementationSearcher.getFlags(), offset);
        PsiElement[] targetElements = new ImplementationSearcher(){

            @Override
            protected PsiElement @NotNull [] searchDefinitions(PsiElement element2, Editor editor) {
                ArrayList found = new ArrayList(2);
                DefinitionsScopedSearch.search((PsiElement)element2, (SearchScope)1.getSearchScope(element2, editor)).forEach(psiElement -> {
                    found.add(psiElement);
                    return found.size() != 2;
                });
                return PsiUtilCore.toPsiElementArray(found);
            }
        }.searchImplementations(editor, element2, offset);
        if (targetElements == null || targetElements.length == 0) {
            return null;
        }
        if (targetElements.length > 1) {
            return new MultipleTargetElementsInfo(elementAtPointer);
        }
        Navigatable descriptor2 = EditSourceUtil.getDescriptor((PsiElement)targetElements[0]);
        if (descriptor2 == null || !descriptor2.canNavigate()) {
            return null;
        }
        PsiElement targetElement = targetElements[0];
        if (targetElement == null || !targetElement.isPhysical()) {
            return null;
        }
        return new SingleTargetElementInfo(elementAtPointer, targetElement);
    }
}

