/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.navigation.action;

import com.intellij.codeInsight.TargetElementUtilBase;
import com.intellij.codeInsight.navigation.actions.GotoDeclarationHandler;
import com.intellij.diagnostic.PluginException;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class GotoDeclarationUtil {
    private static final Logger LOG = Logger.getInstance(GotoDeclarationUtil.class);

    public static @NotNull PsiElement @Nullable [] findTargetElementsFromProviders(@NotNull Editor editor, int offset, PsiFile file2) {
        PsiElement elementAt = file2.findElementAt(TargetElementUtilBase.adjustOffset(file2, editor.getDocument(), offset));
        return GotoDeclarationUtil.findTargetElementsFromProviders(elementAt, offset, editor);
    }

    public static @NotNull PsiElement @Nullable [] findTargetElementsFromProviders(@Nullable PsiElement elementAt, int offset, @NotNull Editor editor) {
        for (GotoDeclarationHandler handler2 : GotoDeclarationHandler.EP_NAME.getExtensionList()) {
            PsiElement[] result2 = handler2.getGotoDeclarationTargets(elementAt, offset, editor);
            if (result2 == null || result2.length <= 0) continue;
            return GotoDeclarationUtil.assertNotNullElements(result2, handler2.getClass()) ? result2 : null;
        }
        return PsiElement.EMPTY_ARRAY;
    }

    private static boolean assertNotNullElements(PsiElement @NotNull [] result2, Class<?> clazz) {
        for (PsiElement element2 : result2) {
            if (element2 != null) continue;
            PluginException.logPluginError((Logger)LOG, (String)("Null target element is returned by 'getGotoDeclarationTargets' in " + clazz.getName()), null, clazz);
            return false;
        }
        return true;
    }
}

