/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.navigation;

import com.intellij.codeInsight.documentation.DocumentationManager;
import com.intellij.codeInsight.navigation.BaseCtrlMouseInfo;
import com.intellij.codeInsight.navigation.CtrlMouseDocInfo;
import com.intellij.lang.documentation.DocumentationProvider;
import com.intellij.navigation.ItemPresentation;
import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.ElementDescriptionLocation;
import com.intellij.psi.ElementDescriptionUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ReferenceRange;
import com.intellij.usageView.UsageViewShortNameLocation;
import com.intellij.usageView.UsageViewTypeLocation;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public class SingleTargetElementInfo
extends BaseCtrlMouseInfo {
    @NotNull
    private final PsiElement myElementAtPointer;
    @NotNull
    private final PsiElement myTargetElement;

    public SingleTargetElementInfo(@NotNull PsiElement elementAtPointer, @NotNull PsiElement targetElement) {
        super(elementAtPointer);
        this.myElementAtPointer = elementAtPointer;
        this.myTargetElement = targetElement;
    }

    public SingleTargetElementInfo(@NotNull PsiReference reference2, @NotNull PsiElement targetElement) {
        super(ReferenceRange.getAbsoluteRanges((PsiReference)reference2));
        this.myElementAtPointer = reference2.getElement();
        this.myTargetElement = targetElement;
    }

    @Override
    @NotNull
    public CtrlMouseDocInfo getDocInfo() {
        return this.isValid() ? SingleTargetElementInfo.generateInfo(this.myTargetElement, this.myElementAtPointer, this.isNavigatable()) : CtrlMouseDocInfo.EMPTY;
    }

    @Override
    public boolean isValid() {
        return this.myTargetElement.isValid() && this.myElementAtPointer.isValid();
    }

    @Override
    public boolean isNavigatable() {
        return this.myTargetElement != this.myElementAtPointer && this.myTargetElement != this.myElementAtPointer.getParent();
    }

    @ApiStatus.Internal
    @NotNull
    public static CtrlMouseDocInfo generateInfo(PsiElement element2, PsiElement atPointer, boolean fallbackToBasicInfo) {
        DocumentationProvider documentationProvider = DocumentationManager.getProviderFromElement(element2, atPointer);
        String result2 = documentationProvider.getQuickNavigateInfo(element2, atPointer);
        if (result2 == null && fallbackToBasicInfo) {
            result2 = SingleTargetElementInfo.doGenerateInfo(element2);
        }
        return result2 == null ? CtrlMouseDocInfo.EMPTY : new CtrlMouseDocInfo(result2, atPointer, documentationProvider);
    }

    @Nullable
    private static String doGenerateInfo(@NotNull PsiElement element2) {
        ItemPresentation presentation2;
        VirtualFile virtualFile;
        if (element2 instanceof PsiFile && (virtualFile = ((PsiFile)element2).getVirtualFile()) != null) {
            return virtualFile.getPresentableUrl();
        }
        String info = SingleTargetElementInfo.getQuickNavigateInfo(element2);
        if (info != null) {
            return info;
        }
        if (element2 instanceof NavigationItem && (presentation2 = ((NavigationItem)element2).getPresentation()) != null) {
            return presentation2.getPresentableText();
        }
        return null;
    }

    @Nullable
    private static String getQuickNavigateInfo(PsiElement element2) {
        String name = ElementDescriptionUtil.getElementDescription((PsiElement)element2, (ElementDescriptionLocation)UsageViewShortNameLocation.INSTANCE);
        if (StringUtil.isEmpty((String)name)) {
            return null;
        }
        String typeName = ElementDescriptionUtil.getElementDescription((PsiElement)element2, (ElementDescriptionLocation)UsageViewTypeLocation.INSTANCE);
        PsiFile file2 = element2.getContainingFile();
        StringBuilder sb = new StringBuilder();
        if (StringUtil.isNotEmpty((String)typeName)) {
            sb.append(typeName).append(" ");
        }
        sb.append("\"").append(name).append("\"");
        if (file2 != null && file2.isPhysical()) {
            sb.append(" [").append(file2.getName()).append("]");
        }
        return sb.toString();
    }
}

