/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.lookup.impl;

import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.impl.EmptyLookupItem;
import com.intellij.codeInsight.lookup.impl.LookupImpl;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.MathUtil;
import java.util.Collection;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LookupOffsets
implements DocumentListener {
    @NotNull
    private String myAdditionalPrefix = "";
    private boolean myStableStart;
    @Nullable
    private Supplier<String> myStartMarkerDisposeInfo = null;
    @NotNull
    private RangeMarker myLookupStartMarker;
    private int myRemovedPrefix;
    private final RangeMarker myLookupOriginalStartMarker;
    private final Editor myEditor;

    public LookupOffsets(Editor editor) {
        this.myEditor = editor;
        int caret = this.getPivotOffset();
        this.myLookupOriginalStartMarker = this.createLeftGreedyMarker(caret);
        this.myLookupStartMarker = this.createLeftGreedyMarker(caret);
        this.myEditor.getDocument().addDocumentListener((DocumentListener)this);
    }

    public void documentChanged(@NotNull DocumentEvent e) {
        if (this.myStartMarkerDisposeInfo == null && !this.myLookupStartMarker.isValid()) {
            Throwable throwable = new Throwable();
            String eString = e.toString();
            this.myStartMarkerDisposeInfo = () -> eString + "\n" + ExceptionUtil.getThrowableText((Throwable)throwable);
        }
    }

    private RangeMarker createLeftGreedyMarker(int start2) {
        RangeMarker marker = this.myEditor.getDocument().createRangeMarker(start2, start2);
        marker.setGreedyToLeft(true);
        return marker;
    }

    private int getPivotOffset() {
        return this.myEditor.getSelectionModel().hasSelection() ? this.myEditor.getSelectionModel().getSelectionStart() : this.myEditor.getCaretModel().getOffset();
    }

    @NotNull
    public String getAdditionalPrefix() {
        return this.myAdditionalPrefix;
    }

    public void appendPrefix(char c) {
        this.myAdditionalPrefix = this.myAdditionalPrefix + c;
    }

    public boolean truncatePrefix() {
        int len = this.myAdditionalPrefix.length();
        if (len == 0) {
            ++this.myRemovedPrefix;
            return false;
        }
        this.myAdditionalPrefix = this.myAdditionalPrefix.substring(0, len - 1);
        return true;
    }

    void destabilizeLookupStart() {
        this.myStableStart = false;
    }

    void checkMinPrefixLengthChanges(Collection<? extends LookupElement> items, LookupImpl lookup2) {
        if (this.myStableStart) {
            return;
        }
        if (!lookup2.isCalculating() && !items.isEmpty()) {
            this.myStableStart = true;
        }
        int minPrefixLength = items.isEmpty() ? 0 : Integer.MAX_VALUE;
        for (LookupElement lookupElement : items) {
            if (lookupElement instanceof EmptyLookupItem) continue;
            minPrefixLength = Math.min(lookup2.itemMatcher(lookupElement).getPrefix().length(), minPrefixLength);
        }
        int start2 = this.getPivotOffset() - minPrefixLength - this.myAdditionalPrefix.length() + this.myRemovedPrefix;
        start2 = MathUtil.clamp((int)start2, (int)0, (int)this.myEditor.getDocument().getTextLength());
        if (this.myLookupStartMarker.isValid() && this.myLookupStartMarker.getStartOffset() == start2 && this.myLookupStartMarker.getEndOffset() == start2) {
            return;
        }
        this.myLookupStartMarker.dispose();
        this.myLookupStartMarker = this.createLeftGreedyMarker(start2);
        this.myStartMarkerDisposeInfo = null;
    }

    int getLookupStart(@Nullable Throwable disposeTrace) {
        if (!this.myLookupStartMarker.isValid()) {
            throw new AssertionError((Object)("Invalid lookup start: " + this.myLookupStartMarker + ", " + this.myEditor + ", disposeTrace=" + (disposeTrace == null ? null : ExceptionUtil.getThrowableText((Throwable)disposeTrace)) + "\n================\n start dispose trace=" + (this.myStartMarkerDisposeInfo == null ? null : this.myStartMarkerDisposeInfo.get())));
        }
        return this.myLookupStartMarker.getStartOffset();
    }

    int getLookupOriginalStart() {
        return this.myLookupOriginalStartMarker.isValid() ? this.myLookupOriginalStartMarker.getStartOffset() : -1;
    }

    boolean performGuardedChange(Runnable change) {
        if (!this.myLookupStartMarker.isValid()) {
            throw new AssertionError((Object)("Invalid start: " + this.myEditor + ", trace=" + (this.myStartMarkerDisposeInfo == null ? null : this.myStartMarkerDisposeInfo.get())));
        }
        change.run();
        return this.myLookupStartMarker.isValid();
    }

    void clearAdditionalPrefix() {
        this.myAdditionalPrefix = "";
        this.myRemovedPrefix = 0;
    }

    void disposeMarkers() {
        this.myEditor.getDocument().removeDocumentListener((DocumentListener)this);
        this.myLookupStartMarker.dispose();
        this.myLookupOriginalStartMarker.dispose();
    }

    public int getPrefixLength(LookupElement item, LookupImpl lookup2) {
        return lookup2.itemPattern(item).length() - this.myRemovedPrefix;
    }
}

