/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.intention.impl.config;

import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorGutter;
import com.intellij.openapi.editor.EditorKind;
import com.intellij.openapi.editor.EditorSettings;
import com.intellij.openapi.editor.FoldingModel;
import com.intellij.openapi.editor.IndentsModel;
import com.intellij.openapi.editor.InlayModel;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.ScrollingModel;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.editor.SoftWrapModel;
import com.intellij.openapi.editor.VisualPosition;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.event.EditorMouseEventArea;
import com.intellij.openapi.editor.event.EditorMouseListener;
import com.intellij.openapi.editor.event.EditorMouseMotionListener;
import com.intellij.openapi.editor.markup.MarkupModel;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.psi.PsiFile;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import javax.swing.JComponent;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LazyEditor
extends UserDataHolderBase
implements Editor {
    private final PsiFile myFile;
    private Editor myEditor;

    public LazyEditor(PsiFile file2) {
        this.myFile = file2;
    }

    private Editor getEditor() {
        if (this.myEditor == null) {
            Project project = this.myFile.getProject();
            this.myEditor = FileEditorManager.getInstance((Project)project).openTextEditor(new OpenFileDescriptor(project, this.myFile.getVirtualFile(), 0), false);
            assert (this.myEditor != null);
        }
        return this.myEditor;
    }

    @NotNull
    public Document getDocument() {
        return this.getEditor().getDocument();
    }

    public boolean isViewer() {
        return this.getEditor().isViewer();
    }

    @NotNull
    public JComponent getComponent() {
        return this.getEditor().getComponent();
    }

    @NotNull
    public JComponent getContentComponent() {
        return this.getEditor().getContentComponent();
    }

    public void setBorder(@Nullable Border border) {
        this.getEditor().setBorder(border);
    }

    public Insets getInsets() {
        return this.getEditor().getInsets();
    }

    @NotNull
    public SelectionModel getSelectionModel() {
        return this.getEditor().getSelectionModel();
    }

    @NotNull
    public MarkupModel getMarkupModel() {
        return this.getEditor().getMarkupModel();
    }

    @NotNull
    public FoldingModel getFoldingModel() {
        return this.getEditor().getFoldingModel();
    }

    @NotNull
    public ScrollingModel getScrollingModel() {
        return this.getEditor().getScrollingModel();
    }

    @NotNull
    public CaretModel getCaretModel() {
        return this.getEditor().getCaretModel();
    }

    @NotNull
    public SoftWrapModel getSoftWrapModel() {
        return this.getEditor().getSoftWrapModel();
    }

    @NotNull
    public InlayModel getInlayModel() {
        return this.getEditor().getInlayModel();
    }

    @NotNull
    public EditorKind getEditorKind() {
        return this.getEditor().getEditorKind();
    }

    @NotNull
    public EditorSettings getSettings() {
        return this.getEditor().getSettings();
    }

    @NotNull
    public EditorColorsScheme getColorsScheme() {
        return this.getEditor().getColorsScheme();
    }

    public int getLineHeight() {
        return this.getEditor().getLineHeight();
    }

    @NotNull
    public Point logicalPositionToXY(@NotNull LogicalPosition pos) {
        return this.getEditor().logicalPositionToXY(pos);
    }

    public int logicalPositionToOffset(@NotNull LogicalPosition pos) {
        return this.getEditor().logicalPositionToOffset(pos);
    }

    @NotNull
    public VisualPosition logicalToVisualPosition(@NotNull LogicalPosition logicalPos) {
        return this.getEditor().logicalToVisualPosition(logicalPos);
    }

    @NotNull
    public Point visualPositionToXY(@NotNull VisualPosition visible) {
        return this.getEditor().visualPositionToXY(visible);
    }

    @NotNull
    public Point2D visualPositionToPoint2D(@NotNull VisualPosition pos) {
        return this.getEditor().visualPositionToPoint2D(pos);
    }

    @NotNull
    public LogicalPosition visualToLogicalPosition(@NotNull VisualPosition visiblePos) {
        return this.getEditor().visualToLogicalPosition(visiblePos);
    }

    @NotNull
    public LogicalPosition offsetToLogicalPosition(int offset) {
        return this.getEditor().offsetToLogicalPosition(offset);
    }

    @NotNull
    public VisualPosition offsetToVisualPosition(int offset) {
        return this.getEditor().offsetToVisualPosition(offset);
    }

    @NotNull
    public VisualPosition offsetToVisualPosition(int offset, boolean leanForward, boolean beforeSoftWrap) {
        return this.getEditor().offsetToVisualPosition(offset, leanForward, beforeSoftWrap);
    }

    @NotNull
    public LogicalPosition xyToLogicalPosition(@NotNull Point p) {
        return this.getEditor().xyToLogicalPosition(p);
    }

    @NotNull
    public VisualPosition xyToVisualPosition(@NotNull Point p) {
        return this.getEditor().xyToVisualPosition(p);
    }

    @NotNull
    public VisualPosition xyToVisualPosition(@NotNull Point2D p) {
        return this.getEditor().xyToVisualPosition(p);
    }

    public void addEditorMouseListener(@NotNull EditorMouseListener listener2) {
        this.getEditor().addEditorMouseListener(listener2);
    }

    public void removeEditorMouseListener(@NotNull EditorMouseListener listener2) {
        this.getEditor().removeEditorMouseListener(listener2);
    }

    public void addEditorMouseMotionListener(@NotNull EditorMouseMotionListener listener2) {
        this.getEditor().addEditorMouseMotionListener(listener2);
    }

    public void removeEditorMouseMotionListener(@NotNull EditorMouseMotionListener listener2) {
        this.getEditor().removeEditorMouseMotionListener(listener2);
    }

    public boolean isDisposed() {
        return this.getEditor().isDisposed();
    }

    @Nullable
    public Project getProject() {
        return this.getEditor().getProject();
    }

    public boolean isInsertMode() {
        return this.getEditor().isInsertMode();
    }

    public boolean isColumnMode() {
        return this.getEditor().isColumnMode();
    }

    public boolean isOneLineMode() {
        return this.getEditor().isOneLineMode();
    }

    @NotNull
    public EditorGutter getGutter() {
        return this.getEditor().getGutter();
    }

    @Nullable
    public EditorMouseEventArea getMouseEventArea(@NotNull MouseEvent e) {
        return this.getEditor().getMouseEventArea(e);
    }

    public void setHeaderComponent(@Nullable JComponent header2) {
        this.getEditor().setHeaderComponent(header2);
    }

    public boolean hasHeaderComponent() {
        return this.getEditor().hasHeaderComponent();
    }

    @Nullable
    public JComponent getHeaderComponent() {
        return this.getEditor().getHeaderComponent();
    }

    @NotNull
    public IndentsModel getIndentsModel() {
        return this.getEditor().getIndentsModel();
    }

    public int getAscent() {
        return this.getEditor().getAscent();
    }
}

